<?php

namespace App\Http\Controllers;

use App\Models\Block;
use App\Models\Slide;
use App\Models\Conference;
use Illuminate\Http\Request;

class HomeController extends Controller
{
  public $conference_id = 1;

  public function home($lang)
  {

    if (!in_array($lang, ['en', 'ar'])) {
      abort(400);
    }

    app()->setLocale($lang);

    $this->conference_id = env('CONFERENCE_ID');

    $slides = Slide::where('conference_id', $this->conference_id)->get();
    $cblocks = Block::where(['direction' => 'center', 'conference_id' => $this->conference_id])->get();
    $rblocks = Block::where(['direction' => 'right', 'conference_id' => $this->conference_id])->get();
    $data['conference'] = Conference::where('id', $this->conference_id)->first();

    return view('home', ['cblocks' => $cblocks, 'rblocks' => $rblocks, 'slides' => $slides, $data]);
  }

  public function changeLocale()
  {
    return redirect()->route('home', app()->getLocale());
  }
   
  public function team($lang){
    if (!in_array($lang, ['en', 'ar'])) {
      abort(400);
    }

    app()->setLocale($lang);
    return view('home.team');
  }
  
}
