<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Conference;
use App\Models\Page;
use Illuminate\Support\Facades\App;
use App\Models\MenuItem;
class PagesController extends Controller
{
    private $conference_id;

    public function __construct()
    {
        $this->conference_id = env('CONFERENCE_ID');
    }
    public function show($lang,$slug)
    {
        if (! in_array($lang, ['en', 'ar'])) {
            abort(400);
        }
    
        App::setLocale($lang);

        $data['conference'] =Conference::where('id', $this->conference_id)->first();
        $data['page'] = Page::where(['slug' => $slug, 'conference_id' => $this->conference_id])->first();
        return view('page.show', $data);
    }


 

}
