<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MenuItem extends Model
{
    use SoftDeletes;
    protected $table = 'website_menu_item';

    public function getTitleAttribute()
    {
        if (app()->getLocale() == 'ar') {
            return $this->name;
        } else {
            return $this->ename;
        }
    }
    
    public function getLinkAttribute()
    {
        if (app()->getLocale() == 'ar') {
            return $this->url_ar;
        } else {
            return $this->url_en;
        }
    }

    public function parent()
    {
      return $this->belongsTo('App\Models\MenuItem', 'parent_id');
    }
  
    public function children()
    {
      return $this->hasMany('App\Models\MenuItem', 'parent_id');
    }

    
}
