<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>" <?php if(app()->getLocale() == 'ar'): ?> dir="rtl" <?php endif; ?>>
<?php

$conference = \App\Models\Conference::find(env('CONFERENCE_ID'));
$conference_id = $conference->id;
if (app()->getLocale() == 'ar') {
    $university_title = 'جامعة البصرة';
} else {
    $university_title = 'university of basrah';
}

$menuItems = \App\Models\MenuItem::with(['children', 'children.children'])
    ->where(['active' => 1, 'website_id' => $conference->id, 'website_menu_id' => 1, 'parent_id' => 0])
    ->orderBy('item_order', 'asc')
    ->limit(10)
    ->get();
?>

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <title><?php echo e($conference->name); ?></title>

    <?php if(app()->getLocale() == 'ar'): ?>
        <link rel="stylesheet" href="https://cdn.rtlcss.com/bootstrap/v4.5.3/css/bootstrap.min.css" />
    <?php else: ?>
        <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" />
    <?php endif; ?>
    <link rel="stylesheet" href="/assets/site.css">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="">
    <meta name="keywords" content="">
</head>

<body>




    <?php echo $__env->make('layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="container-fluid">
        <main role="main" class="pb-3">

            <br>
            <div class="container text-justify">
                <?php echo $__env->yieldContent('content'); ?>
            </div>
            <br>

        </main>
    </div>
    <?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <script src="https://code.jquery.com/jquery-3.2.1.slim.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js"></script>

    <?php if(app()->getLocale() == 'ar'): ?>
        <script src="https://cdn.rtlcss.com/bootstrap/v4.5.3/js/bootstrap.bundle.min.js"></script>
    <?php else: ?>
        <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"></script>
    <?php endif; ?>

    <script src="./assets/site.js"></script>


</body>

</html>
<?php /**PATH /home/ecology/conference/resources/views/layouts/master.blade.php ENDPATH**/ ?>