<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Home extends Base_Controller {

    public function index()
    {
        $data['core_data'] = $this->load_site_core();

        $qry = $this->db->query("SELECT id, title, thumb, external_link FROM news WHERE news_type_id = 5 and lang_filter IN (1,2) ORDER BY id DESC LIMIT 10");
        $data['banner_data'] = $qry->result_array();

        $qry = $this->db->query("SELECT id, title, external_link FROM news WHERE news_type_id = 4 and lang_filter IN (1,2) ORDER BY id DESC LIMIT 5");
        $data['latest_announcements'] = $qry->result_array();

        $qry = $this->db->query("SELECT id, title, external_link FROM news WHERE news_type_id = 5 and lang_filter IN (1,2) ORDER BY id DESC LIMIT 5");
        $data["latest_news"] = $qry->result_array();

        $qry = $this->db->query("SELECT id, title, description, DATE_FORMAT(news_date, '%d %M, %Y') as news_date, external_link FROM news WHERE is_imp = 1 and lang_filter IN (1,2) ORDER BY id DESC LIMIT 20");
        $data["important_news"] = $qry->result_array();     

        $qry = $this->db->query('SELECT * FROM home_blocks ORDER BY id ASC');
        $data['home_blocks'] = $qry->result_array();

        $this->load->view('home', $data);	
    }

    public function txt_page_view($txt_page = '', $news_id = 0)
    {
        $txt_page = $this->db->escape_str($txt_page);
        $qry = $this->db->query("SELECT * FROM news_type WHERE url = '".$txt_page."' ");
        $news_type_data = $qry->row_array();
        if(is_array($news_type_data) && count($news_type_data) > 0)
        {
            if($news_id != 0)
            {
                $news_id = (int) $news_id;

                $data['core_data'] = $this->load_site_core();        

                $qry = $this->db->query("SELECT id, news_type_id, title, thumb, pdf, DATE_FORMAT(news_date, '%d %M, %Y') as news_date, description FROM news WHERE id = $news_id LIMIT 1");
                $data['news_row'] = $qry->row_array();
                $news_type_id = $data['news_row']['news_type_id'];

                $qry = $this->db->query("SELECT name, url FROM news_type WHERE id = $news_type_id");
                $data['news_type_data'] = $qry->row_array();
                if($data['news_type_data']['url'] == "news")
                {
                    $data['news_type_data']['url'] = "latest-university-news";    
                }
                

                $data['core_data']['page_data']['title'] = substr($data['news_row']['title'], 0, 50);
                $data['core_data']['page_data']['meta_description'] = str_replace("\n", " ", strip_tags(substr($data['news_row']['description'], 0, 500)));

                $qry = $this->db->query("SELECT * FROM news_pictures WHERE news_id = $news_id");
                $data["news_pictures"] = $qry->result_array();

                $this->load->view('news_detail', $data); 
            }
            else{
                $url_key = $txt_page;
                $data['core_data'] = $this->load_site_core();
                $data['url_key'] = $url_key;
                
                $qry = $this->db->query("SELECT id FROM news_type WHERE url = '$url_key' LIMIT 1");
                $news_type_data = $qry->row_array();
                $news_type_id = $news_type_data['id'];

                $qry = $this->db->query("SELECT id, news_type_id, title, thumb, pdf, DATE_FORMAT(news_date, '%d %M, %Y') as news_date, external_link FROM news WHERE news_type_id = $news_type_id and lang_filter IN (1,2) ORDER BY id DESC");
                $data['news_list'] = $qry->result_array();

                $this->load->view('news_list', $data);
            }
        }
        else{
            $data['core_data'] = $this->load_site_core();
            $data['parent_link'] = '';
            $qry = $this->db->query("SELECT page_id FROM links_data WHERE link_id = (SELECT parent_id FROM links_data WHERE page_id = ".$data["core_data"]["page_data"]["page_data_id"]." LIMIT 1)");
            $parent_info = $qry->row_array();
            if(count($parent_info) > 0 && $parent_info["page_id"] != 0)
            {
                $qry = $this->db->query("SELECT title, page_url FROM pages_data WHERE page_data_id = ".$parent_info["page_id"]);
                $title_data = $qry->row_array();
                $data['parent_link'] = '<li><a href="'.BASE_URL.$title_data["page_url"].'">'.$title_data["title"].'</a></li>';
            }

            $qry = $this->db->query("SELECT * FROM form_data WHERE page_id = ".$data["core_data"]["page_data"]["page_data_id"] ." LIMIT 1");
            $result_data = $qry->row_array();

            if(count($result_data) > 0)
            {
                $data['core_data']['form_data'] = $result_data;
            }

            $this->load->view('txt_page', $data);
        }
    }

    public function certificates()
    {
        $data['core_data'] = $this->load_site_core();
        $qry = $this->db->query("SELECT * FROM certificates ORDER BY id DESC");
        $data['certificates_list'] = $qry->result_array();
        $this->load->view('certificates', $data);    
    }

    public function trainee($trainee_id)
    {
        $trainee_id = (int) $trainee_id;
        $data['core_data'] = $this->load_site_core();
        $qry = $this->db->query("SELECT * FROM trainee WHERE id = $trainee_id");
        $data['trainee_info'] = $qry->row_array();
        $qry = $this->db->query("SELECT id, trainee_id, cert_name, DATE_FORMAT(cert_date, '%d %M, %Y') as cert_date FROM certificates WHERE trainee_id = $trainee_id");
        $data['certificates_list'] = $qry->result_array();
        $this->load->view('trainee', $data);         
    }

    public function show_page($page)
    {
        $data['core_data'] = $this->load_site_core();
        $this->load->view($page, $data);        
    }
    
    public function logout()
    {
        if(isset($_SESSION['loginUser']))
        {
            unset($_SESSION['loginUser']);
            unset($_SESSION['loginUserName']);
            header('location:'.BASE_URL);
        }
    }

    public function login_process()
    {
        if(isset($_SESSION['max_attempts']) && $_SESSION['max_attempts'] > MAX_FAILED_LOGIN)
        {
            if(isset($_POST['g-recaptcha-response']) && $_POST['g-recaptcha-response']){
                $secret = "6LceIQgUAAAAACULSgeU7xyQTL5eWF07ngNHJW6R";
                $remote_ip = $_SERVER['REMOTE_ADDR'];
                $captcha = $_POST['g-recaptcha-response'];

                $ch = curl_init();
                curl_setopt($ch, CURLOPT_HEADER, 0);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_URL, "https://www.google.com/recaptcha/api/siteverify?secret=$secret&response=$captcha&remoteip=$remote_ip");
                $result_str = curl_exec($ch);
                curl_close($ch);
            
                $jresult = json_decode($result_str, TRUE);
                if(!$jresult['success']){
                    die("failed-validation");
                }
            }
            else{
                die("failed-validation");
            }  
        }      

        $u_email =  $this->db->escape_str($_POST['u_email']);
        $u_email = trim($u_email);

        // Remove all illegal characters from email
        $u_email = filter_var($u_email, FILTER_SANITIZE_EMAIL);

        // Validate e-mail
        if(!filter_var($u_email, FILTER_VALIDATE_EMAIL)) {
            die("invalidate_email");     
        }

        $u_password = $this->db->escape_str($_POST['u_password']);
        $u_password = trim($u_password);   

        if(trim($u_password) != "")
        {
            //$hash_password = password_hash($u_password, PASSWORD_DEFAULT);
            $qry = "SELECT * FROM user_registration WHERE email_id = '$u_email' && active_status = 1 LIMIT 1";
            $result_obj = $this->db->query($qry);        
            $login_data = $result_obj->row_array();

            if(count($login_data) > 0)
            {
                $hashed_password = $login_data['u_password'];
                if (password_verify($u_password, $hashed_password)) {
                    $_SESSION['loginUser'] = $login_data['id'];
                    $_SESSION['loginUserName'] = $login_data['name'];
                    unset($_SESSION['max_attempts']);
                   die("login-success");
                }
                else{
                    if(!isset($_SESSION['max_attempts']))
                    {
                        $_SESSION['max_attempts'] = 1;   
                    }
                    else{
                        $_SESSION['max_attempts']++;   
                    }

                    if($_SESSION['max_attempts'] == MAX_FAILED_LOGIN)
                    {
                        die("activate-captcha");
                    }
                    else{
                        die("invalid-login");
                    } 
                } 
            }
            else{
                if(!isset($_SESSION['max_attempts']))
                {
                    $_SESSION['max_attempts'] = 1;   
                }
                else{
                    $_SESSION['max_attempts']++;   
                }

                if($_SESSION['max_attempts'] == MAX_FAILED_LOGIN)
                {
                    die("activate-captcha");
                }
                else{
                    die("no_user");
                }                
            }         
        }                   
    }

    public function process_change_password()
    {
        if(!isset($_SESSION['loginUser'])){
            return false;
        }
 
        $old_password = trim($_POST['old_password']);
        $old_password = $this->db->escape_str($old_password);

        $new_password = trim($_POST['new_password']);
        $new_password = $this->db->escape_str($new_password);        

        $confirm_password = trim($_POST['confirm_password']);
        $confirm_password = $this->db->escape_str($confirm_password);

        $login_user_id = $_SESSION['loginUser'];
        $qry = "SELECT * FROM user_registration WHERE id = $login_user_id LIMIT 1";
        $result_obj = $this->db->query($qry);        
        $login_data = $result_obj->row_array();   

        if(count($login_data) > 0)
        {
            $hashed_password = $login_data['u_password'];
            if (!password_verify($old_password, $hashed_password)) {
               die("old_password_not_matched");
            }
            else{
                if($new_password != "")
                {
                    $final_password = password_hash($new_password, PASSWORD_DEFAULT);
                    $qry = "UPDATE user_registration SET u_password = '$final_password' WHERE id = $login_user_id";
                    $result = $this->db->query($qry);
                    if($result)
                    {
                        die("changed_success");
                    }
                }                
            }
        }             
    }

    public function register_process()
    {
        if(isset($_POST['g-recaptcha-response']) && $_POST['g-recaptcha-response']){
            $secret = "6LceIQgUAAAAACULSgeU7xyQTL5eWF07ngNHJW6R";
            $remote_ip = $_SERVER['REMOTE_ADDR'];
            $captcha = $_POST['g-recaptcha-response'];
            
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HEADER, 0);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_URL, "https://www.google.com/recaptcha/api/siteverify?secret=$secret&response=$captcha&remoteip=$remote_ip");
            $result_str = curl_exec($ch);
            curl_close($ch);

            $jresult = json_decode($result_str, TRUE);
            if(!$jresult['success']){
                die("failed-validation");
            }
        }
                
        $u_email =  $this->db->escape_str($_POST['u_email']);
        $u_email = trim($u_email);

        // Remove all illegal characters from email
        $u_email = filter_var($u_email, FILTER_SANITIZE_EMAIL);

        // Validate e-mail
        if(!filter_var($u_email, FILTER_VALIDATE_EMAIL)) {
            die("invalidate_email");     
        }

        $u_password = $this->db->escape_str($_POST['u_password']);
        $u_password = trim($u_password);

        $u_confirm_password = $this->db->escape_str($_POST['u_confirm_password']);
        $u_confirm_password = trim($u_confirm_password);

        if(trim($u_password) != "" && ($u_password == $u_confirm_password))
        {
            $hash_password = password_hash($u_password, PASSWORD_DEFAULT);
        }
        else{
            die("password_not_matched");
        }

        $u_name = $this->db->escape_str($_POST['u_name']);
        $u_gender = $this->db->escape_str($_POST['u_gender']);        

        if($u_name != "" && $u_gender != "" && $u_email != "")
        {
            $qry = "SELECT id FROM user_registration WHERE email_id = '$u_email'";
            $result = $this->db->query($qry);
            $result_data = $result->row_array();

            if(count($result_data) > 0)
            {
                die("record_exists");
            }

            $salt = uniqid();
            $qry = "INSERT INTO user_registration SET name='$u_name', gender='$u_gender', email_id='$u_email', salt = '$salt', u_password='$hash_password', created_on = NOW(), active_status = 0";
            $result = $this->db->query($qry);

            if($result)
            {
                $mail_title = 'Confirmation Link from ASAS Video On Demand';
                $insert_id = $this->db->insert_id();
                $crypt_key = $insert_id.$salt;
                $final_crypt_key = password_hash($crypt_key, PASSWORD_DEFAULT);
                $final_crypt_key = urlencode($final_crypt_key);
                $mail_msg = '<a target="_blank" href="'.BASE_URL.'user-activation/'.$insert_id.'/'.$final_crypt_key.'">Click here for activation</a>';
                $this->send_email($u_email, $u_name, $mail_title, $mail_msg);
            }
        }
    }

    public function user_activation($user_id, $encrypt_string)
    {
        $user_id = (int) $user_id;
        $qry = "SELECT id, salt FROM user_registration WHERE id = $user_id";
        $result_obj = $this->db->query($qry);
        $user_data = $result_obj->row_array();        

        $key = $user_id.$user_data['salt'];
        $encrypt_string = urldecode($encrypt_string);

        if (password_verify($key, $encrypt_string)) {
            $qry = "UPDATE user_registration SET active_status = 1 WHERE id = $user_id";
            $this->db->query($qry);
            header('location:'.BASE_URL.'login?verify=1');
        }        
    }

    public function contact()
    {
        $data['core_data'] = $this->load_site_core();                
        $this->load->view('contact', $data);                
    }

    public function your_opinion(){
        $data['core_data'] = $this->load_site_core();                
        $this->load->view('your_opinion', $data);         
    }

    public function form_builder_process()
    {
        $sec_code_ul = $this->input->post("sec_code");
        $captcha_code = trim($_SESSION['captcha']);  
        
        if($sec_code_ul != $captcha_code || $captcha_code == "")
        {
            $_SESSION['captcha'] = "";
            echo "invalid_captcha";
            return false;
        }
        $page_id = (int) $_POST["page_id"];

        $qry = $this->db->query("SELECT table_name FROM form_data WHERE page_id = $page_id");
        $table_name_data = $qry->row_array();
        $table_name = $table_name_data["table_name"];

        unset($_POST['page_id']);
        unset($_POST['sec_code']);

        foreach ($_POST as $p_key => $p_val) {            
            if(is_array($p_val))
            {
                $p_val = implode(', ', $p_val);
            }
            
            $p_key = $this->db->escape_str($p_key);            
            $p_val = $this->db->escape_str($p_val);                
            $_POST[$p_key] = $p_val;            
        }
          
        $this->db->insert($table_name, $_POST); 
        $insert_id = $this->db->insert_id();            
        echo $insert_id;
    }

    public function show_all_people()
    {
        $qry = $this->db->query("SELECT * FROM people LIMIT 1000");
        $data['staff_list'] = $qry->result_array();

        $data['core_data'] = $this->load_site_core();

        $this->load->view('people', $data);
    }

    public function people($people_id)
    {
        $people_id = (int) $people_id;

        $qry = $this->db->query("SELECT * FROM people WHERE id = $people_id LIMIT 1");
        $data['people'] = $qry->row_array();
        $data['people_id'] = $people_id;

        $data['core_data'] = $this->load_site_core();

        $data['core_data']['page_data']['title'] = $data['people']['name'];
        $this->load->view('people', $data);
    }

    public function search()
    {
        $s_query = $this->db->escape_str($this->input->get('sq'));
        $sq_type = $this->db->escape_str($this->input->get('sq_type'));
        $data['core_data'] = $this->load_site_core();   

        if($sq_type == "people")
        {
            $data['search_result_arr'] = array();
            if(isset($s_query) && trim($s_query) != "")
            {            
                $qry = $this->db->query("SELECT * FROM people WHERE name like '%".$s_query."%' or keywords like '%".$s_query."%' ");
                $data['search_result_arr'] = $qry->result_array();
                if(count($data['search_result_arr']) == 0)
                {
                    $data['search_result_msg'] = '<h2> No results found </h2>';
                } 
            } 
            else
            {
                $data['search_result_msg'] = '<h2> Search term can not be empty </h2>';
            }                       
        }
        else if($sq_type == "certificates")
        {
            $data['search_result_arr'] = array();
            if(isset($s_query) && trim($s_query) != "")
            {            
                $qry = $this->db->query("SELECT * FROM certificates WHERE trainee_id like '%".$s_query."%' or cert_id like '%".$s_query."%' or cert_name like '%".$s_query."%' ");
                $data['search_result_arr'] = $qry->result_array();
                if(count($data['search_result_arr']) == 0)
                {
                    $data['search_result_msg'] = '<h2> No results found </h2>';
                } 
            } 
            else
            {
                $data['search_result_msg'] = '<h2> Search term can not be empty </h2>';
            }                       
        }        
        else
        {
            $data['search_result_arr'] = array();
            if(isset($s_query) && trim($s_query) != "")
            {
                $qry = $this->db->query("SELECT title, page_url FROM pages_data WHERE (title like '%".$s_query."%' or MATCH(description, description_ar) AGAINST ('".$s_query."')) and page_url NOT IN ('download_file', 'search')");
                $data['search_result_arr'] = $qry->result_array();
                
                $qry = $this->db->query("SELECT title, CONCAT('news/', id) as page_url FROM news WHERE (title like '%".$s_query."%' or MATCH(description, description_ar) AGAINST ('".$s_query."'))");   
                $data['search_result_arr'] = array_merge($data['search_result_arr'], $qry->result_array());                
                if(count($data['search_result_arr']) == 0)
                {
                    $data['search_result_msg'] = '<h2> No results found </h2>';
                }                    
            }
            else
            {
                $data['search_result_msg'] = '<h2> Search term can not be empty </h2>';
            }
        }
        

        $this->load->view('search', $data);        
    }  

    public function contact_process()
    {       
        $this->load->helper('email');

        $u_name = $this->input->post("c_name");
        $u_email = $this->input->post("c_email");
        $u_mobile = $this->input->post("c_mobile");
        $u_company = '';
        if(isset($_POST["c_company"]))
        {
            $u_company = '<tr>
                            <td style="vertical-align:top;border:1px solid #aaaaaa;padding:10px;border-collapse:collapse;font-weight:bold;color:#000000;background-color:#eeeeee;">Company </td>
                            <td style="vertical-align:top;border:1px solid #aaaaaa;padding:10px;border-collapse:collapse;">'.$this->input->post("c_company").'</td>
                        </tr>';
        }
        $u_desc = $this->input->post("c_message");
        $sec_code_ul = $this->input->post("sec_code");
        $captcha_code = trim($_SESSION['captcha']);

        if(trim($u_name) == "")
        {
            echo "name_not_blank";
            return false;
        }

        $req_email = $u_email;

        if(!valid_email($req_email))
        {
            echo 'Email is Invalid';
            return false;
        }                            

        if($sec_code_ul != $captcha_code || $captcha_code == "")
        {
            $_SESSION['captcha'] = "";
            echo "invalid_captcha";
            return false;
        }


        $_SESSION['captcha'] = "";
        $mail_msg = '<table width="700" cellpadding="0" cellspacing="0" style="font-family:arial,verdana;font-size:13px;color:#555555;line-height:22px;border-collapse:collapse;">    
                            <tbody>
                                    <tr>
                                            <td style="padding:10px;border-collapse:collapse;font-weight:bold;color:#000000;background-color:#eeeeee;vertical-align:top;border:1px solid #aaaaaa;" width="140"> Contact Name </td>
                                            <td style="padding:10px;border-collapse:collapse;vertical-align:top;border:1px solid #aaaaaa;">'.$u_name.'</td>
                                    </tr>                   
                                    <tr>
                                            <td style="vertical-align:top;border:1px solid #aaaaaa;padding:10px;border-collapse:collapse;font-weight:bold;color:#000000;background-color:#eeeeee;" width="140">Email</td>
                                            <td style="vertical-align:top;border:1px solid #aaaaaa;padding:10px;border-collapse:collapse;">'.$u_email.'</td>
                                    </tr>
                                    <tr>
                                            <td style="vertical-align:top;border:1px solid #aaaaaa;padding:10px;border-collapse:collapse;font-weight:bold;color:#000000;background-color:#eeeeee;">Mobile No. </td>
                                            <td style="vertical-align:top;border:1px solid #aaaaaa;padding:10px;border-collapse:collapse;">'.$u_mobile.'</td>
                                    </tr>
                                    '.$u_company.'
                                    <tr>
                                            <td colspan="2" style="padding:0px;"> 
                                                    <div style="width:100%;"> 
                                                            <br/>
                                                            <table cellpadding="0" cellspacing="0" style="width:100%;font-family:arial,verdana;font-size:13px;color:#555555;line-height:22px;border-collapse:collapse;">
                                                                    <tbody>
                                                                            <tr>
                                                                                    <td style="padding:10px;border-collapse:collapse;font-weight:bold;color:#000000;background-color:#eeeeee;text-align:left;border-top:1px solid #aaaaaa;border-bottom:1px solid #aaaaaa;" colspan="2">User Query</td>
                                                                            </tr>
                                                                            <tr>
                                                                                    <td style="padding:10px;border-collapse:collapse;" colspan="2">'.$u_desc.'</td>
                                                                            </tr>                               
                                                                    </tbody>
                                                            </table>
                                                    </div>  
                                            </td>
                                    </tr>

                            </tbody>
                    </table>';
        
        if(isset($_POST["opinion"]) && $_POST["opinion"] == 1)
        {
            $mail_title = 'Opinion Email | Oil and Gas University';
        }
        else{
            $mail_title = 'Oil and Gas University | Enquiry Email';    
        }         

        $this->load->library('email');
        $config['mailtype'] = 'html';
        $config['wordwrap'] = TRUE;
        $this->email->initialize($config);  
        
        $this->email->from(EMAIL_SENDER, $u_name);              
        $this->email->to(EMAIL_RECIPIENT); 
        $this->email->subject($mail_title);
        $this->email->message($mail_msg);
        $this->email->send();                
    }

    public function download_file()
    {
        $file_name = $this->input->get('file_name');
        $file_name = urldecode($file_name);
        $file_fs = substr($file_name, 0, 1);
        if($file_fs == "/")
        {
            $file_name = $_SERVER['DOCUMENT_ROOT'].$file_name;                
        }
        else
        {
            $file_name = realpath(getcwd().'/'.$file_name);
        }
        
        $pathinfo_parts = pathinfo($file_name);
        if($pathinfo_parts['extension'] == "php")
        {
            die("<h1> Invalid file </h1>");
        }

        $file_name = str_replace(array("../",".."), "", $file_name);
        $save_name = str_replace(" ", "", basename($file_name));
        
        if (file_exists($file_name)) {
            header('Content-Description: File Transfer');
            header('Content-Type: application/octet-stream');
            header('Content-Disposition: attachment; filename='.basename($save_name));
            header('Expires: 0');
            header('Cache-Control: must-revalidate');
            header('Pragma: public');
            header('Content-Length: ' . filesize($file_name));
            readfile($file_name);
            exit;
        }                
    }       
}


