<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class News extends Base_Controller {

    public function show_list($url_key)
    {
        $data['core_data'] = $this->load_site_core();
        $data['url_key'] = $url_key;
        
        $qry = $this->db->query("SELECT id FROM news_type WHERE url = '$url_key' LIMIT 1");
        $news_type_data = $qry->row_array();
        $news_type_id = $news_type_data['id'];

        $qry = $this->db->query("SELECT id, news_type_id, title, thumb, pdf, DATE_FORMAT(news_date, '%d %M, %Y') as news_date, external_link FROM news WHERE news_type_id = $news_type_id and lang_filter IN (1,2) ORDER BY id DESC");
        $data['news_list'] = $qry->result_array();

        $this->load->view('news_list', $data);	
    } 

    public function news_detail($news_id)
    {
        $news_id = (int) $news_id;

        $data['core_data'] = $this->load_site_core();        

        $qry = $this->db->query("SELECT id, news_type_id, title, thumb, pdf, DATE_FORMAT(news_date, '%d %M, %Y') as news_date, description FROM news WHERE id = $news_id LIMIT 1");
        $data['news_row'] = $qry->row_array();
        $news_type_id = $data['news_row']['news_type_id'];

        $qry = $this->db->query("SELECT name, url FROM news_type WHERE id = $news_type_id");
        $data['news_type_data'] = $qry->row_array();
        if($data['news_type_data']['url'] == "news")
        {
            $data['news_type_data']['url'] = "latest-university-news";    
        }
        

        $data['core_data']['page_data']['title'] = substr($data['news_row']['title'], 0, 50);
        $data['core_data']['page_data']['meta_description'] = str_replace("\n", " ", strip_tags(substr($data['news_row']['description'], 0, 500)));

        $qry = $this->db->query("SELECT * FROM news_pictures WHERE news_id = $news_id");
        $data["news_pictures"] = $qry->result_array();

        $this->load->view('news_detail', $data);    
    } 

    public function news_page()
    {
        $data['core_data'] = $this->load_site_core();

        $url_key = 'news';
        $qry = $this->db->query("SELECT id FROM news_type WHERE url = '$url_key' LIMIT 1");
        $news_type_data = $qry->row_array();
        $news_type_id = $news_type_data['id'];

        $qry = $this->db->query("SELECT id, news_type_id, title, thumb, pdf, DATE_FORMAT(news_date, '%d %M, %Y') as news_date, description, external_link FROM news WHERE news_type_id = $news_type_id and lang_filter IN (1,2) ORDER BY id DESC LIMIT 10");
        $data['news_list'] = $qry->result_array();  

        $url_key = 'activities';
        $qry = $this->db->query("SELECT id FROM news_type WHERE url = '$url_key' LIMIT 1");
        $news_type_data = $qry->row_array();
        $news_type_id = $news_type_data['id'];

        $qry = $this->db->query("SELECT id, news_type_id, title, thumb, pdf, DATE_FORMAT(news_date, '%d %M, %Y') as news_date, description, external_link FROM news WHERE news_type_id = $news_type_id and lang_filter IN (1,2) ORDER BY id DESC LIMIT 4");
        $data['latest_activities'] = $qry->result_array();  

        $url_key = 'events';
        $qry = $this->db->query("SELECT id FROM news_type WHERE url = '$url_key' LIMIT 1");
        $news_type_data = $qry->row_array();
        $news_type_id = $news_type_data['id'];

        $qry = $this->db->query("SELECT id, news_type_id, title, thumb, pdf, DATE_FORMAT(news_date, '%d %M, %Y') as news_date, description, external_link FROM news WHERE news_type_id = $news_type_id and lang_filter IN (1,2) ORDER BY id DESC LIMIT 4");
        $data['latest_events'] = $qry->result_array();  

        $this->load->view('news_page', $data);      
    }     
}


