<?php
defined('BASEPATH') OR exit('No direct script access allowed');
require_once 'library/mpdf/mpdf.php';

class PrintDoc extends Base_Controller {
    public function export_pdf_doc($content, $file_name = 'export_user_data.pdf')
    {
	    $mpdf=new mPDF();
	    $mpdf->SetAutoFont('th');
	    $mpdf->WriteHTML($content);	    
	    $mpdf->Output($file_name, 'I');
    }

    public function save_pdf_doc($content, $file_name = 'save_user_data.pdf')
    {
	    $mpdf=new mPDF();
	    $mpdf->debug = true;
	    $mpdf->SetAutoFont('th');
	    $mpdf->WriteHTML($content);	    
	    $mpdf->Output($file_name, 'F');
    }

    public function print_pdf()
    {
    	$record_id = (int) $_GET['source'];
    	$page_id = (int) $_GET['page_id'];

        $qry = $this->db->query("SELECT title FROM pages_data WHERE page_data_id = $page_id");
        $title_data = $qry->row_array();
        $page_title = $title_data["title"];

        $qry = $this->db->query("SELECT table_name FROM form_data WHERE page_id = $page_id");
        $table_name_data = $qry->row_array();
        $table_name = $table_name_data["table_name"];   

        $qry = $this->db->query("SELECT * FROM $table_name WHERE id = $record_id"); 	
        $data = $qry->row_array();

        $qry = $this->db->query("show full columns from $table_name");
        $comment_data = $qry->result_array();

        $comment_array = array();
        foreach ($comment_data as $comment) {
            $comment_array[] = $comment['Comment'];
        }

        $tr_collection = '';
        $key = 0;
        foreach ($data as $dkey => $d_value) {
            $tr_collection .= '<tr><td>'.$comment_array[$key].'</td><td>'.$d_value.'</td></tr>';
            $key++;
        }

        $content = '<style type="text/css">
                        body{
                            font-family:verdana, arial;
                        }
                        h2{
                            margin-bottom:0px;
                        }
                        .f_table{
                            width:100%;
                        }
                        .f_table td{
                            padding:8px;                            
                        }
                        .f_table, .f_table td{
                            border:1px solid #333333;
                            border-collapse: collapse;
                        }
                    </style>';

        $content .= '<h2>'.$page_title.'</h2><hr/><table class="f_table">'.$tr_collection.'</table>';
        $this->export_pdf_doc($content);
    }
}