<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Base_Controller extends CI_Controller {
	
	public function __construct()
	{
        session_start();
		parent::__construct();
		$this->load->database();
		$this->load->helper('url');
	}
	public function load_site_core()
	{
		$c_uri_string = uri_string();
		$data['actual_url'] = $c_uri_string;
		if($c_uri_string != "")
		{
			$cur_page_arr = explode('/', $c_uri_string);
			$cur_page = $cur_page_arr[0];
		}
		else
		{
            $data['actual_url'] = 'home';
			$cur_page = 'home';
		}
        $data['cur_page'] = $cur_page;

		$qry = $this->db->get_where('pages_data', array('page_url'=>$cur_page));
		$page_data = $qry->row_array();
        if(count($page_data) == 0)
        {
        	show_404();
        }	

        if($page_data["is_protected"] == 1 and !isset($_SESSION['loginUser']))
        {
            header('location:'.BASE_URL.'login');
        }
        	
		$data['page_data'] = $page_data;

		$qry = $this->db->query('SELECT page_data_id, page_url FROM pages_data');
		$get_pages_url_data = $qry->result_array();

        $pages_url_data = array();
        foreach ($get_pages_url_data as $page_url) {
            $pages_url_data[$page_url["page_data_id"]] = $page_url["page_url"];
        }
        $data['pages_url_data'] = $pages_url_data;

		$qry = $this->db->query("SELECT ld.* FROM links_data ld LEFT JOIN links_data ld1 ON ld.link_id = ld1.parent_id ORDER BY ld.parent_id, ld.link_priority, ld.link_id");
		$links_data = $qry->result_array();

        $core_menu_arr = array();
        $menu_child_arr = array();

        foreach ($links_data as $links_row) {
            if($links_row["parent_id"] == 0)
            {
                $core_menu_arr[$links_row["link_id"]] = $links_row;
                if($links_row["page_id"] == $page_data["page_data_id"])
                {
                    $core_menu_arr[$links_row["link_id"]]["selected"] = 1;
                }                
            }
            else
            {
                $menu_child_arr[$links_row["parent_id"]][$links_row["link_id"]] = $links_row;
                if($links_row["page_id"] == $page_data["page_data_id"])
                {
                    $menu_child_arr[$links_row["parent_id"]][$links_row["link_id"]]["selected"] = 1;
                }                 
            }            
        }   

        $final_links_data_arr = array();

        foreach($core_menu_arr as $links_row)
        {
            if($links_row["parent_id"] != 0){ continue; }
            $final_links_data_arr[$links_row["link_id"]] = $core_menu_arr[$links_row["link_id"]];
        } 	

        $data['links_data'] = $final_links_data_arr;
        $data['menu_child'] = $menu_child_arr;

        $qry = $this->db->get('settings');
        $settings_data = $qry->result_array();
        $settings_arr = array();
        foreach ($settings_data as $setting_row) {
            $settings_arr[$setting_row['setting_name']] = $this->remove_all_tags($setting_row['setting_value']);
        }

        $data['settings_txt'] = $settings_arr;

        $qry = $this->db->get('image_settings');
        $image_settings_data = $qry->result_array();
        $image_settings_arr = array();
        foreach ($image_settings_data as $img_row) {
            $image_settings_arr[$img_row['setting_name']] = $img_row['setting_value'];
        }        

        $data['image_settings'] = $image_settings_arr;

        if(!isset($_SESSION["visitor_counter"]))
        {
            $qry = $this->db->query("UPDATE visitors SET visitor_counter = visitor_counter+1");                        
            $_SESSION["visitor_counter"] = 'set';   
        }

        $qry = $this->db->query('SELECT * FROM footer_links ORDER BY priority ASC');
        $data['footer_links_data'] = $qry->result_array();

        $qry = $this->db->query("SELECT visitor_counter FROM visitors LIMIT 1");  
        $visitor_counter = $qry->row_array();      
        $data['visitor_counter'] = $visitor_counter['visitor_counter'];  
        
		return $data;
	}

    public function remove_p_tags($target_str)
    {
        $target_str = str_replace('<p>', '', $target_str); 
        $target_str = str_replace('</p>', '', $target_str); 
        return trim($target_str);
    }

    public function remove_all_tags($target_str)
    { 
        $target_str = strip_tags($target_str);
        return trim($target_str);
    } 

    public function send_email($email_receipient, $email_name, $mail_title, $mail_msg)
    {
        $this->load->helper('email');
        $this->load->library('email');
        $config['mailtype'] = 'html';
        $config['wordwrap'] = TRUE;
        $this->email->initialize($config);  
        
        $this->email->from(EMAIL_SENDER, $email_name);              
        $this->email->to($email_receipient); 
        $this->email->subject($mail_title);
        $this->email->message($mail_msg);
        $this->email->send();        
    }              
}

?>