<?php
  if($core_data['cur_page'] == "university-issuances-news"):
    header('location:'.BASE_URL.'news-detail/'.$issuance_id);
  endif;
?>
<?php $this->load->view('inc_files/site_header', $core_data); ?>
<div class="breadcrumbs">
    <div class="container">
        <h1 class="pull-left"><?php echo $core_data['page_data']['title']; ?></h1>
        <ul class="pull-right breadcrumb">
            <li><a href="<?php echo BASE_URL; ?>">Home</a></li>
            <li class="active"><?php echo $core_data['page_data']['title']; ?></li>
        </ul>
    </div>
</div>
<div class="container pg_min_ht">
  <div class="row">
    <div class="col-lg-12 col-md=12 col-xs-12">
      <div class="home_block" id="university_news_block">
        <a href="<?php echo BASE_URL.'latest-university-news'; ?>"><h2><?php echo $core_data['settings_txt']['LATEST_NEWS_UNIVERSITY']; ?></h2></a>
        <div>
          <ul>
          <?php
            foreach ($news_list as $u_news) {

              $news_link = BASE_URL.'news/'.$u_news['id'];
              if(trim($u_news["external_link"]) != "")
              {
                $news_link = trim($u_news["external_link"]);
              }              
          ?>
            <li>
              <a href="<?php echo $news_link; ?>">
              <img src="<?php echo UPLOADS_URL.'news/thumb/'.$u_news["thumb"]; ?>" alt="<?php echo $u_news["title"]; ?>" />
              <h3><?php echo $u_news["title"]; ?></h3>
              <p><?php echo substr(strip_tags($u_news["description"]), 0, 350); ?>... </p>
              </a>
            </li>
          <?php
            }
          ?>
          </ul>
        </div>
      </div> 
    </div>
  </div>
  <div class="row">
    <div class="col-lg-6 col-md-6 col-xs-12">
      <div class="home_block" id="latest_activities_block">
        <a href="<?php echo BASE_URL.'activities'; ?>"><h2><?php echo $core_data['settings_txt']['LATEST_ACTIVITIES']; ?></h2></a>
        <div>
          <ul>
          <?php
            foreach ($latest_activities as $activity) {

              $news_link = BASE_URL.'activities/'.$activity['id'];
              if(trim($activity["external_link"]) != "")
              {
                $news_link = trim($activity["external_link"]);
              }               
          ?>
            <li>
              
              <div class="row">
                <div class="col-md-4 col-xs-4">
                  <a href="<?php echo $news_link; ?>"><img src="<?php echo UPLOADS_URL.'news/thumb/'.$activity['thumb']; ?>" alt="" class="img-responsive" /></a>
                </div>
                <div class="col-md-8 col-xs-12 padd0-left">
                  <a href="<?php echo $news_link; ?>">
                  <h3><?php echo $activity["title"]; ?></h3>
                  <p><?php echo substr(strip_tags($activity["description"]), 0, 40); ?>....  </p>
                  </a>
                </div>
                <div id="latest_activities_child_div" class="col-md-12 col-xs-12"><a href="<?php echo $news_link; ?>" class="btn btn-sm btn-success">SEE THE DETAILS</a></div>                      
              </div>
            </li>
          <?php
            }
          ?>
          </ul>
        </div>
      </div>       
    </div>
    <div class="col-lg-6 col-md-6 col-xs-12">
        <div class="home_block" id="latest_events_block">
          <a href="<?php echo BASE_URL.'events'; ?>"><h2><?php echo $core_data['settings_txt']['LATEST_EVENTS']; ?></h2></a>
          <div>
            <ul>
            <?php
              foreach ($latest_events as $activity) {
              
                $news_link = BASE_URL.'events/'.$activity['id'];
                if(trim($activity["external_link"]) != "")
                {
                  $news_link = trim($activity["external_link"]);
                } 

            ?>
              <li>
                
                <div class="row">
                  <div class="col-md-4 col-xs-4">
                    <a href="<?php echo $news_link; ?>"><img src="<?php echo UPLOADS_URL.'news/thumb/'.$activity['thumb']; ?>" alt="" class="img-responsive" /></a>
                  </div>
                  <div class="col-md-8 col-xs-12 padd0-left">
                    <a href="<?php echo $news_link; ?>">
                      <h3><?php echo $activity["title"]; ?></h3>
                      <p><?php echo substr(strip_tags($activity["description"]), 0, 100); ?>....  </p>
                    </a>
                  </div>
                </div>
              </li>
            <?php
              }
            ?>
            </ul>                   
          </div>
        </div>      
    </div>
  </div>
</div>           

<?php $this->load->view('inc_files/site_footer', $core_data); ?>