<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}" @if(app()->getLocale() == 'ar') dir="rtl" @endif>
@php

$conference = \App\Models\Conference::find(env('CONFERENCE_ID'));
$conference_id = $conference->id;
if (app()->getLocale() == 'ar') {
    $university_title = 'جامعة البصرة';
} else {
    $university_title = 'university of basrah';
}

$menuItems = \App\Models\MenuItem::with(['children', 'children.children'])
    ->where(['active' => 1, 'website_id' => $conference->id, 'website_menu_id' => 1, 'parent_id' => 0])
    ->orderBy('item_order', 'asc')
    ->limit(10)
    ->get();
@endphp

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <title>{{ $conference->name }}</title>

    @if(app()->getLocale() == 'ar')
        <link rel="stylesheet" href="https://cdn.rtlcss.com/bootstrap/v4.5.3/css/bootstrap.min.css" />
    @else
        <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" />
    @endif
    <link rel="stylesheet" href="/assets/site.css">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="">
    <meta name="keywords" content="">
</head>

<body>




    @include('layouts.header')
    <div class="container-fluid">
        <main role="main" class="pb-3">

            <br>
            <div class="container text-justify">
                @yield('content')
            </div>
            <br>

        </main>
    </div>
    @include('layouts.footer')


    <script src="https://code.jquery.com/jquery-3.2.1.slim.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js"></script>

    @if(app()->getLocale() == 'ar')
        <script src="https://cdn.rtlcss.com/bootstrap/v4.5.3/js/bootstrap.bundle.min.js"></script>
    @else
        <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js"></script>
    @endif

    <script src="./assets/site.js"></script>


</body>

</html>
