<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg10.php" ?>
<?php include_once "ewmysql10.php" ?>
<?php include_once "phpfn10.php" ?>
<?php include_once "_logininfo.php" ?>
<?php include_once "userfn10.php" ?>
<?php

//
// Page class
//

$p_login_edit = NULL; // Initialize page object first

class cp_login_edit extends c_login {

	// Page ID
	var $PageID = 'edit';

	// Project ID
	var $ProjectID = "{F555B504-0784-474D-925D-CB2D041B48DF}";

	// Table name
	var $TableName = 'login';

	// Page object name
	var $PageObjName = 'p_login_edit';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-error ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<table class=\"ewStdTable\"><tr><td><div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div></td></tr></table>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language, $UserAgent;

		// User agent
		$UserAgent = ew_UserAgent();
		$GLOBALS["Page"] = &$this;

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (_login)
		if (!isset($GLOBALS["_login"])) {
			$GLOBALS["_login"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["_login"];
		}

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'edit', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'login', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect();
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login.php");
		}

		// Create form object
		$objForm = new cFormObj();
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up curent action
		$this->login_id->Visible = !$this->IsAdd() && !$this->IsCopy() && !$this->IsGridAdd();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $conn;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();
		$this->Page_Redirecting($url);

		 // Close connection
		$conn->Close();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}
	var $DbMasterFilter;
	var $DbDetailFilter;

	// 
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError;

		// Load key from QueryString
		if (@$_GET["login_id"] <> "") {
			$this->login_id->setQueryStringValue($_GET["login_id"]);
		}

		// Set up Breadcrumb
		$this->SetupBreadcrumb();

		// Process form if post back
		if (@$_POST["a_edit"] <> "") {
			$this->CurrentAction = $_POST["a_edit"]; // Get action code
			$this->LoadFormValues(); // Get form values
		} else {
			$this->CurrentAction = "I"; // Default action is display
		}

		// Check if valid key
		if ($this->login_id->CurrentValue == "")
			$this->Page_Terminate("_loginlist.php"); // Invalid key, return to list

		// Validate form if post back
		if (@$_POST["a_edit"] <> "") {
			if (!$this->ValidateForm()) {
				$this->CurrentAction = ""; // Form error, reset action
				$this->setFailureMessage($gsFormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->RestoreFormValues();
			}
		}
		switch ($this->CurrentAction) {
			case "I": // Get a record to display
				if (!$this->LoadRow()) { // Load record based on key
					if ($this->getFailureMessage() == "") $this->setFailureMessage($Language->Phrase("NoRecord")); // No record found
					$this->Page_Terminate("_loginlist.php"); // No matching record, return to list
				}
				break;
			Case "U": // Update
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->EditRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->Phrase("UpdateSuccess")); // Update success
					$sReturnUrl = $this->getReturnUrl();
					if (ew_GetPageName($sReturnUrl) == "_loginview.php")
						$sReturnUrl = $this->GetViewUrl(); // View paging, return to View page directly
					$this->Page_Terminate($sReturnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->RestoreFormValues(); // Restore form values if update failed
				}
		}

		// Render the record
		$this->RowType = EW_ROWTYPE_EDIT; // Render as Edit
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Set up starting record parameters
	function SetUpStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	function GetUploadFiles() {
		global $objForm;

		// Get upload data
	}

	// Load form values
	function LoadFormValues() {

		// Load from form
		global $objForm;
		if (!$this->login_id->FldIsDetailKey)
			$this->login_id->setFormValue($objForm->GetValue("x_login_id"));
		if (!$this->login_name->FldIsDetailKey) {
			$this->login_name->setFormValue($objForm->GetValue("x_login_name"));
		}
		if (!$this->login_password->FldIsDetailKey) {
			$this->login_password->setFormValue($objForm->GetValue("x_login_password"));
		}
		if (!$this->is_admin->FldIsDetailKey) {
			$this->is_admin->setFormValue($objForm->GetValue("x_is_admin"));
		}
		if (!$this->edit_permissions->FldIsDetailKey) {
			$this->edit_permissions->setFormValue($objForm->GetValue("x_edit_permissions"));
		}
		if (!$this->news_permissions->FldIsDetailKey) {
			$this->news_permissions->setFormValue($objForm->GetValue("x_news_permissions"));
		}
	}

	// Restore form values
	function RestoreFormValues() {
		global $objForm;
		$this->LoadRow();
		$this->login_id->CurrentValue = $this->login_id->FormValue;
		$this->login_name->CurrentValue = $this->login_name->FormValue;
		$this->login_password->CurrentValue = $this->login_password->FormValue;
		$this->is_admin->CurrentValue = $this->is_admin->FormValue;
		$this->edit_permissions->CurrentValue = $this->edit_permissions->FormValue;
		$this->news_permissions->CurrentValue = $this->news_permissions->FormValue;
	}

	// Load row based on key values
	function LoadRow() {
		global $conn, $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		global $conn;
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->login_id->setDbValue($rs->fields('login_id'));
		$this->is_super_admin->setDbValue($rs->fields('is_super_admin'));
		$this->login_name->setDbValue($rs->fields('login_name'));
		$this->login_password->setDbValue($rs->fields('login_password'));
		$this->is_admin->setDbValue($rs->fields('is_admin'));
		$this->edit_permissions->setDbValue($rs->fields('edit_permissions'));
		$this->news_permissions->setDbValue($rs->fields('news_permissions'));
		$this->date_modified->setDbValue($rs->fields('date_modified'));
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->login_id->DbValue = $row['login_id'];
		$this->is_super_admin->DbValue = $row['is_super_admin'];
		$this->login_name->DbValue = $row['login_name'];
		$this->login_password->DbValue = $row['login_password'];
		$this->is_admin->DbValue = $row['is_admin'];
		$this->edit_permissions->DbValue = $row['edit_permissions'];
		$this->news_permissions->DbValue = $row['news_permissions'];
		$this->date_modified->DbValue = $row['date_modified'];
	}

	// Render row values based on field settings
	function RenderRow() {
		global $conn, $Security, $Language;
		global $gsLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// login_id
		// is_super_admin
		// login_name
		// login_password
		// is_admin
		// edit_permissions
		// news_permissions
		// date_modified

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

			// login_id
			$this->login_id->ViewValue = $this->login_id->CurrentValue;
			$this->login_id->ViewCustomAttributes = "";

			// login_name
			$this->login_name->ViewValue = $this->login_name->CurrentValue;
			$this->login_name->ViewCustomAttributes = "";

			// login_password
			$this->login_password->ViewValue = "********";
			$this->login_password->ViewCustomAttributes = "";

			// is_admin
			if (strval($this->is_admin->CurrentValue) <> "") {
				switch ($this->is_admin->CurrentValue) {
					case $this->is_admin->FldTagValue(1):
						$this->is_admin->ViewValue = $this->is_admin->FldTagCaption(1) <> "" ? $this->is_admin->FldTagCaption(1) : $this->is_admin->CurrentValue;
						break;
					case $this->is_admin->FldTagValue(2):
						$this->is_admin->ViewValue = $this->is_admin->FldTagCaption(2) <> "" ? $this->is_admin->FldTagCaption(2) : $this->is_admin->CurrentValue;
						break;
					default:
						$this->is_admin->ViewValue = $this->is_admin->CurrentValue;
				}
			} else {
				$this->is_admin->ViewValue = NULL;
			}
			$this->is_admin->ViewCustomAttributes = "";

			// edit_permissions
			if (strval($this->edit_permissions->CurrentValue) <> "") {
				switch ($this->edit_permissions->CurrentValue) {
					case $this->edit_permissions->FldTagValue(1):
						$this->edit_permissions->ViewValue = $this->edit_permissions->FldTagCaption(1) <> "" ? $this->edit_permissions->FldTagCaption(1) : $this->edit_permissions->CurrentValue;
						break;
					case $this->edit_permissions->FldTagValue(2):
						$this->edit_permissions->ViewValue = $this->edit_permissions->FldTagCaption(2) <> "" ? $this->edit_permissions->FldTagCaption(2) : $this->edit_permissions->CurrentValue;
						break;
					default:
						$this->edit_permissions->ViewValue = $this->edit_permissions->CurrentValue;
				}
			} else {
				$this->edit_permissions->ViewValue = NULL;
			}
			$this->edit_permissions->ViewCustomAttributes = "";

			// news_permissions
			if (strval($this->news_permissions->CurrentValue) <> "") {
				switch ($this->news_permissions->CurrentValue) {
					case $this->news_permissions->FldTagValue(1):
						$this->news_permissions->ViewValue = $this->news_permissions->FldTagCaption(1) <> "" ? $this->news_permissions->FldTagCaption(1) : $this->news_permissions->CurrentValue;
						break;
					case $this->news_permissions->FldTagValue(2):
						$this->news_permissions->ViewValue = $this->news_permissions->FldTagCaption(2) <> "" ? $this->news_permissions->FldTagCaption(2) : $this->news_permissions->CurrentValue;
						break;
					default:
						$this->news_permissions->ViewValue = $this->news_permissions->CurrentValue;
				}
			} else {
				$this->news_permissions->ViewValue = NULL;
			}
			$this->news_permissions->ViewCustomAttributes = "";

			// date_modified
			$this->date_modified->ViewValue = $this->date_modified->CurrentValue;
			$this->date_modified->ViewValue = ew_FormatDateTime($this->date_modified->ViewValue, 7);
			$this->date_modified->ViewCustomAttributes = "";

			// login_id
			$this->login_id->LinkCustomAttributes = "";
			$this->login_id->HrefValue = "";
			$this->login_id->TooltipValue = "";

			// login_name
			$this->login_name->LinkCustomAttributes = "";
			$this->login_name->HrefValue = "";
			$this->login_name->TooltipValue = "";

			// login_password
			$this->login_password->LinkCustomAttributes = "";
			$this->login_password->HrefValue = "";
			$this->login_password->TooltipValue = "";

			// is_admin
			$this->is_admin->LinkCustomAttributes = "";
			$this->is_admin->HrefValue = "";
			$this->is_admin->TooltipValue = "";

			// edit_permissions
			$this->edit_permissions->LinkCustomAttributes = "";
			$this->edit_permissions->HrefValue = "";
			$this->edit_permissions->TooltipValue = "";

			// news_permissions
			$this->news_permissions->LinkCustomAttributes = "";
			$this->news_permissions->HrefValue = "";
			$this->news_permissions->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_EDIT) { // Edit row

			// login_id
			$this->login_id->EditCustomAttributes = "";
			$this->login_id->EditValue = $this->login_id->CurrentValue;
			$this->login_id->ViewCustomAttributes = "";

			// login_name
			$this->login_name->EditCustomAttributes = "";
			$this->login_name->EditValue = ew_HtmlEncode($this->login_name->CurrentValue);
			$this->login_name->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->login_name->FldCaption()));

			// login_password
			$this->login_password->EditCustomAttributes = "";
			$this->login_password->EditValue = ew_HtmlEncode($this->login_password->CurrentValue);

			// is_admin
			$this->is_admin->EditCustomAttributes = "";
			$arwrk = array();
			$arwrk[] = array($this->is_admin->FldTagValue(1), $this->is_admin->FldTagCaption(1) <> "" ? $this->is_admin->FldTagCaption(1) : $this->is_admin->FldTagValue(1));
			$arwrk[] = array($this->is_admin->FldTagValue(2), $this->is_admin->FldTagCaption(2) <> "" ? $this->is_admin->FldTagCaption(2) : $this->is_admin->FldTagValue(2));
			$this->is_admin->EditValue = $arwrk;

			// edit_permissions
			$this->edit_permissions->EditCustomAttributes = "";
			$arwrk = array();
			$arwrk[] = array($this->edit_permissions->FldTagValue(1), $this->edit_permissions->FldTagCaption(1) <> "" ? $this->edit_permissions->FldTagCaption(1) : $this->edit_permissions->FldTagValue(1));
			$arwrk[] = array($this->edit_permissions->FldTagValue(2), $this->edit_permissions->FldTagCaption(2) <> "" ? $this->edit_permissions->FldTagCaption(2) : $this->edit_permissions->FldTagValue(2));
			$this->edit_permissions->EditValue = $arwrk;

			// news_permissions
			$this->news_permissions->EditCustomAttributes = "";
			$arwrk = array();
			$arwrk[] = array($this->news_permissions->FldTagValue(1), $this->news_permissions->FldTagCaption(1) <> "" ? $this->news_permissions->FldTagCaption(1) : $this->news_permissions->FldTagValue(1));
			$arwrk[] = array($this->news_permissions->FldTagValue(2), $this->news_permissions->FldTagCaption(2) <> "" ? $this->news_permissions->FldTagCaption(2) : $this->news_permissions->FldTagValue(2));
			$this->news_permissions->EditValue = $arwrk;

			// Edit refer script
			// login_id

			$this->login_id->HrefValue = "";

			// login_name
			$this->login_name->HrefValue = "";

			// login_password
			$this->login_password->HrefValue = "";

			// is_admin
			$this->is_admin->HrefValue = "";

			// edit_permissions
			$this->edit_permissions->HrefValue = "";

			// news_permissions
			$this->news_permissions->HrefValue = "";
		}
		if ($this->RowType == EW_ROWTYPE_ADD ||
			$this->RowType == EW_ROWTYPE_EDIT ||
			$this->RowType == EW_ROWTYPE_SEARCH) { // Add / Edit / Search row
			$this->SetupFieldTitles();
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	function ValidateForm() {
		global $Language, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return ($gsFormError == "");
		if (!$this->login_name->FldIsDetailKey && !is_null($this->login_name->FormValue) && $this->login_name->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->login_name->FldCaption());
		}
		if (!$this->login_password->FldIsDetailKey && !is_null($this->login_password->FormValue) && $this->login_password->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->login_password->FldCaption());
		}
		if ($this->is_admin->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->is_admin->FldCaption());
		}
		if ($this->edit_permissions->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->edit_permissions->FldCaption());
		}
		if ($this->news_permissions->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->news_permissions->FldCaption());
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsFormError, $sFormCustomError);
		}
		return $ValidateForm;
	}

	// Update record based on key values
	function EditRow() {
		global $conn, $Security, $Language;
		$sFilter = $this->KeyFilter();
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn->raiseErrorFn = 'ew_ErrorFn';
		$rs = $conn->Execute($sSql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$EditRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->LoadDbValues($rsold);
			$rsnew = array();

			// login_name
			$this->login_name->SetDbValueDef($rsnew, $this->login_name->CurrentValue, "", $this->login_name->ReadOnly);

			// login_password
			$this->login_password->SetDbValueDef($rsnew, $this->login_password->CurrentValue, "", $this->login_password->ReadOnly || (EW_ENCRYPTED_PASSWORD && $rs->fields('login_password') == $this->login_password->CurrentValue));

			// is_admin
			$this->is_admin->SetDbValueDef($rsnew, $this->is_admin->CurrentValue, 0, $this->is_admin->ReadOnly);

			// edit_permissions
			$this->edit_permissions->SetDbValueDef($rsnew, $this->edit_permissions->CurrentValue, 0, $this->edit_permissions->ReadOnly);

			// news_permissions
			$this->news_permissions->SetDbValueDef($rsnew, $this->news_permissions->CurrentValue, 0, $this->news_permissions->ReadOnly);

			// Call Row Updating event
			$bUpdateRow = $this->Row_Updating($rsold, $rsnew);
			if ($bUpdateRow) {
				$conn->raiseErrorFn = 'ew_ErrorFn';
				if (count($rsnew) > 0)
					$EditRow = $this->Update($rsnew, "", $rsold);
				else
					$EditRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($EditRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->Phrase("UpdateCancelled"));
				}
				$EditRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($EditRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->Close();
		return $EditRow;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$PageCaption = $this->TableCaption();
		$Breadcrumb->Add("list", "<span id=\"ewPageCaption\">" . $PageCaption . "</span>", "_loginlist.php", $this->TableVar);
		$PageCaption = $Language->Phrase("edit");
		$Breadcrumb->Add("edit", "<span id=\"ewPageCaption\">" . $PageCaption . "</span>", ew_CurrentUrl(), $this->TableVar);
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($p_login_edit)) $p_login_edit = new cp_login_edit();

// Page init
$p_login_edit->Page_Init();

// Page main
$p_login_edit->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$p_login_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Page object
var p_login_edit = new ew_Page("p_login_edit");
p_login_edit.PageID = "edit"; // Page ID
var EW_PAGE_ID = p_login_edit.PageID; // For backward compatibility

// Form object
var f_loginedit = new ew_Form("f_loginedit");

// Validate form
f_loginedit.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);
	this.PostAutoSuggest();
	if ($fobj.find("#a_confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.FormKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = $fobj.find("#a_list").val() == "gridinsert";
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
			elm = this.GetElements("x" + infix + "_login_name");
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($_login->login_name->FldCaption()) ?>");
			elm = this.GetElements("x" + infix + "_login_password");
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($_login->login_password->FldCaption()) ?>");
			elm = this.GetElements("x" + infix + "_is_admin");
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($_login->is_admin->FldCaption()) ?>");
			elm = this.GetElements("x" + infix + "_edit_permissions");
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($_login->edit_permissions->FldCaption()) ?>");
			elm = this.GetElements("x" + infix + "_news_permissions");
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($_login->news_permissions->FldCaption()) ?>");

			// Set up row object
			ew_ElementsToRow(fobj);

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ewForms[val])
			if (!ewForms[val].Validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
f_loginedit.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
f_loginedit.ValidateRequired = true;
<?php } else { ?>
f_loginedit.ValidateRequired = false; 
<?php } ?>

// Dynamic selection lists
// Form object for search

</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php $Breadcrumb->Render(); ?>
<?php $p_login_edit->ShowPageHeader(); ?>
<?php
$p_login_edit->ShowMessage();
?>
<form name="f_loginedit" id="f_loginedit" class="ewForm form-horizontal" action="<?php echo ew_CurrentPage() ?>" method="post">
<input type="hidden" name="t" value="_login">
<input type="hidden" name="a_edit" id="a_edit" value="U">
<table cellspacing="0" class="ewGrid"><tr><td>
<table id="tbl__loginedit" class="table table-bordered table-striped">
<?php if ($_login->login_id->Visible) { // login_id ?>
	<tr id="r_login_id">
		<td><span id="elh__login_login_id"><?php echo $_login->login_id->FldCaption() ?></span></td>
		<td<?php echo $_login->login_id->CellAttributes() ?>>
<span id="el__login_login_id" class="control-group">
<span<?php echo $_login->login_id->ViewAttributes() ?>>
<?php echo $_login->login_id->EditValue ?></span>
</span>
<input type="hidden" data-field="x_login_id" name="x_login_id" id="x_login_id" value="<?php echo ew_HtmlEncode($_login->login_id->CurrentValue) ?>">
<?php echo $_login->login_id->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($_login->login_name->Visible) { // login_name ?>
	<tr id="r_login_name">
		<td><span id="elh__login_login_name"><?php echo $_login->login_name->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $_login->login_name->CellAttributes() ?>>
<span id="el__login_login_name" class="control-group">
<input type="text" data-field="x_login_name" name="x_login_name" id="x_login_name" size="30" maxlength="150" placeholder="<?php echo $_login->login_name->PlaceHolder ?>" value="<?php echo $_login->login_name->EditValue ?>"<?php echo $_login->login_name->EditAttributes() ?>>
</span>
<?php echo $_login->login_name->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($_login->login_password->Visible) { // login_password ?>
	<tr id="r_login_password">
		<td><span id="elh__login_login_password"><?php echo $_login->login_password->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $_login->login_password->CellAttributes() ?>>
<span id="el__login_login_password" class="control-group">
<input type="password" data-field="x_login_password" name="x_login_password" id="x_login_password" value="<?php echo $_login->login_password->EditValue ?>" size="30" maxlength="150"<?php echo $_login->login_password->EditAttributes() ?>>
</span>
<?php echo $_login->login_password->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($_login->is_admin->Visible) { // is_admin ?>
	<tr id="r_is_admin">
		<td><span id="elh__login_is_admin"><?php echo $_login->is_admin->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $_login->is_admin->CellAttributes() ?>>
<span id="el__login_is_admin" class="control-group">
<div id="tp_x_is_admin" class="<?php echo EW_ITEM_TEMPLATE_CLASSNAME ?>"><input type="radio" name="x_is_admin" id="x_is_admin" value="{value}"<?php echo $_login->is_admin->EditAttributes() ?>></div>
<div id="dsl_x_is_admin" data-repeatcolumn="5" class="ewItemList">
<?php
$arwrk = $_login->is_admin->EditValue;
if (is_array($arwrk)) {
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($_login->is_admin->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " checked=\"checked\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;

		// Note: No spacing within the LABEL tag
?>
<?php echo ew_RepeatColumnTable($rowswrk, $rowcntwrk, 5, 1) ?>
<label class="radio"><input type="radio" data-field="x_is_admin" name="x_is_admin" id="x_is_admin_<?php echo $rowcntwrk ?>" value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?><?php echo $_login->is_admin->EditAttributes() ?>><?php echo $arwrk[$rowcntwrk][1] ?></label>
<?php echo ew_RepeatColumnTable($rowswrk, $rowcntwrk, 5, 2) ?>
<?php
	}
}
?>
</div>
</span>
<?php echo $_login->is_admin->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($_login->edit_permissions->Visible) { // edit_permissions ?>
	<tr id="r_edit_permissions">
		<td><span id="elh__login_edit_permissions"><?php echo $_login->edit_permissions->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $_login->edit_permissions->CellAttributes() ?>>
<span id="el__login_edit_permissions" class="control-group">
<div id="tp_x_edit_permissions" class="<?php echo EW_ITEM_TEMPLATE_CLASSNAME ?>"><input type="radio" name="x_edit_permissions" id="x_edit_permissions" value="{value}"<?php echo $_login->edit_permissions->EditAttributes() ?>></div>
<div id="dsl_x_edit_permissions" data-repeatcolumn="5" class="ewItemList">
<?php
$arwrk = $_login->edit_permissions->EditValue;
if (is_array($arwrk)) {
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($_login->edit_permissions->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " checked=\"checked\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;

		// Note: No spacing within the LABEL tag
?>
<?php echo ew_RepeatColumnTable($rowswrk, $rowcntwrk, 5, 1) ?>
<label class="radio"><input type="radio" data-field="x_edit_permissions" name="x_edit_permissions" id="x_edit_permissions_<?php echo $rowcntwrk ?>" value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?><?php echo $_login->edit_permissions->EditAttributes() ?>><?php echo $arwrk[$rowcntwrk][1] ?></label>
<?php echo ew_RepeatColumnTable($rowswrk, $rowcntwrk, 5, 2) ?>
<?php
	}
}
?>
</div>
</span>
<?php echo $_login->edit_permissions->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($_login->news_permissions->Visible) { // news_permissions ?>
	<tr id="r_news_permissions">
		<td><span id="elh__login_news_permissions"><?php echo $_login->news_permissions->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $_login->news_permissions->CellAttributes() ?>>
<span id="el__login_news_permissions" class="control-group">
<div id="tp_x_news_permissions" class="<?php echo EW_ITEM_TEMPLATE_CLASSNAME ?>"><input type="radio" name="x_news_permissions" id="x_news_permissions" value="{value}"<?php echo $_login->news_permissions->EditAttributes() ?>></div>
<div id="dsl_x_news_permissions" data-repeatcolumn="5" class="ewItemList">
<?php
$arwrk = $_login->news_permissions->EditValue;
if (is_array($arwrk)) {
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($_login->news_permissions->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " checked=\"checked\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;

		// Note: No spacing within the LABEL tag
?>
<?php echo ew_RepeatColumnTable($rowswrk, $rowcntwrk, 5, 1) ?>
<label class="radio"><input type="radio" data-field="x_news_permissions" name="x_news_permissions" id="x_news_permissions_<?php echo $rowcntwrk ?>" value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?><?php echo $_login->news_permissions->EditAttributes() ?>><?php echo $arwrk[$rowcntwrk][1] ?></label>
<?php echo ew_RepeatColumnTable($rowswrk, $rowcntwrk, 5, 2) ?>
<?php
	}
}
?>
</div>
</span>
<?php echo $_login->news_permissions->CustomMsg ?></td>
	</tr>
<?php } ?>
</table>
</td></tr></table>
<button class="btn btn-primary ewButton" name="btnAction" id="btnAction" type="submit"><?php echo $Language->Phrase("EditBtn") ?></button>
</form>
<script type="text/javascript">
f_loginedit.Init();
<?php if (EW_MOBILE_REFLOW && ew_IsMobile()) { ?>
ew_Reflow();
<?php } ?>
</script>
<?php
$p_login_edit->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$p_login_edit->Page_Terminate();
?>
