<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg10.php" ?>
<?php include_once "ewmysql10.php" ?>
<?php include_once "phpfn10.php" ?>
<?php include_once "_logininfo.php" ?>
<?php include_once "userfn10.php" ?>
<?php

//
// Page class
//

$p_login_view = NULL; // Initialize page object first

class cp_login_view extends c_login {

	// Page ID
	var $PageID = 'view';

	// Project ID
	var $ProjectID = "{F555B504-0784-474D-925D-CB2D041B48DF}";

	// Table name
	var $TableName = 'login';

	// Page object name
	var $PageObjName = 'p_login_view';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Page URLs
	var $AddUrl;
	var $EditUrl;
	var $CopyUrl;
	var $DeleteUrl;
	var $ViewUrl;
	var $ListUrl;

	// Export URLs
	var $ExportPrintUrl;
	var $ExportHtmlUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportXmlUrl;
	var $ExportCsvUrl;
	var $ExportPdfUrl;

	// Update URLs
	var $InlineAddUrl;
	var $InlineCopyUrl;
	var $InlineEditUrl;
	var $GridAddUrl;
	var $GridEditUrl;
	var $MultiDeleteUrl;
	var $MultiUpdateUrl;

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-error ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<table class=\"ewStdTable\"><tr><td><div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div></td></tr></table>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language, $UserAgent;

		// User agent
		$UserAgent = ew_UserAgent();
		$GLOBALS["Page"] = &$this;

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (_login)
		if (!isset($GLOBALS["_login"])) {
			$GLOBALS["_login"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["_login"];
		}
		$KeyUrl = "";
		if (@$_GET["login_id"] <> "") {
			$this->RecKey["login_id"] = $_GET["login_id"];
			$KeyUrl .= "&login_id=" . urlencode($this->RecKey["login_id"]);
		}
		$this->ExportPrintUrl = $this->PageUrl() . "export=print" . $KeyUrl;
		$this->ExportHtmlUrl = $this->PageUrl() . "export=html" . $KeyUrl;
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel" . $KeyUrl;
		$this->ExportWordUrl = $this->PageUrl() . "export=word" . $KeyUrl;
		$this->ExportXmlUrl = $this->PageUrl() . "export=xml" . $KeyUrl;
		$this->ExportCsvUrl = $this->PageUrl() . "export=csv" . $KeyUrl;
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf" . $KeyUrl;

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'view', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'login', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect();

		// Export options
		$this->ExportOptions = new cListOptions();
		$this->ExportOptions->Tag = "span";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Other options
		$this->OtherOptions['action'] = new cListOptions();
		$this->OtherOptions['action']->Tag = "span";
		$this->OtherOptions['action']->TagClassName = "ewActionOption";
		$this->OtherOptions['detail'] = new cListOptions();
		$this->OtherOptions['detail']->Tag = "span";
		$this->OtherOptions['detail']->TagClassName = "ewDetailOption";
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login.php");
		}
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up curent action
		$this->login_id->Visible = !$this->IsAdd() && !$this->IsCopy() && !$this->IsGridAdd();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $conn;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();
		$this->Page_Redirecting($url);

		 // Close connection
		$conn->Close();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}
	var $ExportOptions; // Export options
	var $OtherOptions = array(); // Other options
	var $DisplayRecs = 1;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $Pager;
	var $RecCnt;
	var $RecKey = array();
	var $Recordset;

	//
	// Page main
	//
	function Page_Main() {
		global $Language;

		// Load current record
		$bLoadCurrentRecord = FALSE;
		$sReturnUrl = "";
		$bMatchRecord = FALSE;

		// Set up Breadcrumb
		$this->SetupBreadcrumb();
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET["login_id"] <> "") {
				$this->login_id->setQueryStringValue($_GET["login_id"]);
				$this->RecKey["login_id"] = $this->login_id->QueryStringValue;
			} else {
				$bLoadCurrentRecord = TRUE;
			}

			// Get action
			$this->CurrentAction = "I"; // Display form
			switch ($this->CurrentAction) {
				case "I": // Get a record to display
					$this->StartRec = 1; // Initialize start position
					if ($this->Recordset = $this->LoadRecordset()) // Load records
						$this->TotalRecs = $this->Recordset->RecordCount(); // Get record count
					if ($this->TotalRecs <= 0) { // No record found
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->Phrase("NoRecord")); // Set no record message
						$this->Page_Terminate("_loginlist.php"); // Return to list page
					} elseif ($bLoadCurrentRecord) { // Load current record position
						$this->SetUpStartRec(); // Set up start record position

						// Point to current record
						if (intval($this->StartRec) <= intval($this->TotalRecs)) {
							$bMatchRecord = TRUE;
							$this->Recordset->Move($this->StartRec-1);
						}
					} else { // Match key values
						while (!$this->Recordset->EOF) {
							if (strval($this->login_id->CurrentValue) == strval($this->Recordset->fields('login_id'))) {
								$this->setStartRecordNumber($this->StartRec); // Save record position
								$bMatchRecord = TRUE;
								break;
							} else {
								$this->StartRec++;
								$this->Recordset->MoveNext();
							}
						}
					}
					if (!$bMatchRecord) {
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->Phrase("NoRecord")); // Set no record message
						$sReturnUrl = "_loginlist.php"; // No matching record, return to list
					} else {
						$this->LoadRowValues($this->Recordset); // Load row values
					}
			}
		} else {
			$sReturnUrl = "_loginlist.php"; // Not page request, return to list
		}
		if ($sReturnUrl <> "")
			$this->Page_Terminate($sReturnUrl);

		// Render row
		$this->RowType = EW_ROWTYPE_VIEW;
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Set up other options
	function SetupOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = &$options["action"];

		// Add
		$item = &$option->Add("add");
		$item->Body = "<a class=\"ewAction ewAdd\" href=\"" . ew_HtmlEncode($this->AddUrl) . "\">" . $Language->Phrase("ViewPageAddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->IsLoggedIn());

		// Edit
		$item = &$option->Add("edit");
		$item->Body = "<a class=\"ewAction ewEdit\" href=\"" . ew_HtmlEncode($this->EditUrl) . "\">" . $Language->Phrase("ViewPageEditLink") . "</a>";
		$item->Visible = ($this->EditUrl <> "" && $Security->IsLoggedIn());

		// Delete
		$item = &$option->Add("delete");
		$item->Body = "<a class=\"ewAction ewDelete\" href=\"" . ew_HtmlEncode($this->DeleteUrl) . "\">" . $Language->Phrase("ViewPageDeleteLink") . "</a>";
		$item->Visible = ($this->DeleteUrl <> "" && $Security->IsLoggedIn());

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;
			$item = &$option->Add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["detail"]->DropDownButtonPhrase = $Language->Phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->Phrase("ButtonActions");
	}

	// Set up starting record parameters
	function SetUpStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {
		global $conn;

		// Call Recordset Selecting event
		$this->Recordset_Selecting($this->CurrentFilter);

		// Load List page SQL
		$sSql = $this->SelectSQL();
		if ($offset > -1 && $rowcnt > -1)
			$sSql .= " LIMIT $rowcnt OFFSET $offset";

		// Load recordset
		$rs = ew_LoadRecordset($sSql);

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $conn, $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		global $conn;
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->login_id->setDbValue($rs->fields('login_id'));
		$this->is_super_admin->setDbValue($rs->fields('is_super_admin'));
		$this->login_name->setDbValue($rs->fields('login_name'));
		$this->login_password->setDbValue($rs->fields('login_password'));
		$this->is_admin->setDbValue($rs->fields('is_admin'));
		$this->edit_permissions->setDbValue($rs->fields('edit_permissions'));
		$this->news_permissions->setDbValue($rs->fields('news_permissions'));
		$this->date_modified->setDbValue($rs->fields('date_modified'));
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->login_id->DbValue = $row['login_id'];
		$this->is_super_admin->DbValue = $row['is_super_admin'];
		$this->login_name->DbValue = $row['login_name'];
		$this->login_password->DbValue = $row['login_password'];
		$this->is_admin->DbValue = $row['is_admin'];
		$this->edit_permissions->DbValue = $row['edit_permissions'];
		$this->news_permissions->DbValue = $row['news_permissions'];
		$this->date_modified->DbValue = $row['date_modified'];
	}

	// Render row values based on field settings
	function RenderRow() {
		global $conn, $Security, $Language;
		global $gsLanguage;

		// Initialize URLs
		$this->AddUrl = $this->GetAddUrl();
		$this->EditUrl = $this->GetEditUrl();
		$this->CopyUrl = $this->GetCopyUrl();
		$this->DeleteUrl = $this->GetDeleteUrl();
		$this->ListUrl = $this->GetListUrl();
		$this->SetupOtherOptions();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// login_id
		// is_super_admin
		// login_name
		// login_password
		// is_admin
		// edit_permissions
		// news_permissions
		// date_modified

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

			// login_id
			$this->login_id->ViewValue = $this->login_id->CurrentValue;
			$this->login_id->ViewCustomAttributes = "";

			// login_name
			$this->login_name->ViewValue = $this->login_name->CurrentValue;
			$this->login_name->ViewCustomAttributes = "";

			// login_password
			$this->login_password->ViewValue = "********";
			$this->login_password->ViewCustomAttributes = "";

			// is_admin
			if (strval($this->is_admin->CurrentValue) <> "") {
				switch ($this->is_admin->CurrentValue) {
					case $this->is_admin->FldTagValue(1):
						$this->is_admin->ViewValue = $this->is_admin->FldTagCaption(1) <> "" ? $this->is_admin->FldTagCaption(1) : $this->is_admin->CurrentValue;
						break;
					case $this->is_admin->FldTagValue(2):
						$this->is_admin->ViewValue = $this->is_admin->FldTagCaption(2) <> "" ? $this->is_admin->FldTagCaption(2) : $this->is_admin->CurrentValue;
						break;
					default:
						$this->is_admin->ViewValue = $this->is_admin->CurrentValue;
				}
			} else {
				$this->is_admin->ViewValue = NULL;
			}
			$this->is_admin->ViewCustomAttributes = "";

			// edit_permissions
			if (strval($this->edit_permissions->CurrentValue) <> "") {
				switch ($this->edit_permissions->CurrentValue) {
					case $this->edit_permissions->FldTagValue(1):
						$this->edit_permissions->ViewValue = $this->edit_permissions->FldTagCaption(1) <> "" ? $this->edit_permissions->FldTagCaption(1) : $this->edit_permissions->CurrentValue;
						break;
					case $this->edit_permissions->FldTagValue(2):
						$this->edit_permissions->ViewValue = $this->edit_permissions->FldTagCaption(2) <> "" ? $this->edit_permissions->FldTagCaption(2) : $this->edit_permissions->CurrentValue;
						break;
					default:
						$this->edit_permissions->ViewValue = $this->edit_permissions->CurrentValue;
				}
			} else {
				$this->edit_permissions->ViewValue = NULL;
			}
			$this->edit_permissions->ViewCustomAttributes = "";

			// news_permissions
			if (strval($this->news_permissions->CurrentValue) <> "") {
				switch ($this->news_permissions->CurrentValue) {
					case $this->news_permissions->FldTagValue(1):
						$this->news_permissions->ViewValue = $this->news_permissions->FldTagCaption(1) <> "" ? $this->news_permissions->FldTagCaption(1) : $this->news_permissions->CurrentValue;
						break;
					case $this->news_permissions->FldTagValue(2):
						$this->news_permissions->ViewValue = $this->news_permissions->FldTagCaption(2) <> "" ? $this->news_permissions->FldTagCaption(2) : $this->news_permissions->CurrentValue;
						break;
					default:
						$this->news_permissions->ViewValue = $this->news_permissions->CurrentValue;
				}
			} else {
				$this->news_permissions->ViewValue = NULL;
			}
			$this->news_permissions->ViewCustomAttributes = "";

			// date_modified
			$this->date_modified->ViewValue = $this->date_modified->CurrentValue;
			$this->date_modified->ViewValue = ew_FormatDateTime($this->date_modified->ViewValue, 7);
			$this->date_modified->ViewCustomAttributes = "";

			// login_id
			$this->login_id->LinkCustomAttributes = "";
			$this->login_id->HrefValue = "";
			$this->login_id->TooltipValue = "";

			// login_name
			$this->login_name->LinkCustomAttributes = "";
			$this->login_name->HrefValue = "";
			$this->login_name->TooltipValue = "";

			// login_password
			$this->login_password->LinkCustomAttributes = "";
			$this->login_password->HrefValue = "";
			$this->login_password->TooltipValue = "";

			// is_admin
			$this->is_admin->LinkCustomAttributes = "";
			$this->is_admin->HrefValue = "";
			$this->is_admin->TooltipValue = "";

			// edit_permissions
			$this->edit_permissions->LinkCustomAttributes = "";
			$this->edit_permissions->HrefValue = "";
			$this->edit_permissions->TooltipValue = "";

			// news_permissions
			$this->news_permissions->LinkCustomAttributes = "";
			$this->news_permissions->HrefValue = "";
			$this->news_permissions->TooltipValue = "";

			// date_modified
			$this->date_modified->LinkCustomAttributes = "";
			$this->date_modified->HrefValue = "";
			$this->date_modified->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$PageCaption = $this->TableCaption();
		$Breadcrumb->Add("list", "<span id=\"ewPageCaption\">" . $PageCaption . "</span>", "_loginlist.php", $this->TableVar);
		$PageCaption = $Language->Phrase("view");
		$Breadcrumb->Add("view", "<span id=\"ewPageCaption\">" . $PageCaption . "</span>", ew_CurrentUrl(), $this->TableVar);
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($p_login_view)) $p_login_view = new cp_login_view();

// Page init
$p_login_view->Page_Init();

// Page main
$p_login_view->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$p_login_view->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Page object
var p_login_view = new ew_Page("p_login_view");
p_login_view.PageID = "view"; // Page ID
var EW_PAGE_ID = p_login_view.PageID; // For backward compatibility

// Form object
var f_loginview = new ew_Form("f_loginview");

// Form_CustomValidate event
f_loginview.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
f_loginview.ValidateRequired = true;
<?php } else { ?>
f_loginview.ValidateRequired = false; 
<?php } ?>

// Dynamic selection lists
// Form object for search

</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php $Breadcrumb->Render(); ?>
<div class="ewViewExportOptions">
<?php $p_login_view->ExportOptions->Render("body") ?>
<?php if (!$p_login_view->ExportOptions->UseDropDownButton) { ?>
</div>
<div class="ewViewOtherOptions">
<?php } ?>
<?php
	foreach ($p_login_view->OtherOptions as &$option)
		$option->Render("body");
?>
</div>
<?php $p_login_view->ShowPageHeader(); ?>
<?php
$p_login_view->ShowMessage();
?>
<form name="ewPagerForm" class="ewForm form-horizontal" action="<?php echo ew_CurrentPage() ?>">
<table class="ewPager">
<tr><td>
<?php if (!isset($p_login_view->Pager)) $p_login_view->Pager = new cPrevNextPager($p_login_view->StartRec, $p_login_view->DisplayRecs, $p_login_view->TotalRecs) ?>
<?php if ($p_login_view->Pager->RecordCount > 0) { ?>
<table cellspacing="0" class="ewStdTable"><tbody><tr><td>
	<?php echo $Language->Phrase("Page") ?>&nbsp;
<div class="input-prepend input-append">
<!--first page button-->
	<?php if ($p_login_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-small" type="button" href="<?php echo $p_login_view->PageUrl() ?>start=<?php echo $p_login_view->Pager->FirstButton->Start ?>"><i class="icon-step-backward"></i></a>
	<?php } else { ?>
	<a class="btn btn-small" type="button" disabled="disabled"><i class="icon-step-backward"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($p_login_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-small" type="button" href="<?php echo $p_login_view->PageUrl() ?>start=<?php echo $p_login_view->Pager->PrevButton->Start ?>"><i class="icon-prev"></i></a>
	<?php } else { ?>
	<a class="btn btn-small" type="button" disabled="disabled"><i class="icon-prev"></i></a>
	<?php } ?>
<!--current page number-->
	<input class="input-mini" type="text" name="<?php echo EW_TABLE_PAGE_NO ?>" value="<?php echo $p_login_view->Pager->CurrentPage ?>">
<!--next page button-->
	<?php if ($p_login_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-small" type="button" href="<?php echo $p_login_view->PageUrl() ?>start=<?php echo $p_login_view->Pager->NextButton->Start ?>"><i class="icon-play"></i></a>
	<?php } else { ?>
	<a class="btn btn-small" type="button" disabled="disabled"><i class="icon-play"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($p_login_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-small" type="button" href="<?php echo $p_login_view->PageUrl() ?>start=<?php echo $p_login_view->Pager->LastButton->Start ?>"><i class="icon-step-forward"></i></a>
	<?php } else { ?>
	<a class="btn btn-small" type="button" disabled="disabled"><i class="icon-step-forward"></i></a>
	<?php } ?>
</div>
	&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $p_login_view->Pager->PageCount ?>
</td>
</tr></tbody></table>
<?php } else { ?>
	<p><?php echo $Language->Phrase("NoRecord") ?></p>
<?php } ?>
</td>
</tr></table>
</form>
<form name="f_loginview" id="f_loginview" class="ewForm form-horizontal" action="<?php echo ew_CurrentPage() ?>" method="post">
<input type="hidden" name="t" value="_login">
<table cellspacing="0" class="ewGrid"><tr><td>
<table id="tbl__loginview" class="table table-bordered table-striped">
<?php if ($_login->login_id->Visible) { // login_id ?>
	<tr id="r_login_id">
		<td><span id="elh__login_login_id"><?php echo $_login->login_id->FldCaption() ?></span></td>
		<td<?php echo $_login->login_id->CellAttributes() ?>>
<span id="el__login_login_id" class="control-group">
<span<?php echo $_login->login_id->ViewAttributes() ?>>
<?php echo $_login->login_id->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($_login->login_name->Visible) { // login_name ?>
	<tr id="r_login_name">
		<td><span id="elh__login_login_name"><?php echo $_login->login_name->FldCaption() ?></span></td>
		<td<?php echo $_login->login_name->CellAttributes() ?>>
<span id="el__login_login_name" class="control-group">
<span<?php echo $_login->login_name->ViewAttributes() ?>>
<?php echo $_login->login_name->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($_login->login_password->Visible) { // login_password ?>
	<tr id="r_login_password">
		<td><span id="elh__login_login_password"><?php echo $_login->login_password->FldCaption() ?></span></td>
		<td<?php echo $_login->login_password->CellAttributes() ?>>
<span id="el__login_login_password" class="control-group">
<span<?php echo $_login->login_password->ViewAttributes() ?>>
<?php echo $_login->login_password->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($_login->is_admin->Visible) { // is_admin ?>
	<tr id="r_is_admin">
		<td><span id="elh__login_is_admin"><?php echo $_login->is_admin->FldCaption() ?></span></td>
		<td<?php echo $_login->is_admin->CellAttributes() ?>>
<span id="el__login_is_admin" class="control-group">
<span<?php echo $_login->is_admin->ViewAttributes() ?>>
<?php echo $_login->is_admin->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($_login->edit_permissions->Visible) { // edit_permissions ?>
	<tr id="r_edit_permissions">
		<td><span id="elh__login_edit_permissions"><?php echo $_login->edit_permissions->FldCaption() ?></span></td>
		<td<?php echo $_login->edit_permissions->CellAttributes() ?>>
<span id="el__login_edit_permissions" class="control-group">
<span<?php echo $_login->edit_permissions->ViewAttributes() ?>>
<?php echo $_login->edit_permissions->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($_login->news_permissions->Visible) { // news_permissions ?>
	<tr id="r_news_permissions">
		<td><span id="elh__login_news_permissions"><?php echo $_login->news_permissions->FldCaption() ?></span></td>
		<td<?php echo $_login->news_permissions->CellAttributes() ?>>
<span id="el__login_news_permissions" class="control-group">
<span<?php echo $_login->news_permissions->ViewAttributes() ?>>
<?php echo $_login->news_permissions->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($_login->date_modified->Visible) { // date_modified ?>
	<tr id="r_date_modified">
		<td><span id="elh__login_date_modified"><?php echo $_login->date_modified->FldCaption() ?></span></td>
		<td<?php echo $_login->date_modified->CellAttributes() ?>>
<span id="el__login_date_modified" class="control-group">
<span<?php echo $_login->date_modified->ViewAttributes() ?>>
<?php echo $_login->date_modified->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</td></tr></table>
<table class="ewPager">
<tr><td>
<?php if (!isset($p_login_view->Pager)) $p_login_view->Pager = new cPrevNextPager($p_login_view->StartRec, $p_login_view->DisplayRecs, $p_login_view->TotalRecs) ?>
<?php if ($p_login_view->Pager->RecordCount > 0) { ?>
<table cellspacing="0" class="ewStdTable"><tbody><tr><td>
	<?php echo $Language->Phrase("Page") ?>&nbsp;
<div class="input-prepend input-append">
<!--first page button-->
	<?php if ($p_login_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-small" type="button" href="<?php echo $p_login_view->PageUrl() ?>start=<?php echo $p_login_view->Pager->FirstButton->Start ?>"><i class="icon-step-backward"></i></a>
	<?php } else { ?>
	<a class="btn btn-small" type="button" disabled="disabled"><i class="icon-step-backward"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($p_login_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-small" type="button" href="<?php echo $p_login_view->PageUrl() ?>start=<?php echo $p_login_view->Pager->PrevButton->Start ?>"><i class="icon-prev"></i></a>
	<?php } else { ?>
	<a class="btn btn-small" type="button" disabled="disabled"><i class="icon-prev"></i></a>
	<?php } ?>
<!--current page number-->
	<input class="input-mini" type="text" name="<?php echo EW_TABLE_PAGE_NO ?>" value="<?php echo $p_login_view->Pager->CurrentPage ?>">
<!--next page button-->
	<?php if ($p_login_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-small" type="button" href="<?php echo $p_login_view->PageUrl() ?>start=<?php echo $p_login_view->Pager->NextButton->Start ?>"><i class="icon-play"></i></a>
	<?php } else { ?>
	<a class="btn btn-small" type="button" disabled="disabled"><i class="icon-play"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($p_login_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-small" type="button" href="<?php echo $p_login_view->PageUrl() ?>start=<?php echo $p_login_view->Pager->LastButton->Start ?>"><i class="icon-step-forward"></i></a>
	<?php } else { ?>
	<a class="btn btn-small" type="button" disabled="disabled"><i class="icon-step-forward"></i></a>
	<?php } ?>
</div>
	&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $p_login_view->Pager->PageCount ?>
</td>
</tr></tbody></table>
<?php } else { ?>
	<p><?php echo $Language->Phrase("NoRecord") ?></p>
<?php } ?>
</td>
</tr></table>
</form>
<script type="text/javascript">
f_loginview.Init();
</script>
<?php
$p_login_view->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$p_login_view->Page_Terminate();
?>
