<?php
class db_class
{
    private $db_host,$db_user,$db_password,$db_name;
    public $db_obj, $result_obj;
    public function __construct() 
    {
        $this->db_host = EW_CONN_HOST;
        $this->db_user = EW_CONN_USER;
        $this->db_password = EW_CONN_PASS;
        $this->db_name = EW_CONN_DB;
        $this->create_connection();
    }
    public function create_connection()
    {
        $this->db_obj = new mysqli($this->db_host, $this->db_user, $this->db_password, $this->db_name);
        if($this->db_obj->connect_errno)
        {
            echo 'Database Connection Problem: '.$this->db_obj->connect_error;
        }
        $this->db_obj->set_charset('utf8');        
    }
    public function process_qry($req_qry)
    {
        $this->result_obj = $this->db_obj->query($req_qry);
        return $this->result_obj;
    }
    public function insert_id_val()
    {
        return $this->db_obj->insert_id;
    }
    public function escape_str($str_to_escape)
    {
        return $this->db_obj->real_escape_string($str_to_escape);
    }
    public function get_num_rows()
    {
        return $this->result_obj->num_rows;
    }
    public function fetch_single_array($req_qry = '')
    {
        if($req_qry != '')
        {
            $this->process_qry($req_qry);            
        }
        $result_arr = $this->result_obj->fetch_assoc();
        return $result_arr;        
    }

    public function fetch_result_arr($req_qry = '')
    {
        $final_arr = array();
        if($req_qry != '')
        {
            $this->process_qry($req_qry);            
        }
        while($result_arr = $this->result_obj->fetch_assoc())
        {
            $final_arr[] = $result_arr;
        }
        return $final_arr;  
    }    
}
?>
