<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg10.php" ?>
<?php include_once "ewmysql10.php" ?>
<?php include_once "phpfn10.php" ?>
<?php include_once "newsinfo.php" ?>
<?php include_once "_logininfo.php" ?>
<?php include_once "news_typeinfo.php" ?>
<?php include_once "news_picturesgridcls.php" ?>
<?php include_once "userfn10.php" ?>
<?php

//
// Page class
//

$news_add = NULL; // Initialize page object first

class cnews_add extends cnews {

	// Page ID
	var $PageID = 'add';

	// Project ID
	var $ProjectID = "{F555B504-0784-474D-925D-CB2D041B48DF}";

	// Table name
	var $TableName = 'news';

	// Page object name
	var $PageObjName = 'news_add';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-error ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<table class=\"ewStdTable\"><tr><td><div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div></td></tr></table>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language, $UserAgent;

		// User agent
		$UserAgent = ew_UserAgent();
		$GLOBALS["Page"] = &$this;

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (news)
		if (!isset($GLOBALS["news"])) {
			$GLOBALS["news"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["news"];
		}

		// Table object (_login)
		if (!isset($GLOBALS['_login'])) $GLOBALS['_login'] = new c_login();

		// Table object (news_type)
		if (!isset($GLOBALS['news_type'])) $GLOBALS['news_type'] = new cnews_type();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'add', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'news', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect();
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login.php");
		}

		// Create form object
		$objForm = new cFormObj();
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up curent action

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $conn;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();
		$this->Page_Redirecting($url);

		 // Close connection
		$conn->Close();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}
	var $DbMasterFilter = "";
	var $DbDetailFilter = "";
	var $Priv = 0;
	var $OldRecordset;
	var $CopyRecord;

	// 
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError;

		// Set up master/detail parameters
		$this->SetUpMasterParms();

		// Process form if post back
		if (@$_POST["a_add"] <> "") {
			$this->CurrentAction = $_POST["a_add"]; // Get form action
			$this->CopyRecord = $this->LoadOldRecord(); // Load old recordset
			$this->LoadFormValues(); // Load form values
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (@$_GET["id"] != "") {
				$this->id->setQueryStringValue($_GET["id"]);
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "C"; // Copy record
			} else {
				$this->CurrentAction = "I"; // Display blank record
				$this->LoadDefaultValues(); // Load default values
			}
		}

		// Set up Breadcrumb
		$this->SetupBreadcrumb();

		// Set up detail parameters
		$this->SetUpDetailParms();

		// Validate form if post back
		if (@$_POST["a_add"] <> "") {
			if (!$this->ValidateForm()) {
				$this->CurrentAction = "I"; // Form error, reset action
				$this->EventCancelled = TRUE; // Event cancelled
				$this->RestoreFormValues(); // Restore form values
				$this->setFailureMessage($gsFormError);
			}
		}

		// Perform action based on action code
		switch ($this->CurrentAction) {
			case "I": // Blank record, no action required
				break;
			case "C": // Copy an existing record
				if (!$this->LoadRow()) { // Load record based on key
					if ($this->getFailureMessage() == "") $this->setFailureMessage($Language->Phrase("NoRecord")); // No record found
					$this->Page_Terminate("newslist.php"); // No matching record, return to list
				}

				// Set up detail parameters
				$this->SetUpDetailParms();
				break;
			case "A": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->AddRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->Phrase("AddSuccess")); // Set up success message
					if ($this->getCurrentDetailTable() <> "") // Master/detail add
						$sReturnUrl = $this->GetDetailUrl();
					else
						$sReturnUrl = $this->getReturnUrl();
					if (ew_GetPageName($sReturnUrl) == "newsview.php")
						$sReturnUrl = $this->GetViewUrl(); // View paging, return to view page with keyurl directly
					$this->Page_Terminate($sReturnUrl); // Clean up and return
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->RestoreFormValues(); // Add failed, restore form values

					// Set up detail parameters
					$this->SetUpDetailParms();
				}
		}

		// Render row based on row type
		$this->RowType = EW_ROWTYPE_ADD;  // Render add type

		// Render row
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Get upload files
	function GetUploadFiles() {
		global $objForm;

		// Get upload data
		$this->thumb->Upload->Index = $objForm->Index;
		if ($this->thumb->Upload->UploadFile()) {

			// No action required
		} else {
			echo $this->thumb->Upload->Message;
			$this->Page_Terminate();
			exit();
		}
		$this->thumb->CurrentValue = $this->thumb->Upload->FileName;
		$this->pdf->Upload->Index = $objForm->Index;
		if ($this->pdf->Upload->UploadFile()) {

			// No action required
		} else {
			echo $this->pdf->Upload->Message;
			$this->Page_Terminate();
			exit();
		}
		$this->pdf->CurrentValue = $this->pdf->Upload->FileName;
	}

	// Load default values
	function LoadDefaultValues() {
		$this->lang_filter->CurrentValue = 1;
		$this->news_type_id->CurrentValue = NULL;
		$this->news_type_id->OldValue = $this->news_type_id->CurrentValue;
		$this->is_imp->CurrentValue = 0;
		$this->external_link->CurrentValue = NULL;
		$this->external_link->OldValue = $this->external_link->CurrentValue;
		$this->title->CurrentValue = NULL;
		$this->title->OldValue = $this->title->CurrentValue;
		$this->title_ar->CurrentValue = NULL;
		$this->title_ar->OldValue = $this->title_ar->CurrentValue;
		$this->thumb->Upload->DbValue = NULL;
		$this->thumb->OldValue = $this->thumb->Upload->DbValue;
		$this->thumb->CurrentValue = NULL; // Clear file related field
		$this->pdf->Upload->DbValue = NULL;
		$this->pdf->OldValue = $this->pdf->Upload->DbValue;
		$this->pdf->CurrentValue = NULL; // Clear file related field
		$this->news_date->CurrentValue = NULL;
		$this->news_date->OldValue = $this->news_date->CurrentValue;
		$this->description->CurrentValue = NULL;
		$this->description->OldValue = $this->description->CurrentValue;
		$this->description_ar->CurrentValue = NULL;
		$this->description_ar->OldValue = $this->description_ar->CurrentValue;
		$this->added_by->CurrentValue = NULL;
		$this->added_by->OldValue = $this->added_by->CurrentValue;
	}

	// Load form values
	function LoadFormValues() {

		// Load from form
		global $objForm;
		$this->GetUploadFiles(); // Get upload files
		if (!$this->lang_filter->FldIsDetailKey) {
			$this->lang_filter->setFormValue($objForm->GetValue("x_lang_filter"));
		}
		if (!$this->news_type_id->FldIsDetailKey) {
			$this->news_type_id->setFormValue($objForm->GetValue("x_news_type_id"));
		}
		if (!$this->is_imp->FldIsDetailKey) {
			$this->is_imp->setFormValue($objForm->GetValue("x_is_imp"));
		}
		if (!$this->external_link->FldIsDetailKey) {
			$this->external_link->setFormValue($objForm->GetValue("x_external_link"));
		}
		if (!$this->title->FldIsDetailKey) {
			$this->title->setFormValue($objForm->GetValue("x_title"));
		}
		if (!$this->title_ar->FldIsDetailKey) {
			$this->title_ar->setFormValue($objForm->GetValue("x_title_ar"));
		}
		if (!$this->news_date->FldIsDetailKey) {
			$this->news_date->setFormValue($objForm->GetValue("x_news_date"));
			$this->news_date->CurrentValue = ew_UnFormatDateTime($this->news_date->CurrentValue, 7);
		}
		if (!$this->description->FldIsDetailKey) {
			$this->description->setFormValue($objForm->GetValue("x_description"));
		}
		if (!$this->description_ar->FldIsDetailKey) {
			$this->description_ar->setFormValue($objForm->GetValue("x_description_ar"));
		}
		if (!$this->added_by->FldIsDetailKey) {
			$this->added_by->setFormValue($objForm->GetValue("x_added_by"));
		}
	}

	// Restore form values
	function RestoreFormValues() {
		global $objForm;
		$this->LoadOldRecord();
		$this->lang_filter->CurrentValue = $this->lang_filter->FormValue;
		$this->news_type_id->CurrentValue = $this->news_type_id->FormValue;
		$this->is_imp->CurrentValue = $this->is_imp->FormValue;
		$this->external_link->CurrentValue = $this->external_link->FormValue;
		$this->title->CurrentValue = $this->title->FormValue;
		$this->title_ar->CurrentValue = $this->title_ar->FormValue;
		$this->news_date->CurrentValue = $this->news_date->FormValue;
		$this->news_date->CurrentValue = ew_UnFormatDateTime($this->news_date->CurrentValue, 7);
		$this->description->CurrentValue = $this->description->FormValue;
		$this->description_ar->CurrentValue = $this->description_ar->FormValue;
		$this->added_by->CurrentValue = $this->added_by->FormValue;
	}

	// Load row based on key values
	function LoadRow() {
		global $conn, $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		global $conn;
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->id->setDbValue($rs->fields('id'));
		$this->lang_filter->setDbValue($rs->fields('lang_filter'));
		$this->news_type_id->setDbValue($rs->fields('news_type_id'));
		$this->is_imp->setDbValue($rs->fields('is_imp'));
		$this->external_link->setDbValue($rs->fields('external_link'));
		$this->title->setDbValue($rs->fields('title'));
		$this->title_ar->setDbValue($rs->fields('title_ar'));
		$this->thumb->Upload->DbValue = $rs->fields('thumb');
		$this->pdf->Upload->DbValue = $rs->fields('pdf');
		$this->news_date->setDbValue($rs->fields('news_date'));
		$this->description->setDbValue($rs->fields('description'));
		$this->description_ar->setDbValue($rs->fields('description_ar'));
		$this->added_by->setDbValue($rs->fields('added_by'));
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->lang_filter->DbValue = $row['lang_filter'];
		$this->news_type_id->DbValue = $row['news_type_id'];
		$this->is_imp->DbValue = $row['is_imp'];
		$this->external_link->DbValue = $row['external_link'];
		$this->title->DbValue = $row['title'];
		$this->title_ar->DbValue = $row['title_ar'];
		$this->thumb->Upload->DbValue = $row['thumb'];
		$this->pdf->Upload->DbValue = $row['pdf'];
		$this->news_date->DbValue = $row['news_date'];
		$this->description->DbValue = $row['description'];
		$this->description_ar->DbValue = $row['description_ar'];
		$this->added_by->DbValue = $row['added_by'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$bValidKey = FALSE;

		// Load old recordset
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$this->OldRecordset = ew_LoadRecordset($sSql);
			$this->LoadRowValues($this->OldRecordset); // Load row values
		} else {
			$this->OldRecordset = NULL;
		}
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $conn, $Security, $Language;
		global $gsLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// lang_filter
		// news_type_id
		// is_imp
		// external_link
		// title
		// title_ar
		// thumb
		// pdf
		// news_date
		// description
		// description_ar
		// added_by

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// lang_filter
			if (strval($this->lang_filter->CurrentValue) <> "") {
				switch ($this->lang_filter->CurrentValue) {
					case $this->lang_filter->FldTagValue(1):
						$this->lang_filter->ViewValue = $this->lang_filter->FldTagCaption(1) <> "" ? $this->lang_filter->FldTagCaption(1) : $this->lang_filter->CurrentValue;
						break;
					case $this->lang_filter->FldTagValue(2):
						$this->lang_filter->ViewValue = $this->lang_filter->FldTagCaption(2) <> "" ? $this->lang_filter->FldTagCaption(2) : $this->lang_filter->CurrentValue;
						break;
					case $this->lang_filter->FldTagValue(3):
						$this->lang_filter->ViewValue = $this->lang_filter->FldTagCaption(3) <> "" ? $this->lang_filter->FldTagCaption(3) : $this->lang_filter->CurrentValue;
						break;
					default:
						$this->lang_filter->ViewValue = $this->lang_filter->CurrentValue;
				}
			} else {
				$this->lang_filter->ViewValue = NULL;
			}
			$this->lang_filter->ViewCustomAttributes = "";

			// news_type_id
			if (strval($this->news_type_id->CurrentValue) <> "") {
				$sFilterWrk = "`id`" . ew_SearchString("=", $this->news_type_id->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `id`, `name` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `news_type`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->news_type_id, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->news_type_id->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->news_type_id->ViewValue = $this->news_type_id->CurrentValue;
				}
			} else {
				$this->news_type_id->ViewValue = NULL;
			}
			$this->news_type_id->ViewCustomAttributes = "";

			// is_imp
			if (strval($this->is_imp->CurrentValue) <> "") {
				switch ($this->is_imp->CurrentValue) {
					case $this->is_imp->FldTagValue(1):
						$this->is_imp->ViewValue = $this->is_imp->FldTagCaption(1) <> "" ? $this->is_imp->FldTagCaption(1) : $this->is_imp->CurrentValue;
						break;
					case $this->is_imp->FldTagValue(2):
						$this->is_imp->ViewValue = $this->is_imp->FldTagCaption(2) <> "" ? $this->is_imp->FldTagCaption(2) : $this->is_imp->CurrentValue;
						break;
					default:
						$this->is_imp->ViewValue = $this->is_imp->CurrentValue;
				}
			} else {
				$this->is_imp->ViewValue = NULL;
			}
			$this->is_imp->ViewCustomAttributes = "";

			// external_link
			$this->external_link->ViewValue = $this->external_link->CurrentValue;
			$this->external_link->ViewCustomAttributes = "";

			// title
			$this->title->ViewValue = $this->title->CurrentValue;
			$this->title->ViewCustomAttributes = "";

			// title_ar
			$this->title_ar->ViewValue = $this->title_ar->CurrentValue;
			$this->title_ar->ViewCustomAttributes = "";

			// thumb
			$this->thumb->UploadPath = "../uploads/news/thumb";
			if (!ew_Empty($this->thumb->Upload->DbValue)) {
				$this->thumb->ImageAlt = $this->thumb->FldAlt();
				$this->thumb->ViewValue = ew_UploadPathEx(FALSE, $this->thumb->UploadPath) . $this->thumb->Upload->DbValue;
			} else {
				$this->thumb->ViewValue = "";
			}
			$this->thumb->ViewCustomAttributes = "";

			// pdf
			$this->pdf->UploadPath = "../uploads/news/pdf";
			if (!ew_Empty($this->pdf->Upload->DbValue)) {
				$this->pdf->ViewValue = $this->pdf->Upload->DbValue;
			} else {
				$this->pdf->ViewValue = "";
			}
			$this->pdf->ViewCustomAttributes = "";

			// news_date
			$this->news_date->ViewValue = $this->news_date->CurrentValue;
			$this->news_date->ViewValue = ew_FormatDateTime($this->news_date->ViewValue, 7);
			$this->news_date->ViewCustomAttributes = "";

			// description
			$this->description->ViewValue = $this->description->CurrentValue;
			$this->description->ViewCustomAttributes = "";

			// description_ar
			$this->description_ar->ViewValue = $this->description_ar->CurrentValue;
			$this->description_ar->ViewCustomAttributes = "";

			// added_by
			if (strval($this->added_by->CurrentValue) <> "") {
				$sFilterWrk = "`login_id`" . ew_SearchString("=", $this->added_by->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `login_id`, `login_name` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `login`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->added_by, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->added_by->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->added_by->ViewValue = $this->added_by->CurrentValue;
				}
			} else {
				$this->added_by->ViewValue = NULL;
			}
			$this->added_by->ViewCustomAttributes = "";

			// lang_filter
			$this->lang_filter->LinkCustomAttributes = "";
			$this->lang_filter->HrefValue = "";
			$this->lang_filter->TooltipValue = "";

			// news_type_id
			$this->news_type_id->LinkCustomAttributes = "";
			$this->news_type_id->HrefValue = "";
			$this->news_type_id->TooltipValue = "";

			// is_imp
			$this->is_imp->LinkCustomAttributes = "";
			$this->is_imp->HrefValue = "";
			$this->is_imp->TooltipValue = "";

			// external_link
			$this->external_link->LinkCustomAttributes = "";
			$this->external_link->HrefValue = "";
			$this->external_link->TooltipValue = "";

			// title
			$this->title->LinkCustomAttributes = "";
			$this->title->HrefValue = "";
			$this->title->TooltipValue = "";

			// title_ar
			$this->title_ar->LinkCustomAttributes = "";
			$this->title_ar->HrefValue = "";
			$this->title_ar->TooltipValue = "";

			// thumb
			$this->thumb->LinkCustomAttributes = "";
			$this->thumb->HrefValue = "";
			$this->thumb->HrefValue2 = $this->thumb->UploadPath . $this->thumb->Upload->DbValue;
			$this->thumb->TooltipValue = "";

			// pdf
			$this->pdf->LinkCustomAttributes = "";
			$this->pdf->HrefValue = "";
			$this->pdf->HrefValue2 = $this->pdf->UploadPath . $this->pdf->Upload->DbValue;
			$this->pdf->TooltipValue = "";

			// news_date
			$this->news_date->LinkCustomAttributes = "";
			$this->news_date->HrefValue = "";
			$this->news_date->TooltipValue = "";

			// description
			$this->description->LinkCustomAttributes = "";
			$this->description->HrefValue = "";
			$this->description->TooltipValue = "";

			// description_ar
			$this->description_ar->LinkCustomAttributes = "";
			$this->description_ar->HrefValue = "";
			$this->description_ar->TooltipValue = "";

			// added_by
			$this->added_by->LinkCustomAttributes = "";
			$this->added_by->HrefValue = "";
			$this->added_by->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_ADD) { // Add row

			// lang_filter
			$this->lang_filter->EditCustomAttributes = "";
			$arwrk = array();
			$arwrk[] = array($this->lang_filter->FldTagValue(1), $this->lang_filter->FldTagCaption(1) <> "" ? $this->lang_filter->FldTagCaption(1) : $this->lang_filter->FldTagValue(1));
			$arwrk[] = array($this->lang_filter->FldTagValue(2), $this->lang_filter->FldTagCaption(2) <> "" ? $this->lang_filter->FldTagCaption(2) : $this->lang_filter->FldTagValue(2));
			$arwrk[] = array($this->lang_filter->FldTagValue(3), $this->lang_filter->FldTagCaption(3) <> "" ? $this->lang_filter->FldTagCaption(3) : $this->lang_filter->FldTagValue(3));
			$this->lang_filter->EditValue = $arwrk;

			// news_type_id
			$this->news_type_id->EditCustomAttributes = "";
			if ($this->news_type_id->getSessionValue() <> "") {
				$this->news_type_id->CurrentValue = $this->news_type_id->getSessionValue();
			if (strval($this->news_type_id->CurrentValue) <> "") {
				$sFilterWrk = "`id`" . ew_SearchString("=", $this->news_type_id->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `id`, `name` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `news_type`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->news_type_id, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->news_type_id->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->news_type_id->ViewValue = $this->news_type_id->CurrentValue;
				}
			} else {
				$this->news_type_id->ViewValue = NULL;
			}
			$this->news_type_id->ViewCustomAttributes = "";
			} else {
			$sFilterWrk = "";
			$sSqlWrk = "SELECT `id`, `name` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `news_type`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->news_type_id, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect"), "", "", "", "", "", "", ""));
			$this->news_type_id->EditValue = $arwrk;
			}

			// is_imp
			$this->is_imp->EditCustomAttributes = "";
			$arwrk = array();
			$arwrk[] = array($this->is_imp->FldTagValue(1), $this->is_imp->FldTagCaption(1) <> "" ? $this->is_imp->FldTagCaption(1) : $this->is_imp->FldTagValue(1));
			$arwrk[] = array($this->is_imp->FldTagValue(2), $this->is_imp->FldTagCaption(2) <> "" ? $this->is_imp->FldTagCaption(2) : $this->is_imp->FldTagValue(2));
			$this->is_imp->EditValue = $arwrk;

			// external_link
			$this->external_link->EditCustomAttributes = "";
			$this->external_link->EditValue = $this->external_link->CurrentValue;
			$this->external_link->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->external_link->FldCaption()));

			// title
			$this->title->EditCustomAttributes = "";
			$this->title->EditValue = ew_HtmlEncode($this->title->CurrentValue);
			$this->title->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->title->FldCaption()));

			// title_ar
			$this->title_ar->EditCustomAttributes = "";
			$this->title_ar->EditValue = ew_HtmlEncode($this->title_ar->CurrentValue);
			$this->title_ar->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->title_ar->FldCaption()));

			// thumb
			$this->thumb->EditCustomAttributes = "";
			$this->thumb->UploadPath = "../uploads/news/thumb";
			if (!ew_Empty($this->thumb->Upload->DbValue)) {
				$this->thumb->ImageAlt = $this->thumb->FldAlt();
				$this->thumb->EditValue = ew_UploadPathEx(FALSE, $this->thumb->UploadPath) . $this->thumb->Upload->DbValue;
			} else {
				$this->thumb->EditValue = "";
			}
			if (($this->CurrentAction == "I" || $this->CurrentAction == "C") && !$this->EventCancelled) ew_RenderUploadField($this->thumb);

			// pdf
			$this->pdf->EditCustomAttributes = "";
			$this->pdf->UploadPath = "../uploads/news/pdf";
			if (!ew_Empty($this->pdf->Upload->DbValue)) {
				$this->pdf->EditValue = $this->pdf->Upload->DbValue;
			} else {
				$this->pdf->EditValue = "";
			}
			if (($this->CurrentAction == "I" || $this->CurrentAction == "C") && !$this->EventCancelled) ew_RenderUploadField($this->pdf);

			// news_date
			$this->news_date->EditCustomAttributes = "";
			$this->news_date->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->news_date->CurrentValue, 7));
			$this->news_date->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->news_date->FldCaption()));

			// description
			$this->description->EditCustomAttributes = "";
			$this->description->EditValue = $this->description->CurrentValue;
			$this->description->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->description->FldCaption()));

			// description_ar
			$this->description_ar->EditCustomAttributes = "";
			$this->description_ar->EditValue = $this->description_ar->CurrentValue;
			$this->description_ar->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->description_ar->FldCaption()));

			// added_by
			$this->added_by->EditCustomAttributes = "";
			$sFilterWrk = "";
			$sSqlWrk = "SELECT `login_id`, `login_name` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `login`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->added_by, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect"), "", "", "", "", "", "", ""));
			$this->added_by->EditValue = $arwrk;

			// Edit refer script
			// lang_filter

			$this->lang_filter->HrefValue = "";

			// news_type_id
			$this->news_type_id->HrefValue = "";

			// is_imp
			$this->is_imp->HrefValue = "";

			// external_link
			$this->external_link->HrefValue = "";

			// title
			$this->title->HrefValue = "";

			// title_ar
			$this->title_ar->HrefValue = "";

			// thumb
			$this->thumb->HrefValue = "";
			$this->thumb->HrefValue2 = $this->thumb->UploadPath . $this->thumb->Upload->DbValue;

			// pdf
			$this->pdf->HrefValue = "";
			$this->pdf->HrefValue2 = $this->pdf->UploadPath . $this->pdf->Upload->DbValue;

			// news_date
			$this->news_date->HrefValue = "";

			// description
			$this->description->HrefValue = "";

			// description_ar
			$this->description_ar->HrefValue = "";

			// added_by
			$this->added_by->HrefValue = "";
		}
		if ($this->RowType == EW_ROWTYPE_ADD ||
			$this->RowType == EW_ROWTYPE_EDIT ||
			$this->RowType == EW_ROWTYPE_SEARCH) { // Add / Edit / Search row
			$this->SetupFieldTitles();
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	function ValidateForm() {
		global $Language, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return ($gsFormError == "");
		if ($this->lang_filter->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->lang_filter->FldCaption());
		}
		if (!$this->news_type_id->FldIsDetailKey && !is_null($this->news_type_id->FormValue) && $this->news_type_id->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->news_type_id->FldCaption());
		}
		if ($this->is_imp->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->is_imp->FldCaption());
		}
		if (!ew_CheckEuroDate($this->news_date->FormValue)) {
			ew_AddMessage($gsFormError, $this->news_date->FldErrMsg());
		}
		if (!$this->added_by->FldIsDetailKey && !is_null($this->added_by->FormValue) && $this->added_by->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->added_by->FldCaption());
		}

		// Validate detail grid
		$DetailTblVar = explode(",", $this->getCurrentDetailTable());
		if (in_array("news_pictures", $DetailTblVar) && $GLOBALS["news_pictures"]->DetailAdd) {
			if (!isset($GLOBALS["news_pictures_grid"])) $GLOBALS["news_pictures_grid"] = new cnews_pictures_grid(); // get detail page object
			$GLOBALS["news_pictures_grid"]->ValidateGridForm();
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsFormError, $sFormCustomError);
		}
		return $ValidateForm;
	}

	// Add record
	function AddRow($rsold = NULL) {
		global $conn, $Language, $Security;

		// Begin transaction
		if ($this->getCurrentDetailTable() <> "")
			$conn->BeginTrans();

		// Load db values from rsold
		if ($rsold) {
			$this->LoadDbValues($rsold);
			$this->thumb->OldUploadPath = "../uploads/news/thumb";
			$this->thumb->UploadPath = $this->thumb->OldUploadPath;
			$this->pdf->OldUploadPath = "../uploads/news/pdf";
			$this->pdf->UploadPath = $this->pdf->OldUploadPath;
		}
		$rsnew = array();

		// lang_filter
		$this->lang_filter->SetDbValueDef($rsnew, $this->lang_filter->CurrentValue, 0, strval($this->lang_filter->CurrentValue) == "");

		// news_type_id
		$this->news_type_id->SetDbValueDef($rsnew, $this->news_type_id->CurrentValue, 0, FALSE);

		// is_imp
		$this->is_imp->SetDbValueDef($rsnew, $this->is_imp->CurrentValue, 0, strval($this->is_imp->CurrentValue) == "");

		// external_link
		$this->external_link->SetDbValueDef($rsnew, $this->external_link->CurrentValue, NULL, FALSE);

		// title
		$this->title->SetDbValueDef($rsnew, $this->title->CurrentValue, NULL, FALSE);

		// title_ar
		$this->title_ar->SetDbValueDef($rsnew, $this->title_ar->CurrentValue, NULL, FALSE);

		// thumb
		if (!$this->thumb->Upload->KeepFile) {
			if ($this->thumb->Upload->FileName == "") {
				$rsnew['thumb'] = NULL;
			} else {
				$rsnew['thumb'] = $this->thumb->Upload->FileName;
			}
		}

		// pdf
		if (!$this->pdf->Upload->KeepFile) {
			if ($this->pdf->Upload->FileName == "") {
				$rsnew['pdf'] = NULL;
			} else {
				$rsnew['pdf'] = $this->pdf->Upload->FileName;
			}
		}

		// news_date
		$this->news_date->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->news_date->CurrentValue, 7), NULL, FALSE);

		// description
		$this->description->SetDbValueDef($rsnew, $this->description->CurrentValue, NULL, FALSE);

		// description_ar
		$this->description_ar->SetDbValueDef($rsnew, $this->description_ar->CurrentValue, NULL, FALSE);

		// added_by
		$this->added_by->SetDbValueDef($rsnew, $this->added_by->CurrentValue, 0, FALSE);
		if (!$this->thumb->Upload->KeepFile) {
			$this->thumb->UploadPath = "../uploads/news/thumb";
			if (!ew_Empty($this->thumb->Upload->Value)) {
				$rsnew['thumb'] = ew_UploadFileNameEx(ew_UploadPathEx(TRUE, $this->thumb->UploadPath), $rsnew['thumb']); // Get new file name
			}
		}
		if (!$this->pdf->Upload->KeepFile) {
			$this->pdf->UploadPath = "../uploads/news/pdf";
			if (!ew_Empty($this->pdf->Upload->Value)) {
				$rsnew['pdf'] = ew_UploadFileNameEx(ew_UploadPathEx(TRUE, $this->pdf->UploadPath), $rsnew['pdf']); // Get new file name
			}
		}

		// Call Row Inserting event
		$rs = ($rsold == NULL) ? NULL : $rsold->fields;
		$bInsertRow = $this->Row_Inserting($rs, $rsnew);
		if ($bInsertRow) {
			$conn->raiseErrorFn = 'ew_ErrorFn';
			$AddRow = $this->Insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($AddRow) {
				if (!$this->thumb->Upload->KeepFile) {
					if (!ew_Empty($this->thumb->Upload->Value)) {
						$this->thumb->Upload->SaveToFile($this->thumb->UploadPath, $rsnew['thumb'], TRUE);
					}
				}
				if (!$this->pdf->Upload->KeepFile) {
					if (!ew_Empty($this->pdf->Upload->Value)) {
						$this->pdf->Upload->SaveToFile($this->pdf->UploadPath, $rsnew['pdf'], TRUE);
					}
				}
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->Phrase("InsertCancelled"));
			}
			$AddRow = FALSE;
		}

		// Get insert id if necessary
		if ($AddRow) {
			$this->id->setDbValue($conn->Insert_ID());
			$rsnew['id'] = $this->id->DbValue;
		}

		// Add detail records
		if ($AddRow) {
			$DetailTblVar = explode(",", $this->getCurrentDetailTable());
			if (in_array("news_pictures", $DetailTblVar) && $GLOBALS["news_pictures"]->DetailAdd) {
				$GLOBALS["news_pictures"]->news_id->setSessionValue($this->id->CurrentValue); // Set master key
				if (!isset($GLOBALS["news_pictures_grid"])) $GLOBALS["news_pictures_grid"] = new cnews_pictures_grid(); // Get detail page object
				$AddRow = $GLOBALS["news_pictures_grid"]->GridInsert();
				if (!$AddRow)
					$GLOBALS["news_pictures"]->news_id->setSessionValue(""); // Clear master key if insert failed
			}
		}

		// Commit/Rollback transaction
		if ($this->getCurrentDetailTable() <> "") {
			if ($AddRow) {
				$conn->CommitTrans(); // Commit transaction
			} else {
				$conn->RollbackTrans(); // Rollback transaction
			}
		}
		if ($AddRow) {

			// Call Row Inserted event
			$rs = ($rsold == NULL) ? NULL : $rsold->fields;
			$this->Row_Inserted($rs, $rsnew);
		}

		// thumb
		ew_CleanUploadTempPath($this->thumb, $this->thumb->Upload->Index);

		// pdf
		ew_CleanUploadTempPath($this->pdf, $this->pdf->Upload->Index);
		return $AddRow;
	}

	// Set up master/detail based on QueryString
	function SetUpMasterParms() {
		$bValidMaster = FALSE;

		// Get the keys for master table
		if (isset($_GET[EW_TABLE_SHOW_MASTER])) {
			$sMasterTblVar = $_GET[EW_TABLE_SHOW_MASTER];
			if ($sMasterTblVar == "") {
				$bValidMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($sMasterTblVar == "news_type") {
				$bValidMaster = TRUE;
				if (@$_GET["id"] <> "") {
					$GLOBALS["news_type"]->id->setQueryStringValue($_GET["id"]);
					$this->news_type_id->setQueryStringValue($GLOBALS["news_type"]->id->QueryStringValue);
					$this->news_type_id->setSessionValue($this->news_type_id->QueryStringValue);
					if (!is_numeric($GLOBALS["news_type"]->id->QueryStringValue)) $bValidMaster = FALSE;
				} else {
					$bValidMaster = FALSE;
				}
			}
		}
		if ($bValidMaster) {

			// Save current master table
			$this->setCurrentMasterTable($sMasterTblVar);

			// Reset start record counter (new master key)
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);

			// Clear previous master key from Session
			if ($sMasterTblVar <> "news_type") {
				if ($this->news_type_id->QueryStringValue == "") $this->news_type_id->setSessionValue("");
			}
		}
		$this->DbMasterFilter = $this->GetMasterFilter(); //  Get master filter
		$this->DbDetailFilter = $this->GetDetailFilter(); // Get detail filter
	}

	// Set up detail parms based on QueryString
	function SetUpDetailParms() {

		// Get the keys for master table
		if (isset($_GET[EW_TABLE_SHOW_DETAIL])) {
			$sDetailTblVar = $_GET[EW_TABLE_SHOW_DETAIL];
			$this->setCurrentDetailTable($sDetailTblVar);
		} else {
			$sDetailTblVar = $this->getCurrentDetailTable();
		}
		if ($sDetailTblVar <> "") {
			$DetailTblVar = explode(",", $sDetailTblVar);
			if (in_array("news_pictures", $DetailTblVar)) {
				if (!isset($GLOBALS["news_pictures_grid"]))
					$GLOBALS["news_pictures_grid"] = new cnews_pictures_grid;
				if ($GLOBALS["news_pictures_grid"]->DetailAdd) {
					if ($this->CopyRecord)
						$GLOBALS["news_pictures_grid"]->CurrentMode = "copy";
					else
						$GLOBALS["news_pictures_grid"]->CurrentMode = "add";
					$GLOBALS["news_pictures_grid"]->CurrentAction = "gridadd";

					// Save current master table to detail table
					$GLOBALS["news_pictures_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["news_pictures_grid"]->setStartRecordNumber(1);
					$GLOBALS["news_pictures_grid"]->news_id->FldIsDetailKey = TRUE;
					$GLOBALS["news_pictures_grid"]->news_id->CurrentValue = $this->id->CurrentValue;
					$GLOBALS["news_pictures_grid"]->news_id->setSessionValue($GLOBALS["news_pictures_grid"]->news_id->CurrentValue);
				}
			}
		}
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$PageCaption = $this->TableCaption();
		$Breadcrumb->Add("list", "<span id=\"ewPageCaption\">" . $PageCaption . "</span>", "newslist.php", $this->TableVar);
		$PageCaption = ($this->CurrentAction == "C") ? $Language->Phrase("Copy") : $Language->Phrase("Add");
		$Breadcrumb->Add("add", "<span id=\"ewPageCaption\">" . $PageCaption . "</span>", ew_CurrentUrl(), $this->TableVar);
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($news_add)) $news_add = new cnews_add();

// Page init
$news_add->Page_Init();

// Page main
$news_add->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$news_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Page object
var news_add = new ew_Page("news_add");
news_add.PageID = "add"; // Page ID
var EW_PAGE_ID = news_add.PageID; // For backward compatibility

// Form object
var fnewsadd = new ew_Form("fnewsadd");

// Validate form
fnewsadd.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);
	this.PostAutoSuggest();
	if ($fobj.find("#a_confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.FormKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = $fobj.find("#a_list").val() == "gridinsert";
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
			elm = this.GetElements("x" + infix + "_lang_filter");
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($news->lang_filter->FldCaption()) ?>");
			elm = this.GetElements("x" + infix + "_news_type_id");
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($news->news_type_id->FldCaption()) ?>");
			elm = this.GetElements("x" + infix + "_is_imp");
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($news->is_imp->FldCaption()) ?>");
			elm = this.GetElements("x" + infix + "_news_date");
			if (elm && !ew_CheckEuroDate(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($news->news_date->FldErrMsg()) ?>");
			elm = this.GetElements("x" + infix + "_added_by");
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($news->added_by->FldCaption()) ?>");

			// Set up row object
			ew_ElementsToRow(fobj);

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ewForms[val])
			if (!ewForms[val].Validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fnewsadd.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fnewsadd.ValidateRequired = true;
<?php } else { ?>
fnewsadd.ValidateRequired = false; 
<?php } ?>

// Dynamic selection lists
fnewsadd.Lists["x_news_type_id"] = {"LinkField":"x_id","Ajax":null,"AutoFill":false,"DisplayFields":["x_name","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnewsadd.Lists["x_added_by"] = {"LinkField":"x_login_id","Ajax":null,"AutoFill":false,"DisplayFields":["x_login_name","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};

// Form object for search
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php $Breadcrumb->Render(); ?>
<?php $news_add->ShowPageHeader(); ?>
<?php
$news_add->ShowMessage();
?>
<form name="fnewsadd" id="fnewsadd" class="ewForm form-horizontal" action="<?php echo ew_CurrentPage() ?>" method="post">
<input type="hidden" name="t" value="news">
<input type="hidden" name="a_add" id="a_add" value="A">
<table cellspacing="0" class="ewGrid"><tr><td>
<table id="tbl_newsadd" class="table table-bordered table-striped">
<?php if ($news->lang_filter->Visible) { // lang_filter ?>
	<tr id="r_lang_filter">
		<td><span id="elh_news_lang_filter"><?php echo $news->lang_filter->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $news->lang_filter->CellAttributes() ?>>
<span id="el_news_lang_filter" class="control-group">
<div id="tp_x_lang_filter" class="<?php echo EW_ITEM_TEMPLATE_CLASSNAME ?>"><input type="radio" name="x_lang_filter" id="x_lang_filter" value="{value}"<?php echo $news->lang_filter->EditAttributes() ?>></div>
<div id="dsl_x_lang_filter" data-repeatcolumn="5" class="ewItemList">
<?php
$arwrk = $news->lang_filter->EditValue;
if (is_array($arwrk)) {
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($news->lang_filter->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " checked=\"checked\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;

		// Note: No spacing within the LABEL tag
?>
<?php echo ew_RepeatColumnTable($rowswrk, $rowcntwrk, 5, 1) ?>
<label class="radio"><input type="radio" data-field="x_lang_filter" name="x_lang_filter" id="x_lang_filter_<?php echo $rowcntwrk ?>" value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?><?php echo $news->lang_filter->EditAttributes() ?>><?php echo $arwrk[$rowcntwrk][1] ?></label>
<?php echo ew_RepeatColumnTable($rowswrk, $rowcntwrk, 5, 2) ?>
<?php
	}
}
?>
</div>
</span>
<?php echo $news->lang_filter->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($news->news_type_id->Visible) { // news_type_id ?>
	<tr id="r_news_type_id">
		<td><span id="elh_news_news_type_id"><?php echo $news->news_type_id->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $news->news_type_id->CellAttributes() ?>>
<?php if ($news->news_type_id->getSessionValue() <> "") { ?>
<span<?php echo $news->news_type_id->ViewAttributes() ?>>
<?php echo $news->news_type_id->ViewValue ?></span>
<input type="hidden" id="x_news_type_id" name="x_news_type_id" value="<?php echo ew_HtmlEncode($news->news_type_id->CurrentValue) ?>">
<?php } else { ?>
<select data-field="x_news_type_id" id="x_news_type_id" name="x_news_type_id"<?php echo $news->news_type_id->EditAttributes() ?>>
<?php
if (is_array($news->news_type_id->EditValue)) {
	$arwrk = $news->news_type_id->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($news->news_type_id->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
<script type="text/javascript">
fnewsadd.Lists["x_news_type_id"].Options = <?php echo (is_array($news->news_type_id->EditValue)) ? ew_ArrayToJson($news->news_type_id->EditValue, 1) : "[]" ?>;
</script>
<?php } ?>
<?php echo $news->news_type_id->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($news->is_imp->Visible) { // is_imp ?>
	<tr id="r_is_imp">
		<td><span id="elh_news_is_imp"><?php echo $news->is_imp->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $news->is_imp->CellAttributes() ?>>
<span id="el_news_is_imp" class="control-group">
<div id="tp_x_is_imp" class="<?php echo EW_ITEM_TEMPLATE_CLASSNAME ?>"><input type="radio" name="x_is_imp" id="x_is_imp" value="{value}"<?php echo $news->is_imp->EditAttributes() ?>></div>
<div id="dsl_x_is_imp" data-repeatcolumn="5" class="ewItemList">
<?php
$arwrk = $news->is_imp->EditValue;
if (is_array($arwrk)) {
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($news->is_imp->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " checked=\"checked\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;

		// Note: No spacing within the LABEL tag
?>
<?php echo ew_RepeatColumnTable($rowswrk, $rowcntwrk, 5, 1) ?>
<label class="radio"><input type="radio" data-field="x_is_imp" name="x_is_imp" id="x_is_imp_<?php echo $rowcntwrk ?>" value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?><?php echo $news->is_imp->EditAttributes() ?>><?php echo $arwrk[$rowcntwrk][1] ?></label>
<?php echo ew_RepeatColumnTable($rowswrk, $rowcntwrk, 5, 2) ?>
<?php
	}
}
?>
</div>
</span>
<?php echo $news->is_imp->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($news->external_link->Visible) { // external_link ?>
	<tr id="r_external_link">
		<td><span id="elh_news_external_link"><?php echo $news->external_link->FldCaption() ?></span></td>
		<td<?php echo $news->external_link->CellAttributes() ?>>
<span id="el_news_external_link" class="control-group">
<textarea data-field="x_external_link" name="x_external_link" id="x_external_link" cols="35" rows="4" placeholder="<?php echo $news->external_link->PlaceHolder ?>"<?php echo $news->external_link->EditAttributes() ?>><?php echo $news->external_link->EditValue ?></textarea>
</span>
<?php echo $news->external_link->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($news->title->Visible) { // title ?>
	<tr id="r_title">
		<td><span id="elh_news_title"><?php echo $news->title->FldCaption() ?></span></td>
		<td<?php echo $news->title->CellAttributes() ?>>
<span id="el_news_title" class="control-group">
<input type="text" data-field="x_title" name="x_title" id="x_title" size="30" maxlength="250" placeholder="<?php echo $news->title->PlaceHolder ?>" value="<?php echo $news->title->EditValue ?>"<?php echo $news->title->EditAttributes() ?>>
</span>
<?php echo $news->title->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($news->title_ar->Visible) { // title_ar ?>
	<tr id="r_title_ar">
		<td><span id="elh_news_title_ar"><?php echo $news->title_ar->FldCaption() ?></span></td>
		<td<?php echo $news->title_ar->CellAttributes() ?>>
<span id="el_news_title_ar" class="control-group">
<input type="text" data-field="x_title_ar" name="x_title_ar" id="x_title_ar" size="30" maxlength="250" placeholder="<?php echo $news->title_ar->PlaceHolder ?>" value="<?php echo $news->title_ar->EditValue ?>"<?php echo $news->title_ar->EditAttributes() ?>>
</span>
<?php echo $news->title_ar->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($news->thumb->Visible) { // thumb ?>
	<tr id="r_thumb">
		<td><span id="elh_news_thumb"><?php echo $news->thumb->FldCaption() ?></span></td>
		<td<?php echo $news->thumb->CellAttributes() ?>>
<span id="el_news_thumb" class="control-group">
<span id="fd_x_thumb">
<span class="btn btn-small fileinput-button">
	<span><?php echo $Language->Phrase("ChooseFile") ?></span>
	<input type="file" data-field="x_thumb" name="x_thumb" id="x_thumb">
</span>
<input type="hidden" name="fn_x_thumb" id= "fn_x_thumb" value="<?php echo $news->thumb->Upload->FileName ?>">
<input type="hidden" name="fa_x_thumb" id= "fa_x_thumb" value="0">
<input type="hidden" name="fs_x_thumb" id= "fs_x_thumb" value="250">
</span>
<table id="ft_x_thumb" class="table table-condensed pull-left ewUploadTable"><tbody class="files"></tbody></table>
</span>
<?php echo $news->thumb->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($news->pdf->Visible) { // pdf ?>
	<tr id="r_pdf">
		<td><span id="elh_news_pdf"><?php echo $news->pdf->FldCaption() ?></span></td>
		<td<?php echo $news->pdf->CellAttributes() ?>>
<span id="el_news_pdf" class="control-group">
<span id="fd_x_pdf">
<span class="btn btn-small fileinput-button">
	<span><?php echo $Language->Phrase("ChooseFile") ?></span>
	<input type="file" data-field="x_pdf" name="x_pdf" id="x_pdf">
</span>
<input type="hidden" name="fn_x_pdf" id= "fn_x_pdf" value="<?php echo $news->pdf->Upload->FileName ?>">
<input type="hidden" name="fa_x_pdf" id= "fa_x_pdf" value="0">
<input type="hidden" name="fs_x_pdf" id= "fs_x_pdf" value="250">
</span>
<table id="ft_x_pdf" class="table table-condensed pull-left ewUploadTable"><tbody class="files"></tbody></table>
</span>
<?php echo $news->pdf->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($news->news_date->Visible) { // news_date ?>
	<tr id="r_news_date">
		<td><span id="elh_news_news_date"><?php echo $news->news_date->FldCaption() ?></span></td>
		<td<?php echo $news->news_date->CellAttributes() ?>>
<span id="el_news_news_date" class="control-group">
<input type="text" data-field="x_news_date" name="x_news_date" id="x_news_date" placeholder="<?php echo $news->news_date->PlaceHolder ?>" value="<?php echo $news->news_date->EditValue ?>"<?php echo $news->news_date->EditAttributes() ?>>
<?php if (!$news->news_date->ReadOnly && !$news->news_date->Disabled && @$news->news_date->EditAttrs["readonly"] == "" && @$news->news_date->EditAttrs["disabled"] == "") { ?>
<button id="cal_x_news_date" name="cal_x_news_date" class="btn" type="button"><img src="phpimages/calendar.png" id="cal_x_news_date" alt="<?php echo $Language->Phrase("PickDate") ?>" title="<?php echo $Language->Phrase("PickDate") ?>" style="border: 0;"></button><script type="text/javascript">
ew_CreateCalendar("fnewsadd", "x_news_date", "%d/%m/%Y");
</script>
<?php } ?>
</span>
<?php echo $news->news_date->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($news->description->Visible) { // description ?>
	<tr id="r_description">
		<td><span id="elh_news_description"><?php echo $news->description->FldCaption() ?></span></td>
		<td<?php echo $news->description->CellAttributes() ?>>
<span id="el_news_description" class="control-group">
<textarea data-field="x_description" class="editor" name="x_description" id="x_description" cols="35" rows="4" placeholder="<?php echo $news->description->PlaceHolder ?>"<?php echo $news->description->EditAttributes() ?>><?php echo $news->description->EditValue ?></textarea>
<script type="text/javascript">
ew_CreateEditor("fnewsadd", "x_description", 35, 4, <?php echo ($news->description->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $news->description->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($news->description_ar->Visible) { // description_ar ?>
	<tr id="r_description_ar">
		<td><span id="elh_news_description_ar"><?php echo $news->description_ar->FldCaption() ?></span></td>
		<td<?php echo $news->description_ar->CellAttributes() ?>>
<span id="el_news_description_ar" class="control-group">
<textarea data-field="x_description_ar" class="editor" name="x_description_ar" id="x_description_ar" cols="35" rows="4" placeholder="<?php echo $news->description_ar->PlaceHolder ?>"<?php echo $news->description_ar->EditAttributes() ?>><?php echo $news->description_ar->EditValue ?></textarea>
<script type="text/javascript">
ew_CreateEditor("fnewsadd", "x_description_ar", 35, 4, <?php echo ($news->description_ar->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $news->description_ar->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($news->added_by->Visible) { // added_by ?>
	<tr id="r_added_by">
		<td><span id="elh_news_added_by"><?php echo $news->added_by->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $news->added_by->CellAttributes() ?>>
<span id="el_news_added_by" class="control-group">
<select data-field="x_added_by" id="x_added_by" name="x_added_by"<?php echo $news->added_by->EditAttributes() ?>>
<?php
if (is_array($news->added_by->EditValue)) {
	$arwrk = $news->added_by->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($news->added_by->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
<script type="text/javascript">
fnewsadd.Lists["x_added_by"].Options = <?php echo (is_array($news->added_by->EditValue)) ? ew_ArrayToJson($news->added_by->EditValue, 1) : "[]" ?>;
</script>
</span>
<?php echo $news->added_by->CustomMsg ?></td>
	</tr>
<?php } ?>
</table>
</td></tr></table>
<?php
	if (in_array("news_pictures", explode(",", $news->getCurrentDetailTable())) && $news_pictures->DetailAdd) {
?>
<?php include_once "news_picturesgrid.php" ?>
<?php } ?>
<button class="btn btn-primary ewButton" name="btnAction" id="btnAction" type="submit"><?php echo $Language->Phrase("AddBtn") ?></button>
</form>
<script type="text/javascript">
fnewsadd.Init();
<?php if (EW_MOBILE_REFLOW && ew_IsMobile()) { ?>
ew_Reflow();
<?php } ?>
</script>
<?php
$news_add->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$news_add->Page_Terminate();
?>
