<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg10.php" ?>
<?php include_once "ewmysql10.php" ?>
<?php include_once "phpfn10.php" ?>
<?php include_once "newsinfo.php" ?>
<?php include_once "_logininfo.php" ?>
<?php include_once "news_typeinfo.php" ?>
<?php include_once "userfn10.php" ?>
<?php

//
// Page class
//

$news_delete = NULL; // Initialize page object first

class cnews_delete extends cnews {

	// Page ID
	var $PageID = 'delete';

	// Project ID
	var $ProjectID = "{F555B504-0784-474D-925D-CB2D041B48DF}";

	// Table name
	var $TableName = 'news';

	// Page object name
	var $PageObjName = 'news_delete';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-error ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<table class=\"ewStdTable\"><tr><td><div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div></td></tr></table>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language, $UserAgent;

		// User agent
		$UserAgent = ew_UserAgent();
		$GLOBALS["Page"] = &$this;

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (news)
		if (!isset($GLOBALS["news"])) {
			$GLOBALS["news"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["news"];
		}

		// Table object (_login)
		if (!isset($GLOBALS['_login'])) $GLOBALS['_login'] = new c_login();

		// Table object (news_type)
		if (!isset($GLOBALS['news_type'])) $GLOBALS['news_type'] = new cnews_type();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'delete', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'news', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect();
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login.php");
		}
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up curent action
		$this->id->Visible = !$this->IsAdd() && !$this->IsCopy() && !$this->IsGridAdd();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $conn;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();
		$this->Page_Redirecting($url);

		 // Close connection
		$conn->Close();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}
	var $TotalRecs = 0;
	var $RecCnt;
	var $RecKeys = array();
	var $Recordset;
	var $StartRowCnt = 1;
	var $RowCnt = 0;

	//
	// Page main
	//
	function Page_Main() {
		global $Language;

		// Set up Breadcrumb
		$this->SetupBreadcrumb();

		// Load key parameters
		$this->RecKeys = $this->GetRecordKeys(); // Load record keys
		$sFilter = $this->GetKeyFilter();
		if ($sFilter == "")
			$this->Page_Terminate("newslist.php"); // Prevent SQL injection, return to list

		// Set up filter (SQL WHHERE clause) and get return SQL
		// SQL constructor in news class, newsinfo.php

		$this->CurrentFilter = $sFilter;

		// Get action
		if (@$_POST["a_delete"] <> "") {
			$this->CurrentAction = $_POST["a_delete"];
		} else {
			$this->CurrentAction = "I"; // Display record
		}
		switch ($this->CurrentAction) {
			case "D": // Delete
				$this->SendEmail = TRUE; // Send email on delete success
				if ($this->DeleteRows()) { // Delete rows
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->Phrase("DeleteSuccess")); // Set up success message
					$this->Page_Terminate($this->getReturnUrl()); // Return to caller
				}
		}
	}

// No functions
	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {
		global $conn;

		// Call Recordset Selecting event
		$this->Recordset_Selecting($this->CurrentFilter);

		// Load List page SQL
		$sSql = $this->SelectSQL();
		if ($offset > -1 && $rowcnt > -1)
			$sSql .= " LIMIT $rowcnt OFFSET $offset";

		// Load recordset
		$rs = ew_LoadRecordset($sSql);

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $conn, $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		global $conn;
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->id->setDbValue($rs->fields('id'));
		$this->lang_filter->setDbValue($rs->fields('lang_filter'));
		$this->news_type_id->setDbValue($rs->fields('news_type_id'));
		$this->is_imp->setDbValue($rs->fields('is_imp'));
		$this->external_link->setDbValue($rs->fields('external_link'));
		$this->title->setDbValue($rs->fields('title'));
		$this->title_ar->setDbValue($rs->fields('title_ar'));
		$this->thumb->Upload->DbValue = $rs->fields('thumb');
		$this->pdf->Upload->DbValue = $rs->fields('pdf');
		$this->news_date->setDbValue($rs->fields('news_date'));
		$this->description->setDbValue($rs->fields('description'));
		$this->description_ar->setDbValue($rs->fields('description_ar'));
		$this->added_by->setDbValue($rs->fields('added_by'));
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->lang_filter->DbValue = $row['lang_filter'];
		$this->news_type_id->DbValue = $row['news_type_id'];
		$this->is_imp->DbValue = $row['is_imp'];
		$this->external_link->DbValue = $row['external_link'];
		$this->title->DbValue = $row['title'];
		$this->title_ar->DbValue = $row['title_ar'];
		$this->thumb->Upload->DbValue = $row['thumb'];
		$this->pdf->Upload->DbValue = $row['pdf'];
		$this->news_date->DbValue = $row['news_date'];
		$this->description->DbValue = $row['description'];
		$this->description_ar->DbValue = $row['description_ar'];
		$this->added_by->DbValue = $row['added_by'];
	}

	// Render row values based on field settings
	function RenderRow() {
		global $conn, $Security, $Language;
		global $gsLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// lang_filter
		// news_type_id
		// is_imp
		// external_link
		// title
		// title_ar
		// thumb
		// pdf
		// news_date
		// description
		// description_ar
		// added_by

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// lang_filter
			if (strval($this->lang_filter->CurrentValue) <> "") {
				switch ($this->lang_filter->CurrentValue) {
					case $this->lang_filter->FldTagValue(1):
						$this->lang_filter->ViewValue = $this->lang_filter->FldTagCaption(1) <> "" ? $this->lang_filter->FldTagCaption(1) : $this->lang_filter->CurrentValue;
						break;
					case $this->lang_filter->FldTagValue(2):
						$this->lang_filter->ViewValue = $this->lang_filter->FldTagCaption(2) <> "" ? $this->lang_filter->FldTagCaption(2) : $this->lang_filter->CurrentValue;
						break;
					case $this->lang_filter->FldTagValue(3):
						$this->lang_filter->ViewValue = $this->lang_filter->FldTagCaption(3) <> "" ? $this->lang_filter->FldTagCaption(3) : $this->lang_filter->CurrentValue;
						break;
					default:
						$this->lang_filter->ViewValue = $this->lang_filter->CurrentValue;
				}
			} else {
				$this->lang_filter->ViewValue = NULL;
			}
			$this->lang_filter->ViewCustomAttributes = "";

			// news_type_id
			if (strval($this->news_type_id->CurrentValue) <> "") {
				$sFilterWrk = "`id`" . ew_SearchString("=", $this->news_type_id->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `id`, `name` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `news_type`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->news_type_id, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->news_type_id->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->news_type_id->ViewValue = $this->news_type_id->CurrentValue;
				}
			} else {
				$this->news_type_id->ViewValue = NULL;
			}
			$this->news_type_id->ViewCustomAttributes = "";

			// is_imp
			if (strval($this->is_imp->CurrentValue) <> "") {
				switch ($this->is_imp->CurrentValue) {
					case $this->is_imp->FldTagValue(1):
						$this->is_imp->ViewValue = $this->is_imp->FldTagCaption(1) <> "" ? $this->is_imp->FldTagCaption(1) : $this->is_imp->CurrentValue;
						break;
					case $this->is_imp->FldTagValue(2):
						$this->is_imp->ViewValue = $this->is_imp->FldTagCaption(2) <> "" ? $this->is_imp->FldTagCaption(2) : $this->is_imp->CurrentValue;
						break;
					default:
						$this->is_imp->ViewValue = $this->is_imp->CurrentValue;
				}
			} else {
				$this->is_imp->ViewValue = NULL;
			}
			$this->is_imp->ViewCustomAttributes = "";

			// title
			$this->title->ViewValue = $this->title->CurrentValue;
			$this->title->ViewCustomAttributes = "";

			// title_ar
			$this->title_ar->ViewValue = $this->title_ar->CurrentValue;
			$this->title_ar->ViewCustomAttributes = "";

			// thumb
			$this->thumb->UploadPath = "../uploads/news/thumb";
			if (!ew_Empty($this->thumb->Upload->DbValue)) {
				$this->thumb->ImageAlt = $this->thumb->FldAlt();
				$this->thumb->ViewValue = ew_UploadPathEx(FALSE, $this->thumb->UploadPath) . $this->thumb->Upload->DbValue;
			} else {
				$this->thumb->ViewValue = "";
			}
			$this->thumb->ViewCustomAttributes = "";

			// pdf
			$this->pdf->UploadPath = "../uploads/news/pdf";
			if (!ew_Empty($this->pdf->Upload->DbValue)) {
				$this->pdf->ViewValue = $this->pdf->Upload->DbValue;
			} else {
				$this->pdf->ViewValue = "";
			}
			$this->pdf->ViewCustomAttributes = "";

			// news_date
			$this->news_date->ViewValue = $this->news_date->CurrentValue;
			$this->news_date->ViewValue = ew_FormatDateTime($this->news_date->ViewValue, 7);
			$this->news_date->ViewCustomAttributes = "";

			// added_by
			if (strval($this->added_by->CurrentValue) <> "") {
				$sFilterWrk = "`login_id`" . ew_SearchString("=", $this->added_by->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `login_id`, `login_name` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `login`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->added_by, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->added_by->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->added_by->ViewValue = $this->added_by->CurrentValue;
				}
			} else {
				$this->added_by->ViewValue = NULL;
			}
			$this->added_by->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// lang_filter
			$this->lang_filter->LinkCustomAttributes = "";
			$this->lang_filter->HrefValue = "";
			$this->lang_filter->TooltipValue = "";

			// news_type_id
			$this->news_type_id->LinkCustomAttributes = "";
			$this->news_type_id->HrefValue = "";
			$this->news_type_id->TooltipValue = "";

			// is_imp
			$this->is_imp->LinkCustomAttributes = "";
			$this->is_imp->HrefValue = "";
			$this->is_imp->TooltipValue = "";

			// title
			$this->title->LinkCustomAttributes = "";
			$this->title->HrefValue = "";
			$this->title->TooltipValue = "";

			// title_ar
			$this->title_ar->LinkCustomAttributes = "";
			$this->title_ar->HrefValue = "";
			$this->title_ar->TooltipValue = "";

			// news_date
			$this->news_date->LinkCustomAttributes = "";
			$this->news_date->HrefValue = "";
			$this->news_date->TooltipValue = "";

			// added_by
			$this->added_by->LinkCustomAttributes = "";
			$this->added_by->HrefValue = "";
			$this->added_by->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	//
	// Delete records based on current filter
	//
	function DeleteRows() {
		global $conn, $Language, $Security;
		$DeleteRows = TRUE;
		$sSql = $this->SQL();
		$conn->raiseErrorFn = 'ew_ErrorFn';
		$rs = $conn->Execute($sSql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE) {
			return FALSE;
		} elseif ($rs->EOF) {
			$this->setFailureMessage($Language->Phrase("NoRecord")); // No record found
			$rs->Close();
			return FALSE;

		//} else {
		//	$this->LoadRowValues($rs); // Load row values

		}
		$conn->BeginTrans();

		// Clone old rows
		$rsold = ($rs) ? $rs->GetRows() : array();
		if ($rs)
			$rs->Close();

		// Call row deleting event
		if ($DeleteRows) {
			foreach ($rsold as $row) {
				$DeleteRows = $this->Row_Deleting($row);
				if (!$DeleteRows) break;
			}
		}
		if ($DeleteRows) {
			$sKey = "";
			foreach ($rsold as $row) {
				$sThisKey = "";
				if ($sThisKey <> "") $sThisKey .= $GLOBALS["EW_COMPOSITE_KEY_SEPARATOR"];
				$sThisKey .= $row['id'];
				$conn->raiseErrorFn = 'ew_ErrorFn';
				$DeleteRows = $this->Delete($row); // Delete
				$conn->raiseErrorFn = '';
				if ($DeleteRows === FALSE)
					break;
				if ($sKey <> "") $sKey .= ", ";
				$sKey .= $sThisKey;
			}
		} else {

			// Set up error message
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->Phrase("DeleteCancelled"));
			}
		}
		if ($DeleteRows) {
			$conn->CommitTrans(); // Commit the changes
		} else {
			$conn->RollbackTrans(); // Rollback changes
		}

		// Call Row Deleted event
		if ($DeleteRows) {
			foreach ($rsold as $row) {
				$this->Row_Deleted($row);
			}
		}
		return $DeleteRows;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$PageCaption = $this->TableCaption();
		$Breadcrumb->Add("list", "<span id=\"ewPageCaption\">" . $PageCaption . "</span>", "newslist.php", $this->TableVar);
		$PageCaption = $Language->Phrase("delete");
		$Breadcrumb->Add("delete", "<span id=\"ewPageCaption\">" . $PageCaption . "</span>", ew_CurrentUrl(), $this->TableVar);
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($news_delete)) $news_delete = new cnews_delete();

// Page init
$news_delete->Page_Init();

// Page main
$news_delete->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$news_delete->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Page object
var news_delete = new ew_Page("news_delete");
news_delete.PageID = "delete"; // Page ID
var EW_PAGE_ID = news_delete.PageID; // For backward compatibility

// Form object
var fnewsdelete = new ew_Form("fnewsdelete");

// Form_CustomValidate event
fnewsdelete.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fnewsdelete.ValidateRequired = true;
<?php } else { ?>
fnewsdelete.ValidateRequired = false; 
<?php } ?>

// Dynamic selection lists
fnewsdelete.Lists["x_news_type_id"] = {"LinkField":"x_id","Ajax":null,"AutoFill":false,"DisplayFields":["x_name","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnewsdelete.Lists["x_added_by"] = {"LinkField":"x_login_id","Ajax":null,"AutoFill":false,"DisplayFields":["x_login_name","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};

// Form object for search
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php

// Load records for display
if ($news_delete->Recordset = $news_delete->LoadRecordset())
	$news_deleteTotalRecs = $news_delete->Recordset->RecordCount(); // Get record count
if ($news_deleteTotalRecs <= 0) { // No record found, exit
	if ($news_delete->Recordset)
		$news_delete->Recordset->Close();
	$news_delete->Page_Terminate("newslist.php"); // Return to list
}
?>
<?php $Breadcrumb->Render(); ?>
<?php $news_delete->ShowPageHeader(); ?>
<?php
$news_delete->ShowMessage();
?>
<form name="fnewsdelete" id="fnewsdelete" class="ewForm form-horizontal" action="<?php echo ew_CurrentPage() ?>" method="post">
<input type="hidden" name="t" value="news">
<input type="hidden" name="a_delete" id="a_delete" value="D">
<?php foreach ($news_delete->RecKeys as $key) { ?>
<?php $keyvalue = is_array($key) ? implode($EW_COMPOSITE_KEY_SEPARATOR, $key) : $key; ?>
<input type="hidden" name="key_m[]" value="<?php echo ew_HtmlEncode($keyvalue) ?>">
<?php } ?>
<table cellspacing="0" class="ewGrid"><tr><td class="ewGridContent">
<div class="ewGridMiddlePanel">
<table id="tbl_newsdelete" class="ewTable ewTableSeparate">
<?php echo $news->TableCustomInnerHtml ?>
	<thead>
	<tr class="ewTableHeader">
<?php if ($news->id->Visible) { // id ?>
		<td><span id="elh_news_id" class="news_id"><?php echo $news->id->FldCaption() ?></span></td>
<?php } ?>
<?php if ($news->lang_filter->Visible) { // lang_filter ?>
		<td><span id="elh_news_lang_filter" class="news_lang_filter"><?php echo $news->lang_filter->FldCaption() ?></span></td>
<?php } ?>
<?php if ($news->news_type_id->Visible) { // news_type_id ?>
		<td><span id="elh_news_news_type_id" class="news_news_type_id"><?php echo $news->news_type_id->FldCaption() ?></span></td>
<?php } ?>
<?php if ($news->is_imp->Visible) { // is_imp ?>
		<td><span id="elh_news_is_imp" class="news_is_imp"><?php echo $news->is_imp->FldCaption() ?></span></td>
<?php } ?>
<?php if ($news->title->Visible) { // title ?>
		<td><span id="elh_news_title" class="news_title"><?php echo $news->title->FldCaption() ?></span></td>
<?php } ?>
<?php if ($news->title_ar->Visible) { // title_ar ?>
		<td><span id="elh_news_title_ar" class="news_title_ar"><?php echo $news->title_ar->FldCaption() ?></span></td>
<?php } ?>
<?php if ($news->news_date->Visible) { // news_date ?>
		<td><span id="elh_news_news_date" class="news_news_date"><?php echo $news->news_date->FldCaption() ?></span></td>
<?php } ?>
<?php if ($news->added_by->Visible) { // added_by ?>
		<td><span id="elh_news_added_by" class="news_added_by"><?php echo $news->added_by->FldCaption() ?></span></td>
<?php } ?>
	</tr>
	</thead>
	<tbody>
<?php
$news_delete->RecCnt = 0;
$i = 0;
while (!$news_delete->Recordset->EOF) {
	$news_delete->RecCnt++;
	$news_delete->RowCnt++;

	// Set row properties
	$news->ResetAttrs();
	$news->RowType = EW_ROWTYPE_VIEW; // View

	// Get the field contents
	$news_delete->LoadRowValues($news_delete->Recordset);

	// Render row
	$news_delete->RenderRow();
?>
	<tr<?php echo $news->RowAttributes() ?>>
<?php if ($news->id->Visible) { // id ?>
		<td<?php echo $news->id->CellAttributes() ?>>
<span id="el<?php echo $news_delete->RowCnt ?>_news_id" class="control-group news_id">
<span<?php echo $news->id->ViewAttributes() ?>>
<?php echo $news->id->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($news->lang_filter->Visible) { // lang_filter ?>
		<td<?php echo $news->lang_filter->CellAttributes() ?>>
<span id="el<?php echo $news_delete->RowCnt ?>_news_lang_filter" class="control-group news_lang_filter">
<span<?php echo $news->lang_filter->ViewAttributes() ?>>
<?php echo $news->lang_filter->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($news->news_type_id->Visible) { // news_type_id ?>
		<td<?php echo $news->news_type_id->CellAttributes() ?>>
<span id="el<?php echo $news_delete->RowCnt ?>_news_news_type_id" class="control-group news_news_type_id">
<span<?php echo $news->news_type_id->ViewAttributes() ?>>
<?php echo $news->news_type_id->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($news->is_imp->Visible) { // is_imp ?>
		<td<?php echo $news->is_imp->CellAttributes() ?>>
<span id="el<?php echo $news_delete->RowCnt ?>_news_is_imp" class="control-group news_is_imp">
<span<?php echo $news->is_imp->ViewAttributes() ?>>
<?php echo $news->is_imp->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($news->title->Visible) { // title ?>
		<td<?php echo $news->title->CellAttributes() ?>>
<span id="el<?php echo $news_delete->RowCnt ?>_news_title" class="control-group news_title">
<span<?php echo $news->title->ViewAttributes() ?>>
<?php echo $news->title->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($news->title_ar->Visible) { // title_ar ?>
		<td<?php echo $news->title_ar->CellAttributes() ?>>
<span id="el<?php echo $news_delete->RowCnt ?>_news_title_ar" class="control-group news_title_ar">
<span<?php echo $news->title_ar->ViewAttributes() ?>>
<?php echo $news->title_ar->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($news->news_date->Visible) { // news_date ?>
		<td<?php echo $news->news_date->CellAttributes() ?>>
<span id="el<?php echo $news_delete->RowCnt ?>_news_news_date" class="control-group news_news_date">
<span<?php echo $news->news_date->ViewAttributes() ?>>
<?php echo $news->news_date->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
<?php if ($news->added_by->Visible) { // added_by ?>
		<td<?php echo $news->added_by->CellAttributes() ?>>
<span id="el<?php echo $news_delete->RowCnt ?>_news_added_by" class="control-group news_added_by">
<span<?php echo $news->added_by->ViewAttributes() ?>>
<?php echo $news->added_by->ListViewValue() ?></span>
</span>
</td>
<?php } ?>
	</tr>
<?php
	$news_delete->Recordset->MoveNext();
}
$news_delete->Recordset->Close();
?>
</tbody>
</table>
</div>
</td></tr></table>
<div class="btn-group ewButtonGroup">
<button class="btn btn-primary ewButton" name="btnAction" id="btnAction" type="submit"><?php echo $Language->Phrase("DeleteBtn") ?></button>
</div>
</form>
<script type="text/javascript">
fnewsdelete.Init();
</script>
<?php
$news_delete->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$news_delete->Page_Terminate();
?>
