<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg10.php" ?>
<?php include_once "ewmysql10.php" ?>
<?php include_once "phpfn10.php" ?>
<?php include_once "newsinfo.php" ?>
<?php include_once "_logininfo.php" ?>
<?php include_once "news_typeinfo.php" ?>
<?php include_once "news_picturesgridcls.php" ?>
<?php include_once "userfn10.php" ?>
<?php

//
// Page class
//

$news_view = NULL; // Initialize page object first

class cnews_view extends cnews {

	// Page ID
	var $PageID = 'view';

	// Project ID
	var $ProjectID = "{F555B504-0784-474D-925D-CB2D041B48DF}";

	// Table name
	var $TableName = 'news';

	// Page object name
	var $PageObjName = 'news_view';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Page URLs
	var $AddUrl;
	var $EditUrl;
	var $CopyUrl;
	var $DeleteUrl;
	var $ViewUrl;
	var $ListUrl;

	// Export URLs
	var $ExportPrintUrl;
	var $ExportHtmlUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportXmlUrl;
	var $ExportCsvUrl;
	var $ExportPdfUrl;

	// Update URLs
	var $InlineAddUrl;
	var $InlineCopyUrl;
	var $InlineEditUrl;
	var $GridAddUrl;
	var $GridEditUrl;
	var $MultiDeleteUrl;
	var $MultiUpdateUrl;

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-error ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<table class=\"ewStdTable\"><tr><td><div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div></td></tr></table>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language, $UserAgent;

		// User agent
		$UserAgent = ew_UserAgent();
		$GLOBALS["Page"] = &$this;

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (news)
		if (!isset($GLOBALS["news"])) {
			$GLOBALS["news"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["news"];
		}
		$KeyUrl = "";
		if (@$_GET["id"] <> "") {
			$this->RecKey["id"] = $_GET["id"];
			$KeyUrl .= "&id=" . urlencode($this->RecKey["id"]);
		}
		$this->ExportPrintUrl = $this->PageUrl() . "export=print" . $KeyUrl;
		$this->ExportHtmlUrl = $this->PageUrl() . "export=html" . $KeyUrl;
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel" . $KeyUrl;
		$this->ExportWordUrl = $this->PageUrl() . "export=word" . $KeyUrl;
		$this->ExportXmlUrl = $this->PageUrl() . "export=xml" . $KeyUrl;
		$this->ExportCsvUrl = $this->PageUrl() . "export=csv" . $KeyUrl;
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf" . $KeyUrl;

		// Table object (_login)
		if (!isset($GLOBALS['_login'])) $GLOBALS['_login'] = new c_login();

		// Table object (news_type)
		if (!isset($GLOBALS['news_type'])) $GLOBALS['news_type'] = new cnews_type();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'view', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'news', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect();

		// Export options
		$this->ExportOptions = new cListOptions();
		$this->ExportOptions->Tag = "span";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Other options
		$this->OtherOptions['action'] = new cListOptions();
		$this->OtherOptions['action']->Tag = "span";
		$this->OtherOptions['action']->TagClassName = "ewActionOption";
		$this->OtherOptions['detail'] = new cListOptions();
		$this->OtherOptions['detail']->Tag = "span";
		$this->OtherOptions['detail']->TagClassName = "ewDetailOption";
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login.php");
		}
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up curent action
		$this->id->Visible = !$this->IsAdd() && !$this->IsCopy() && !$this->IsGridAdd();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $conn;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();
		$this->Page_Redirecting($url);

		 // Close connection
		$conn->Close();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}
	var $ExportOptions; // Export options
	var $OtherOptions = array(); // Other options
	var $DisplayRecs = 1;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $Pager;
	var $RecCnt;
	var $RecKey = array();
	var $Recordset;

	//
	// Page main
	//
	function Page_Main() {
		global $Language;

		// Load current record
		$bLoadCurrentRecord = FALSE;
		$sReturnUrl = "";
		$bMatchRecord = FALSE;

		// Set up Breadcrumb
		$this->SetupBreadcrumb();
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET["id"] <> "") {
				$this->id->setQueryStringValue($_GET["id"]);
				$this->RecKey["id"] = $this->id->QueryStringValue;
			} else {
				$bLoadCurrentRecord = TRUE;
			}

			// Get action
			$this->CurrentAction = "I"; // Display form
			switch ($this->CurrentAction) {
				case "I": // Get a record to display
					$this->StartRec = 1; // Initialize start position
					if ($this->Recordset = $this->LoadRecordset()) // Load records
						$this->TotalRecs = $this->Recordset->RecordCount(); // Get record count
					if ($this->TotalRecs <= 0) { // No record found
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->Phrase("NoRecord")); // Set no record message
						$this->Page_Terminate("newslist.php"); // Return to list page
					} elseif ($bLoadCurrentRecord) { // Load current record position
						$this->SetUpStartRec(); // Set up start record position

						// Point to current record
						if (intval($this->StartRec) <= intval($this->TotalRecs)) {
							$bMatchRecord = TRUE;
							$this->Recordset->Move($this->StartRec-1);
						}
					} else { // Match key values
						while (!$this->Recordset->EOF) {
							if (strval($this->id->CurrentValue) == strval($this->Recordset->fields('id'))) {
								$this->setStartRecordNumber($this->StartRec); // Save record position
								$bMatchRecord = TRUE;
								break;
							} else {
								$this->StartRec++;
								$this->Recordset->MoveNext();
							}
						}
					}
					if (!$bMatchRecord) {
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->Phrase("NoRecord")); // Set no record message
						$sReturnUrl = "newslist.php"; // No matching record, return to list
					} else {
						$this->LoadRowValues($this->Recordset); // Load row values
					}
			}
		} else {
			$sReturnUrl = "newslist.php"; // Not page request, return to list
		}
		if ($sReturnUrl <> "")
			$this->Page_Terminate($sReturnUrl);

		// Render row
		$this->RowType = EW_ROWTYPE_VIEW;
		$this->ResetAttrs();
		$this->RenderRow();

		// Set up detail parameters
		$this->SetUpDetailParms();
	}

	// Set up other options
	function SetupOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = &$options["action"];

		// Add
		$item = &$option->Add("add");
		$item->Body = "<a class=\"ewAction ewAdd\" href=\"" . ew_HtmlEncode($this->AddUrl) . "\">" . $Language->Phrase("ViewPageAddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->IsLoggedIn());

		// Edit
		$item = &$option->Add("edit");
		$item->Body = "<a class=\"ewAction ewEdit\" href=\"" . ew_HtmlEncode($this->EditUrl) . "\">" . $Language->Phrase("ViewPageEditLink") . "</a>";
		$item->Visible = ($this->EditUrl <> "" && $Security->IsLoggedIn());

		// Delete
		$item = &$option->Add("delete");
		$item->Body = "<a class=\"ewAction ewDelete\" href=\"" . ew_HtmlEncode($this->DeleteUrl) . "\">" . $Language->Phrase("ViewPageDeleteLink") . "</a>";
		$item->Visible = ($this->DeleteUrl <> "" && $Security->IsLoggedIn());
		$DetailTableLink = "";
		$option = &$options["detail"];

		// Detail table 'news_pictures'
		$body = $Language->TablePhrase("news_pictures", "TblCaption");
		$body = "<a class=\"ewAction ewDetailList\" href=\"" . ew_HtmlEncode("news_pictureslist.php?" . EW_TABLE_SHOW_MASTER . "=news&id=" . strval($this->id->CurrentValue) . "") . "\">" . $body . "</a>";
		$item = &$option->Add("detail_news_pictures");
		$item->Body = $body;
		$item->Visible = $Security->IsLoggedIn();
		if ($item->Visible) {
			if ($DetailTableLink <> "") $DetailTableLink .= ",";
			$DetailTableLink .= "news_pictures";
		}

		// Multiple details
		if ($this->ShowMultipleDetails) {
			$body = $Language->Phrase("MultipleMasterDetails");
			$body = "<a class=\"ewAction ewDetailView\" data-action=\"view\" href=\"" . ew_HtmlEncode($this->GetViewUrl(EW_TABLE_SHOW_DETAIL . "=" . $DetailTableLink)) . "\">" . $body . "</a>";
			$item = &$option->Add("details");
			$item->Body = $body;
			$item->Visible = ($DetailTableLink <> "");

			// Hide single master/detail items
			$ar = explode(",", $DetailTableLink);
			$cnt = count($ar);
			for ($i = 0; $i < $cnt; $i++) {
				if ($item = &$option->GetItem("detail_" . $ar[$i]))
					$item->Visible = FALSE;
			}
		}

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;
			$item = &$option->Add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["detail"]->DropDownButtonPhrase = $Language->Phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->Phrase("ButtonActions");
	}

	// Set up starting record parameters
	function SetUpStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {
		global $conn;

		// Call Recordset Selecting event
		$this->Recordset_Selecting($this->CurrentFilter);

		// Load List page SQL
		$sSql = $this->SelectSQL();
		if ($offset > -1 && $rowcnt > -1)
			$sSql .= " LIMIT $rowcnt OFFSET $offset";

		// Load recordset
		$rs = ew_LoadRecordset($sSql);

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $conn, $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		global $conn;
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->id->setDbValue($rs->fields('id'));
		$this->lang_filter->setDbValue($rs->fields('lang_filter'));
		$this->news_type_id->setDbValue($rs->fields('news_type_id'));
		$this->is_imp->setDbValue($rs->fields('is_imp'));
		$this->external_link->setDbValue($rs->fields('external_link'));
		$this->title->setDbValue($rs->fields('title'));
		$this->title_ar->setDbValue($rs->fields('title_ar'));
		$this->thumb->Upload->DbValue = $rs->fields('thumb');
		$this->pdf->Upload->DbValue = $rs->fields('pdf');
		$this->news_date->setDbValue($rs->fields('news_date'));
		$this->description->setDbValue($rs->fields('description'));
		$this->description_ar->setDbValue($rs->fields('description_ar'));
		$this->added_by->setDbValue($rs->fields('added_by'));
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->lang_filter->DbValue = $row['lang_filter'];
		$this->news_type_id->DbValue = $row['news_type_id'];
		$this->is_imp->DbValue = $row['is_imp'];
		$this->external_link->DbValue = $row['external_link'];
		$this->title->DbValue = $row['title'];
		$this->title_ar->DbValue = $row['title_ar'];
		$this->thumb->Upload->DbValue = $row['thumb'];
		$this->pdf->Upload->DbValue = $row['pdf'];
		$this->news_date->DbValue = $row['news_date'];
		$this->description->DbValue = $row['description'];
		$this->description_ar->DbValue = $row['description_ar'];
		$this->added_by->DbValue = $row['added_by'];
	}

	// Render row values based on field settings
	function RenderRow() {
		global $conn, $Security, $Language;
		global $gsLanguage;

		// Initialize URLs
		$this->AddUrl = $this->GetAddUrl();
		$this->EditUrl = $this->GetEditUrl();
		$this->CopyUrl = $this->GetCopyUrl();
		$this->DeleteUrl = $this->GetDeleteUrl();
		$this->ListUrl = $this->GetListUrl();
		$this->SetupOtherOptions();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// lang_filter
		// news_type_id
		// is_imp
		// external_link
		// title
		// title_ar
		// thumb
		// pdf
		// news_date
		// description
		// description_ar
		// added_by

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// lang_filter
			if (strval($this->lang_filter->CurrentValue) <> "") {
				switch ($this->lang_filter->CurrentValue) {
					case $this->lang_filter->FldTagValue(1):
						$this->lang_filter->ViewValue = $this->lang_filter->FldTagCaption(1) <> "" ? $this->lang_filter->FldTagCaption(1) : $this->lang_filter->CurrentValue;
						break;
					case $this->lang_filter->FldTagValue(2):
						$this->lang_filter->ViewValue = $this->lang_filter->FldTagCaption(2) <> "" ? $this->lang_filter->FldTagCaption(2) : $this->lang_filter->CurrentValue;
						break;
					case $this->lang_filter->FldTagValue(3):
						$this->lang_filter->ViewValue = $this->lang_filter->FldTagCaption(3) <> "" ? $this->lang_filter->FldTagCaption(3) : $this->lang_filter->CurrentValue;
						break;
					default:
						$this->lang_filter->ViewValue = $this->lang_filter->CurrentValue;
				}
			} else {
				$this->lang_filter->ViewValue = NULL;
			}
			$this->lang_filter->ViewCustomAttributes = "";

			// news_type_id
			if (strval($this->news_type_id->CurrentValue) <> "") {
				$sFilterWrk = "`id`" . ew_SearchString("=", $this->news_type_id->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `id`, `name` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `news_type`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->news_type_id, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->news_type_id->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->news_type_id->ViewValue = $this->news_type_id->CurrentValue;
				}
			} else {
				$this->news_type_id->ViewValue = NULL;
			}
			$this->news_type_id->ViewCustomAttributes = "";

			// is_imp
			if (strval($this->is_imp->CurrentValue) <> "") {
				switch ($this->is_imp->CurrentValue) {
					case $this->is_imp->FldTagValue(1):
						$this->is_imp->ViewValue = $this->is_imp->FldTagCaption(1) <> "" ? $this->is_imp->FldTagCaption(1) : $this->is_imp->CurrentValue;
						break;
					case $this->is_imp->FldTagValue(2):
						$this->is_imp->ViewValue = $this->is_imp->FldTagCaption(2) <> "" ? $this->is_imp->FldTagCaption(2) : $this->is_imp->CurrentValue;
						break;
					default:
						$this->is_imp->ViewValue = $this->is_imp->CurrentValue;
				}
			} else {
				$this->is_imp->ViewValue = NULL;
			}
			$this->is_imp->ViewCustomAttributes = "";

			// external_link
			$this->external_link->ViewValue = $this->external_link->CurrentValue;
			$this->external_link->ViewCustomAttributes = "";

			// title
			$this->title->ViewValue = $this->title->CurrentValue;
			$this->title->ViewCustomAttributes = "";

			// title_ar
			$this->title_ar->ViewValue = $this->title_ar->CurrentValue;
			$this->title_ar->ViewCustomAttributes = "";

			// thumb
			$this->thumb->UploadPath = "../uploads/news/thumb";
			if (!ew_Empty($this->thumb->Upload->DbValue)) {
				$this->thumb->ImageAlt = $this->thumb->FldAlt();
				$this->thumb->ViewValue = ew_UploadPathEx(FALSE, $this->thumb->UploadPath) . $this->thumb->Upload->DbValue;
			} else {
				$this->thumb->ViewValue = "";
			}
			$this->thumb->ViewCustomAttributes = "";

			// pdf
			$this->pdf->UploadPath = "../uploads/news/pdf";
			if (!ew_Empty($this->pdf->Upload->DbValue)) {
				$this->pdf->ViewValue = $this->pdf->Upload->DbValue;
			} else {
				$this->pdf->ViewValue = "";
			}
			$this->pdf->ViewCustomAttributes = "";

			// news_date
			$this->news_date->ViewValue = $this->news_date->CurrentValue;
			$this->news_date->ViewValue = ew_FormatDateTime($this->news_date->ViewValue, 7);
			$this->news_date->ViewCustomAttributes = "";

			// description
			$this->description->ViewValue = $this->description->CurrentValue;
			$this->description->ViewCustomAttributes = "";

			// description_ar
			$this->description_ar->ViewValue = $this->description_ar->CurrentValue;
			$this->description_ar->ViewCustomAttributes = "";

			// added_by
			if (strval($this->added_by->CurrentValue) <> "") {
				$sFilterWrk = "`login_id`" . ew_SearchString("=", $this->added_by->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `login_id`, `login_name` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `login`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->added_by, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->added_by->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->added_by->ViewValue = $this->added_by->CurrentValue;
				}
			} else {
				$this->added_by->ViewValue = NULL;
			}
			$this->added_by->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// lang_filter
			$this->lang_filter->LinkCustomAttributes = "";
			$this->lang_filter->HrefValue = "";
			$this->lang_filter->TooltipValue = "";

			// news_type_id
			$this->news_type_id->LinkCustomAttributes = "";
			$this->news_type_id->HrefValue = "";
			$this->news_type_id->TooltipValue = "";

			// is_imp
			$this->is_imp->LinkCustomAttributes = "";
			$this->is_imp->HrefValue = "";
			$this->is_imp->TooltipValue = "";

			// external_link
			$this->external_link->LinkCustomAttributes = "";
			$this->external_link->HrefValue = "";
			$this->external_link->TooltipValue = "";

			// title
			$this->title->LinkCustomAttributes = "";
			$this->title->HrefValue = "";
			$this->title->TooltipValue = "";

			// title_ar
			$this->title_ar->LinkCustomAttributes = "";
			$this->title_ar->HrefValue = "";
			$this->title_ar->TooltipValue = "";

			// thumb
			$this->thumb->LinkCustomAttributes = "";
			$this->thumb->HrefValue = "";
			$this->thumb->HrefValue2 = $this->thumb->UploadPath . $this->thumb->Upload->DbValue;
			$this->thumb->TooltipValue = "";

			// pdf
			$this->pdf->LinkCustomAttributes = "";
			$this->pdf->HrefValue = "";
			$this->pdf->HrefValue2 = $this->pdf->UploadPath . $this->pdf->Upload->DbValue;
			$this->pdf->TooltipValue = "";

			// news_date
			$this->news_date->LinkCustomAttributes = "";
			$this->news_date->HrefValue = "";
			$this->news_date->TooltipValue = "";

			// description
			$this->description->LinkCustomAttributes = "";
			$this->description->HrefValue = "";
			$this->description->TooltipValue = "";

			// description_ar
			$this->description_ar->LinkCustomAttributes = "";
			$this->description_ar->HrefValue = "";
			$this->description_ar->TooltipValue = "";

			// added_by
			$this->added_by->LinkCustomAttributes = "";
			$this->added_by->HrefValue = "";
			$this->added_by->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up detail parms based on QueryString
	function SetUpDetailParms() {

		// Get the keys for master table
		if (isset($_GET[EW_TABLE_SHOW_DETAIL])) {
			$sDetailTblVar = $_GET[EW_TABLE_SHOW_DETAIL];
			$this->setCurrentDetailTable($sDetailTblVar);
		} else {
			$sDetailTblVar = $this->getCurrentDetailTable();
		}
		if ($sDetailTblVar <> "") {
			$DetailTblVar = explode(",", $sDetailTblVar);
			if (in_array("news_pictures", $DetailTblVar)) {
				if (!isset($GLOBALS["news_pictures_grid"]))
					$GLOBALS["news_pictures_grid"] = new cnews_pictures_grid;
				if ($GLOBALS["news_pictures_grid"]->DetailView) {
					$GLOBALS["news_pictures_grid"]->CurrentMode = "view";

					// Save current master table to detail table
					$GLOBALS["news_pictures_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["news_pictures_grid"]->setStartRecordNumber(1);
					$GLOBALS["news_pictures_grid"]->news_id->FldIsDetailKey = TRUE;
					$GLOBALS["news_pictures_grid"]->news_id->CurrentValue = $this->id->CurrentValue;
					$GLOBALS["news_pictures_grid"]->news_id->setSessionValue($GLOBALS["news_pictures_grid"]->news_id->CurrentValue);
				}
			}
		}
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$PageCaption = $this->TableCaption();
		$Breadcrumb->Add("list", "<span id=\"ewPageCaption\">" . $PageCaption . "</span>", "newslist.php", $this->TableVar);
		$PageCaption = $Language->Phrase("view");
		$Breadcrumb->Add("view", "<span id=\"ewPageCaption\">" . $PageCaption . "</span>", ew_CurrentUrl(), $this->TableVar);
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($news_view)) $news_view = new cnews_view();

// Page init
$news_view->Page_Init();

// Page main
$news_view->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$news_view->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Page object
var news_view = new ew_Page("news_view");
news_view.PageID = "view"; // Page ID
var EW_PAGE_ID = news_view.PageID; // For backward compatibility

// Form object
var fnewsview = new ew_Form("fnewsview");

// Form_CustomValidate event
fnewsview.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fnewsview.ValidateRequired = true;
<?php } else { ?>
fnewsview.ValidateRequired = false; 
<?php } ?>

// Dynamic selection lists
fnewsview.Lists["x_news_type_id"] = {"LinkField":"x_id","Ajax":null,"AutoFill":false,"DisplayFields":["x_name","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};
fnewsview.Lists["x_added_by"] = {"LinkField":"x_login_id","Ajax":null,"AutoFill":false,"DisplayFields":["x_login_name","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};

// Form object for search
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php $Breadcrumb->Render(); ?>
<div class="ewViewExportOptions">
<?php $news_view->ExportOptions->Render("body") ?>
<?php if (!$news_view->ExportOptions->UseDropDownButton) { ?>
</div>
<div class="ewViewOtherOptions">
<?php } ?>
<?php
	foreach ($news_view->OtherOptions as &$option)
		$option->Render("body");
?>
</div>
<?php $news_view->ShowPageHeader(); ?>
<?php
$news_view->ShowMessage();
?>
<form name="ewPagerForm" class="ewForm form-horizontal" action="<?php echo ew_CurrentPage() ?>">
<table class="ewPager">
<tr><td>
<?php if (!isset($news_view->Pager)) $news_view->Pager = new cPrevNextPager($news_view->StartRec, $news_view->DisplayRecs, $news_view->TotalRecs) ?>
<?php if ($news_view->Pager->RecordCount > 0) { ?>
<table cellspacing="0" class="ewStdTable"><tbody><tr><td>
	<?php echo $Language->Phrase("Page") ?>&nbsp;
<div class="input-prepend input-append">
<!--first page button-->
	<?php if ($news_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-small" type="button" href="<?php echo $news_view->PageUrl() ?>start=<?php echo $news_view->Pager->FirstButton->Start ?>"><i class="icon-step-backward"></i></a>
	<?php } else { ?>
	<a class="btn btn-small" type="button" disabled="disabled"><i class="icon-step-backward"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($news_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-small" type="button" href="<?php echo $news_view->PageUrl() ?>start=<?php echo $news_view->Pager->PrevButton->Start ?>"><i class="icon-prev"></i></a>
	<?php } else { ?>
	<a class="btn btn-small" type="button" disabled="disabled"><i class="icon-prev"></i></a>
	<?php } ?>
<!--current page number-->
	<input class="input-mini" type="text" name="<?php echo EW_TABLE_PAGE_NO ?>" value="<?php echo $news_view->Pager->CurrentPage ?>">
<!--next page button-->
	<?php if ($news_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-small" type="button" href="<?php echo $news_view->PageUrl() ?>start=<?php echo $news_view->Pager->NextButton->Start ?>"><i class="icon-play"></i></a>
	<?php } else { ?>
	<a class="btn btn-small" type="button" disabled="disabled"><i class="icon-play"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($news_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-small" type="button" href="<?php echo $news_view->PageUrl() ?>start=<?php echo $news_view->Pager->LastButton->Start ?>"><i class="icon-step-forward"></i></a>
	<?php } else { ?>
	<a class="btn btn-small" type="button" disabled="disabled"><i class="icon-step-forward"></i></a>
	<?php } ?>
</div>
	&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $news_view->Pager->PageCount ?>
</td>
</tr></tbody></table>
<?php } else { ?>
	<p><?php echo $Language->Phrase("NoRecord") ?></p>
<?php } ?>
</td>
</tr></table>
</form>
<form name="fnewsview" id="fnewsview" class="ewForm form-horizontal" action="<?php echo ew_CurrentPage() ?>" method="post">
<input type="hidden" name="t" value="news">
<table cellspacing="0" class="ewGrid"><tr><td>
<table id="tbl_newsview" class="table table-bordered table-striped">
<?php if ($news->id->Visible) { // id ?>
	<tr id="r_id">
		<td><span id="elh_news_id"><?php echo $news->id->FldCaption() ?></span></td>
		<td<?php echo $news->id->CellAttributes() ?>>
<span id="el_news_id" class="control-group">
<span<?php echo $news->id->ViewAttributes() ?>>
<?php echo $news->id->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($news->lang_filter->Visible) { // lang_filter ?>
	<tr id="r_lang_filter">
		<td><span id="elh_news_lang_filter"><?php echo $news->lang_filter->FldCaption() ?></span></td>
		<td<?php echo $news->lang_filter->CellAttributes() ?>>
<span id="el_news_lang_filter" class="control-group">
<span<?php echo $news->lang_filter->ViewAttributes() ?>>
<?php echo $news->lang_filter->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($news->news_type_id->Visible) { // news_type_id ?>
	<tr id="r_news_type_id">
		<td><span id="elh_news_news_type_id"><?php echo $news->news_type_id->FldCaption() ?></span></td>
		<td<?php echo $news->news_type_id->CellAttributes() ?>>
<span id="el_news_news_type_id" class="control-group">
<span<?php echo $news->news_type_id->ViewAttributes() ?>>
<?php echo $news->news_type_id->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($news->is_imp->Visible) { // is_imp ?>
	<tr id="r_is_imp">
		<td><span id="elh_news_is_imp"><?php echo $news->is_imp->FldCaption() ?></span></td>
		<td<?php echo $news->is_imp->CellAttributes() ?>>
<span id="el_news_is_imp" class="control-group">
<span<?php echo $news->is_imp->ViewAttributes() ?>>
<?php echo $news->is_imp->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($news->external_link->Visible) { // external_link ?>
	<tr id="r_external_link">
		<td><span id="elh_news_external_link"><?php echo $news->external_link->FldCaption() ?></span></td>
		<td<?php echo $news->external_link->CellAttributes() ?>>
<span id="el_news_external_link" class="control-group">
<span<?php echo $news->external_link->ViewAttributes() ?>>
<?php echo $news->external_link->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($news->title->Visible) { // title ?>
	<tr id="r_title">
		<td><span id="elh_news_title"><?php echo $news->title->FldCaption() ?></span></td>
		<td<?php echo $news->title->CellAttributes() ?>>
<span id="el_news_title" class="control-group">
<span<?php echo $news->title->ViewAttributes() ?>>
<?php echo $news->title->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($news->title_ar->Visible) { // title_ar ?>
	<tr id="r_title_ar">
		<td><span id="elh_news_title_ar"><?php echo $news->title_ar->FldCaption() ?></span></td>
		<td<?php echo $news->title_ar->CellAttributes() ?>>
<span id="el_news_title_ar" class="control-group">
<span<?php echo $news->title_ar->ViewAttributes() ?>>
<?php echo $news->title_ar->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($news->thumb->Visible) { // thumb ?>
	<tr id="r_thumb">
		<td><span id="elh_news_thumb"><?php echo $news->thumb->FldCaption() ?></span></td>
		<td<?php echo $news->thumb->CellAttributes() ?>>
<span id="el_news_thumb" class="control-group">
<span>
<?php if ($news->thumb->LinkAttributes() <> "") { ?>
<?php if (!empty($news->thumb->Upload->DbValue)) { ?>
<img src="<?php echo $news->thumb->ViewValue ?>" alt="" style="border: 0;"<?php echo $news->thumb->ViewAttributes() ?>>
<?php } elseif (!in_array($news->CurrentAction, array("I", "edit", "gridedit"))) { ?>	
&nbsp;
<?php } ?>
<?php } else { ?>
<?php if (!empty($news->thumb->Upload->DbValue)) { ?>
<img src="<?php echo $news->thumb->ViewValue ?>" alt="" style="border: 0;"<?php echo $news->thumb->ViewAttributes() ?>>
<?php } elseif (!in_array($news->CurrentAction, array("I", "edit", "gridedit"))) { ?>	
&nbsp;
<?php } ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($news->pdf->Visible) { // pdf ?>
	<tr id="r_pdf">
		<td><span id="elh_news_pdf"><?php echo $news->pdf->FldCaption() ?></span></td>
		<td<?php echo $news->pdf->CellAttributes() ?>>
<span id="el_news_pdf" class="control-group">
<span<?php echo $news->pdf->ViewAttributes() ?>>
<?php if ($news->pdf->LinkAttributes() <> "") { ?>
<?php if (!empty($news->pdf->Upload->DbValue)) { ?>
<?php echo $news->pdf->ViewValue ?>
<?php } elseif (!in_array($news->CurrentAction, array("I", "edit", "gridedit"))) { ?>	
&nbsp;
<?php } ?>
<?php } else { ?>
<?php if (!empty($news->pdf->Upload->DbValue)) { ?>
<?php echo $news->pdf->ViewValue ?>
<?php } elseif (!in_array($news->CurrentAction, array("I", "edit", "gridedit"))) { ?>	
&nbsp;
<?php } ?>
<?php } ?>
</span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($news->news_date->Visible) { // news_date ?>
	<tr id="r_news_date">
		<td><span id="elh_news_news_date"><?php echo $news->news_date->FldCaption() ?></span></td>
		<td<?php echo $news->news_date->CellAttributes() ?>>
<span id="el_news_news_date" class="control-group">
<span<?php echo $news->news_date->ViewAttributes() ?>>
<?php echo $news->news_date->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($news->description->Visible) { // description ?>
	<tr id="r_description">
		<td><span id="elh_news_description"><?php echo $news->description->FldCaption() ?></span></td>
		<td<?php echo $news->description->CellAttributes() ?>>
<span id="el_news_description" class="control-group">
<span<?php echo $news->description->ViewAttributes() ?>>
<?php echo $news->description->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($news->description_ar->Visible) { // description_ar ?>
	<tr id="r_description_ar">
		<td><span id="elh_news_description_ar"><?php echo $news->description_ar->FldCaption() ?></span></td>
		<td<?php echo $news->description_ar->CellAttributes() ?>>
<span id="el_news_description_ar" class="control-group">
<span<?php echo $news->description_ar->ViewAttributes() ?>>
<?php echo $news->description_ar->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($news->added_by->Visible) { // added_by ?>
	<tr id="r_added_by">
		<td><span id="elh_news_added_by"><?php echo $news->added_by->FldCaption() ?></span></td>
		<td<?php echo $news->added_by->CellAttributes() ?>>
<span id="el_news_added_by" class="control-group">
<span<?php echo $news->added_by->ViewAttributes() ?>>
<?php echo $news->added_by->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</td></tr></table>
<table class="ewPager">
<tr><td>
<?php if (!isset($news_view->Pager)) $news_view->Pager = new cPrevNextPager($news_view->StartRec, $news_view->DisplayRecs, $news_view->TotalRecs) ?>
<?php if ($news_view->Pager->RecordCount > 0) { ?>
<table cellspacing="0" class="ewStdTable"><tbody><tr><td>
	<?php echo $Language->Phrase("Page") ?>&nbsp;
<div class="input-prepend input-append">
<!--first page button-->
	<?php if ($news_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-small" type="button" href="<?php echo $news_view->PageUrl() ?>start=<?php echo $news_view->Pager->FirstButton->Start ?>"><i class="icon-step-backward"></i></a>
	<?php } else { ?>
	<a class="btn btn-small" type="button" disabled="disabled"><i class="icon-step-backward"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($news_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-small" type="button" href="<?php echo $news_view->PageUrl() ?>start=<?php echo $news_view->Pager->PrevButton->Start ?>"><i class="icon-prev"></i></a>
	<?php } else { ?>
	<a class="btn btn-small" type="button" disabled="disabled"><i class="icon-prev"></i></a>
	<?php } ?>
<!--current page number-->
	<input class="input-mini" type="text" name="<?php echo EW_TABLE_PAGE_NO ?>" value="<?php echo $news_view->Pager->CurrentPage ?>">
<!--next page button-->
	<?php if ($news_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-small" type="button" href="<?php echo $news_view->PageUrl() ?>start=<?php echo $news_view->Pager->NextButton->Start ?>"><i class="icon-play"></i></a>
	<?php } else { ?>
	<a class="btn btn-small" type="button" disabled="disabled"><i class="icon-play"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($news_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-small" type="button" href="<?php echo $news_view->PageUrl() ?>start=<?php echo $news_view->Pager->LastButton->Start ?>"><i class="icon-step-forward"></i></a>
	<?php } else { ?>
	<a class="btn btn-small" type="button" disabled="disabled"><i class="icon-step-forward"></i></a>
	<?php } ?>
</div>
	&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $news_view->Pager->PageCount ?>
</td>
</tr></tbody></table>
<?php } else { ?>
	<p><?php echo $Language->Phrase("NoRecord") ?></p>
<?php } ?>
</td>
</tr></table>
<?php
	if (in_array("news_pictures", explode(",", $news->getCurrentDetailTable())) && $news_pictures->DetailView) {
?>
<?php include_once "news_picturesgrid.php" ?>
<?php } ?>
</form>
<script type="text/javascript">
fnewsview.Init();
</script>
<?php
$news_view->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$news_view->Page_Terminate();
?>
