<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg10.php" ?>
<?php include_once "ewmysql10.php" ?>
<?php include_once "phpfn10.php" ?>
<?php include_once "pages_datainfo.php" ?>
<?php include_once "_logininfo.php" ?>
<?php include_once "userfn10.php" ?>
<?php

//
// Page class
//

$pages_data_add = NULL; // Initialize page object first

class cpages_data_add extends cpages_data {

	// Page ID
	var $PageID = 'add';

	// Project ID
	var $ProjectID = "{F555B504-0784-474D-925D-CB2D041B48DF}";

	// Table name
	var $TableName = 'pages_data';

	// Page object name
	var $PageObjName = 'pages_data_add';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-error ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<table class=\"ewStdTable\"><tr><td><div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div></td></tr></table>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language, $UserAgent;

		// User agent
		$UserAgent = ew_UserAgent();
		$GLOBALS["Page"] = &$this;

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (pages_data)
		if (!isset($GLOBALS["pages_data"])) {
			$GLOBALS["pages_data"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["pages_data"];
		}

		// Table object (_login)
		if (!isset($GLOBALS['_login'])) $GLOBALS['_login'] = new c_login();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'add', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'pages_data', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect();
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login.php");
		}

		// Create form object
		$objForm = new cFormObj();
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up curent action

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $conn;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();
		$this->Page_Redirecting($url);

		 // Close connection
		$conn->Close();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}
	var $DbMasterFilter = "";
	var $DbDetailFilter = "";
	var $Priv = 0;
	var $OldRecordset;
	var $CopyRecord;

	// 
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError;

		// Process form if post back
		if (@$_POST["a_add"] <> "") {
			$this->CurrentAction = $_POST["a_add"]; // Get form action
			$this->CopyRecord = $this->LoadOldRecord(); // Load old recordset
			$this->LoadFormValues(); // Load form values
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (@$_GET["page_data_id"] != "") {
				$this->page_data_id->setQueryStringValue($_GET["page_data_id"]);
				$this->setKey("page_data_id", $this->page_data_id->CurrentValue); // Set up key
			} else {
				$this->setKey("page_data_id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "C"; // Copy record
			} else {
				$this->CurrentAction = "I"; // Display blank record
				$this->LoadDefaultValues(); // Load default values
			}
		}

		// Set up Breadcrumb
		$this->SetupBreadcrumb();

		// Validate form if post back
		if (@$_POST["a_add"] <> "") {
			if (!$this->ValidateForm()) {
				$this->CurrentAction = "I"; // Form error, reset action
				$this->EventCancelled = TRUE; // Event cancelled
				$this->RestoreFormValues(); // Restore form values
				$this->setFailureMessage($gsFormError);
			}
		}

		// Perform action based on action code
		switch ($this->CurrentAction) {
			case "I": // Blank record, no action required
				break;
			case "C": // Copy an existing record
				if (!$this->LoadRow()) { // Load record based on key
					if ($this->getFailureMessage() == "") $this->setFailureMessage($Language->Phrase("NoRecord")); // No record found
					$this->Page_Terminate("pages_datalist.php"); // No matching record, return to list
				}
				break;
			case "A": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->AddRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->Phrase("AddSuccess")); // Set up success message
					$sReturnUrl = $this->getReturnUrl();
					if (ew_GetPageName($sReturnUrl) == "pages_dataview.php")
						$sReturnUrl = $this->GetViewUrl(); // View paging, return to view page with keyurl directly
					$this->Page_Terminate($sReturnUrl); // Clean up and return
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->RestoreFormValues(); // Add failed, restore form values
				}
		}

		// Render row based on row type
		$this->RowType = EW_ROWTYPE_ADD;  // Render add type

		// Render row
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Get upload files
	function GetUploadFiles() {
		global $objForm;

		// Get upload data
	}

	// Load default values
	function LoadDefaultValues() {
		$this->page_url->CurrentValue = NULL;
		$this->page_url->OldValue = $this->page_url->CurrentValue;
		$this->is_protected->CurrentValue = 0;
		$this->title->CurrentValue = NULL;
		$this->title->OldValue = $this->title->CurrentValue;
		$this->title_ar->CurrentValue = NULL;
		$this->title_ar->OldValue = $this->title_ar->CurrentValue;
		$this->meta_keywords->CurrentValue = NULL;
		$this->meta_keywords->OldValue = $this->meta_keywords->CurrentValue;
		$this->meta_keywords_ar->CurrentValue = NULL;
		$this->meta_keywords_ar->OldValue = $this->meta_keywords_ar->CurrentValue;
		$this->meta_description->CurrentValue = NULL;
		$this->meta_description->OldValue = $this->meta_description->CurrentValue;
		$this->meta_description_ar->CurrentValue = NULL;
		$this->meta_description_ar->OldValue = $this->meta_description_ar->CurrentValue;
		$this->description->CurrentValue = NULL;
		$this->description->OldValue = $this->description->CurrentValue;
		$this->description_ar->CurrentValue = NULL;
		$this->description_ar->OldValue = $this->description_ar->CurrentValue;
	}

	// Load form values
	function LoadFormValues() {

		// Load from form
		global $objForm;
		if (!$this->page_url->FldIsDetailKey) {
			$this->page_url->setFormValue($objForm->GetValue("x_page_url"));
		}
		if (!$this->is_protected->FldIsDetailKey) {
			$this->is_protected->setFormValue($objForm->GetValue("x_is_protected"));
		}
		if (!$this->title->FldIsDetailKey) {
			$this->title->setFormValue($objForm->GetValue("x_title"));
		}
		if (!$this->title_ar->FldIsDetailKey) {
			$this->title_ar->setFormValue($objForm->GetValue("x_title_ar"));
		}
		if (!$this->meta_keywords->FldIsDetailKey) {
			$this->meta_keywords->setFormValue($objForm->GetValue("x_meta_keywords"));
		}
		if (!$this->meta_keywords_ar->FldIsDetailKey) {
			$this->meta_keywords_ar->setFormValue($objForm->GetValue("x_meta_keywords_ar"));
		}
		if (!$this->meta_description->FldIsDetailKey) {
			$this->meta_description->setFormValue($objForm->GetValue("x_meta_description"));
		}
		if (!$this->meta_description_ar->FldIsDetailKey) {
			$this->meta_description_ar->setFormValue($objForm->GetValue("x_meta_description_ar"));
		}
		if (!$this->description->FldIsDetailKey) {
			$this->description->setFormValue($objForm->GetValue("x_description"));
		}
		if (!$this->description_ar->FldIsDetailKey) {
			$this->description_ar->setFormValue($objForm->GetValue("x_description_ar"));
		}
	}

	// Restore form values
	function RestoreFormValues() {
		global $objForm;
		$this->LoadOldRecord();
		$this->page_url->CurrentValue = $this->page_url->FormValue;
		$this->is_protected->CurrentValue = $this->is_protected->FormValue;
		$this->title->CurrentValue = $this->title->FormValue;
		$this->title_ar->CurrentValue = $this->title_ar->FormValue;
		$this->meta_keywords->CurrentValue = $this->meta_keywords->FormValue;
		$this->meta_keywords_ar->CurrentValue = $this->meta_keywords_ar->FormValue;
		$this->meta_description->CurrentValue = $this->meta_description->FormValue;
		$this->meta_description_ar->CurrentValue = $this->meta_description_ar->FormValue;
		$this->description->CurrentValue = $this->description->FormValue;
		$this->description_ar->CurrentValue = $this->description_ar->FormValue;
	}

	// Load row based on key values
	function LoadRow() {
		global $conn, $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		global $conn;
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->page_data_id->setDbValue($rs->fields('page_data_id'));
		$this->page_url->setDbValue($rs->fields('page_url'));
		$this->is_protected->setDbValue($rs->fields('is_protected'));
		$this->title->setDbValue($rs->fields('title'));
		$this->title_ar->setDbValue($rs->fields('title_ar'));
		$this->meta_keywords->setDbValue($rs->fields('meta_keywords'));
		$this->meta_keywords_ar->setDbValue($rs->fields('meta_keywords_ar'));
		$this->meta_description->setDbValue($rs->fields('meta_description'));
		$this->meta_description_ar->setDbValue($rs->fields('meta_description_ar'));
		$this->description->setDbValue($rs->fields('description'));
		$this->description_ar->setDbValue($rs->fields('description_ar'));
		$this->date_modified->setDbValue($rs->fields('date_modified'));
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->page_data_id->DbValue = $row['page_data_id'];
		$this->page_url->DbValue = $row['page_url'];
		$this->is_protected->DbValue = $row['is_protected'];
		$this->title->DbValue = $row['title'];
		$this->title_ar->DbValue = $row['title_ar'];
		$this->meta_keywords->DbValue = $row['meta_keywords'];
		$this->meta_keywords_ar->DbValue = $row['meta_keywords_ar'];
		$this->meta_description->DbValue = $row['meta_description'];
		$this->meta_description_ar->DbValue = $row['meta_description_ar'];
		$this->description->DbValue = $row['description'];
		$this->description_ar->DbValue = $row['description_ar'];
		$this->date_modified->DbValue = $row['date_modified'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("page_data_id")) <> "")
			$this->page_data_id->CurrentValue = $this->getKey("page_data_id"); // page_data_id
		else
			$bValidKey = FALSE;

		// Load old recordset
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$this->OldRecordset = ew_LoadRecordset($sSql);
			$this->LoadRowValues($this->OldRecordset); // Load row values
		} else {
			$this->OldRecordset = NULL;
		}
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $conn, $Security, $Language;
		global $gsLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// page_data_id
		// page_url
		// is_protected
		// title
		// title_ar
		// meta_keywords
		// meta_keywords_ar
		// meta_description
		// meta_description_ar
		// description
		// description_ar
		// date_modified

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

			// page_data_id
			$this->page_data_id->ViewValue = $this->page_data_id->CurrentValue;
			$this->page_data_id->ViewCustomAttributes = "";

			// page_url
			$this->page_url->ViewValue = $this->page_url->CurrentValue;
			$this->page_url->ViewCustomAttributes = "";

			// is_protected
			if (strval($this->is_protected->CurrentValue) <> "") {
				switch ($this->is_protected->CurrentValue) {
					case $this->is_protected->FldTagValue(1):
						$this->is_protected->ViewValue = $this->is_protected->FldTagCaption(1) <> "" ? $this->is_protected->FldTagCaption(1) : $this->is_protected->CurrentValue;
						break;
					case $this->is_protected->FldTagValue(2):
						$this->is_protected->ViewValue = $this->is_protected->FldTagCaption(2) <> "" ? $this->is_protected->FldTagCaption(2) : $this->is_protected->CurrentValue;
						break;
					default:
						$this->is_protected->ViewValue = $this->is_protected->CurrentValue;
				}
			} else {
				$this->is_protected->ViewValue = NULL;
			}
			$this->is_protected->ViewCustomAttributes = "";

			// title
			$this->title->ViewValue = $this->title->CurrentValue;
			$this->title->ViewCustomAttributes = "";

			// title_ar
			$this->title_ar->ViewValue = $this->title_ar->CurrentValue;
			$this->title_ar->ViewCustomAttributes = "";

			// meta_keywords
			$this->meta_keywords->ViewValue = $this->meta_keywords->CurrentValue;
			$this->meta_keywords->ViewCustomAttributes = "";

			// meta_keywords_ar
			$this->meta_keywords_ar->ViewValue = $this->meta_keywords_ar->CurrentValue;
			$this->meta_keywords_ar->ViewCustomAttributes = "";

			// meta_description
			$this->meta_description->ViewValue = $this->meta_description->CurrentValue;
			$this->meta_description->ViewCustomAttributes = "";

			// meta_description_ar
			$this->meta_description_ar->ViewValue = $this->meta_description_ar->CurrentValue;
			$this->meta_description_ar->ViewCustomAttributes = "";

			// description
			$this->description->ViewValue = $this->description->CurrentValue;
			$this->description->ViewCustomAttributes = "";

			// description_ar
			$this->description_ar->ViewValue = $this->description_ar->CurrentValue;
			$this->description_ar->ViewCustomAttributes = "";

			// date_modified
			$this->date_modified->ViewValue = $this->date_modified->CurrentValue;
			$this->date_modified->ViewValue = ew_FormatDateTime($this->date_modified->ViewValue, 7);
			$this->date_modified->ViewCustomAttributes = "";

			// page_url
			$this->page_url->LinkCustomAttributes = "";
			$this->page_url->HrefValue = "";
			$this->page_url->TooltipValue = "";

			// is_protected
			$this->is_protected->LinkCustomAttributes = "";
			$this->is_protected->HrefValue = "";
			$this->is_protected->TooltipValue = "";

			// title
			$this->title->LinkCustomAttributes = "";
			$this->title->HrefValue = "";
			$this->title->TooltipValue = "";

			// title_ar
			$this->title_ar->LinkCustomAttributes = "";
			$this->title_ar->HrefValue = "";
			$this->title_ar->TooltipValue = "";

			// meta_keywords
			$this->meta_keywords->LinkCustomAttributes = "";
			$this->meta_keywords->HrefValue = "";
			$this->meta_keywords->TooltipValue = "";

			// meta_keywords_ar
			$this->meta_keywords_ar->LinkCustomAttributes = "";
			$this->meta_keywords_ar->HrefValue = "";
			$this->meta_keywords_ar->TooltipValue = "";

			// meta_description
			$this->meta_description->LinkCustomAttributes = "";
			$this->meta_description->HrefValue = "";
			$this->meta_description->TooltipValue = "";

			// meta_description_ar
			$this->meta_description_ar->LinkCustomAttributes = "";
			$this->meta_description_ar->HrefValue = "";
			$this->meta_description_ar->TooltipValue = "";

			// description
			$this->description->LinkCustomAttributes = "";
			$this->description->HrefValue = "";
			$this->description->TooltipValue = "";

			// description_ar
			$this->description_ar->LinkCustomAttributes = "";
			$this->description_ar->HrefValue = "";
			$this->description_ar->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_ADD) { // Add row

			// page_url
			$this->page_url->EditCustomAttributes = "";
			$this->page_url->EditValue = ew_HtmlEncode($this->page_url->CurrentValue);
			$this->page_url->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->page_url->FldCaption()));

			// is_protected
			$this->is_protected->EditCustomAttributes = "";
			$arwrk = array();
			$arwrk[] = array($this->is_protected->FldTagValue(1), $this->is_protected->FldTagCaption(1) <> "" ? $this->is_protected->FldTagCaption(1) : $this->is_protected->FldTagValue(1));
			$arwrk[] = array($this->is_protected->FldTagValue(2), $this->is_protected->FldTagCaption(2) <> "" ? $this->is_protected->FldTagCaption(2) : $this->is_protected->FldTagValue(2));
			$this->is_protected->EditValue = $arwrk;

			// title
			$this->title->EditCustomAttributes = "";
			$this->title->EditValue = ew_HtmlEncode($this->title->CurrentValue);
			$this->title->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->title->FldCaption()));

			// title_ar
			$this->title_ar->EditCustomAttributes = "";
			$this->title_ar->EditValue = ew_HtmlEncode($this->title_ar->CurrentValue);
			$this->title_ar->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->title_ar->FldCaption()));

			// meta_keywords
			$this->meta_keywords->EditCustomAttributes = "";
			$this->meta_keywords->EditValue = $this->meta_keywords->CurrentValue;
			$this->meta_keywords->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->meta_keywords->FldCaption()));

			// meta_keywords_ar
			$this->meta_keywords_ar->EditCustomAttributes = "";
			$this->meta_keywords_ar->EditValue = $this->meta_keywords_ar->CurrentValue;
			$this->meta_keywords_ar->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->meta_keywords_ar->FldCaption()));

			// meta_description
			$this->meta_description->EditCustomAttributes = "";
			$this->meta_description->EditValue = $this->meta_description->CurrentValue;
			$this->meta_description->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->meta_description->FldCaption()));

			// meta_description_ar
			$this->meta_description_ar->EditCustomAttributes = "";
			$this->meta_description_ar->EditValue = $this->meta_description_ar->CurrentValue;
			$this->meta_description_ar->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->meta_description_ar->FldCaption()));

			// description
			$this->description->EditCustomAttributes = "";
			$this->description->EditValue = $this->description->CurrentValue;
			$this->description->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->description->FldCaption()));

			// description_ar
			$this->description_ar->EditCustomAttributes = "";
			$this->description_ar->EditValue = $this->description_ar->CurrentValue;
			$this->description_ar->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->description_ar->FldCaption()));

			// Edit refer script
			// page_url

			$this->page_url->HrefValue = "";

			// is_protected
			$this->is_protected->HrefValue = "";

			// title
			$this->title->HrefValue = "";

			// title_ar
			$this->title_ar->HrefValue = "";

			// meta_keywords
			$this->meta_keywords->HrefValue = "";

			// meta_keywords_ar
			$this->meta_keywords_ar->HrefValue = "";

			// meta_description
			$this->meta_description->HrefValue = "";

			// meta_description_ar
			$this->meta_description_ar->HrefValue = "";

			// description
			$this->description->HrefValue = "";

			// description_ar
			$this->description_ar->HrefValue = "";
		}
		if ($this->RowType == EW_ROWTYPE_ADD ||
			$this->RowType == EW_ROWTYPE_EDIT ||
			$this->RowType == EW_ROWTYPE_SEARCH) { // Add / Edit / Search row
			$this->SetupFieldTitles();
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	function ValidateForm() {
		global $Language, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return ($gsFormError == "");
		if (!$this->page_url->FldIsDetailKey && !is_null($this->page_url->FormValue) && $this->page_url->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->page_url->FldCaption());
		}
		if ($this->is_protected->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->is_protected->FldCaption());
		}
		if (!$this->title->FldIsDetailKey && !is_null($this->title->FormValue) && $this->title->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->title->FldCaption());
		}
		if (!$this->title_ar->FldIsDetailKey && !is_null($this->title_ar->FormValue) && $this->title_ar->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->title_ar->FldCaption());
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsFormError, $sFormCustomError);
		}
		return $ValidateForm;
	}

	// Add record
	function AddRow($rsold = NULL) {
		global $conn, $Language, $Security;
		if ($this->page_url->CurrentValue <> "") { // Check field with unique index
			$sFilter = "(page_url = '" . ew_AdjustSql($this->page_url->CurrentValue) . "')";
			$rsChk = $this->LoadRs($sFilter);
			if ($rsChk && !$rsChk->EOF) {
				$sIdxErrMsg = str_replace("%f", $this->page_url->FldCaption(), $Language->Phrase("DupIndex"));
				$sIdxErrMsg = str_replace("%v", $this->page_url->CurrentValue, $sIdxErrMsg);
				$this->setFailureMessage($sIdxErrMsg);
				$rsChk->Close();
				return FALSE;
			}
		}

		// Load db values from rsold
		if ($rsold) {
			$this->LoadDbValues($rsold);
		}
		$rsnew = array();

		// page_url
		$this->page_url->SetDbValueDef($rsnew, $this->page_url->CurrentValue, "", FALSE);

		// is_protected
		$this->is_protected->SetDbValueDef($rsnew, $this->is_protected->CurrentValue, 0, strval($this->is_protected->CurrentValue) == "");

		// title
		$this->title->SetDbValueDef($rsnew, $this->title->CurrentValue, "", FALSE);

		// title_ar
		$this->title_ar->SetDbValueDef($rsnew, $this->title_ar->CurrentValue, "", FALSE);

		// meta_keywords
		$this->meta_keywords->SetDbValueDef($rsnew, $this->meta_keywords->CurrentValue, NULL, FALSE);

		// meta_keywords_ar
		$this->meta_keywords_ar->SetDbValueDef($rsnew, $this->meta_keywords_ar->CurrentValue, NULL, FALSE);

		// meta_description
		$this->meta_description->SetDbValueDef($rsnew, $this->meta_description->CurrentValue, NULL, FALSE);

		// meta_description_ar
		$this->meta_description_ar->SetDbValueDef($rsnew, $this->meta_description_ar->CurrentValue, NULL, FALSE);

		// description
		$this->description->SetDbValueDef($rsnew, $this->description->CurrentValue, NULL, FALSE);

		// description_ar
		$this->description_ar->SetDbValueDef($rsnew, $this->description_ar->CurrentValue, NULL, FALSE);

		// Call Row Inserting event
		$rs = ($rsold == NULL) ? NULL : $rsold->fields;
		$bInsertRow = $this->Row_Inserting($rs, $rsnew);
		if ($bInsertRow) {
			$conn->raiseErrorFn = 'ew_ErrorFn';
			$AddRow = $this->Insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($AddRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->Phrase("InsertCancelled"));
			}
			$AddRow = FALSE;
		}

		// Get insert id if necessary
		if ($AddRow) {
			$this->page_data_id->setDbValue($conn->Insert_ID());
			$rsnew['page_data_id'] = $this->page_data_id->DbValue;
		}
		if ($AddRow) {

			// Call Row Inserted event
			$rs = ($rsold == NULL) ? NULL : $rsold->fields;
			$this->Row_Inserted($rs, $rsnew);
		}
		return $AddRow;
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$PageCaption = $this->TableCaption();
		$Breadcrumb->Add("list", "<span id=\"ewPageCaption\">" . $PageCaption . "</span>", "pages_datalist.php", $this->TableVar);
		$PageCaption = ($this->CurrentAction == "C") ? $Language->Phrase("Copy") : $Language->Phrase("Add");
		$Breadcrumb->Add("add", "<span id=\"ewPageCaption\">" . $PageCaption . "</span>", ew_CurrentUrl(), $this->TableVar);
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($pages_data_add)) $pages_data_add = new cpages_data_add();

// Page init
$pages_data_add->Page_Init();

// Page main
$pages_data_add->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$pages_data_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Page object
var pages_data_add = new ew_Page("pages_data_add");
pages_data_add.PageID = "add"; // Page ID
var EW_PAGE_ID = pages_data_add.PageID; // For backward compatibility

// Form object
var fpages_dataadd = new ew_Form("fpages_dataadd");

// Validate form
fpages_dataadd.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);
	this.PostAutoSuggest();
	if ($fobj.find("#a_confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.FormKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = $fobj.find("#a_list").val() == "gridinsert";
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
			elm = this.GetElements("x" + infix + "_page_url");
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($pages_data->page_url->FldCaption()) ?>");
			elm = this.GetElements("x" + infix + "_is_protected");
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($pages_data->is_protected->FldCaption()) ?>");
			elm = this.GetElements("x" + infix + "_title");
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($pages_data->title->FldCaption()) ?>");
			elm = this.GetElements("x" + infix + "_title_ar");
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($pages_data->title_ar->FldCaption()) ?>");

			// Set up row object
			ew_ElementsToRow(fobj);

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ewForms[val])
			if (!ewForms[val].Validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fpages_dataadd.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fpages_dataadd.ValidateRequired = true;
<?php } else { ?>
fpages_dataadd.ValidateRequired = false; 
<?php } ?>

// Dynamic selection lists
// Form object for search

</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php $Breadcrumb->Render(); ?>
<?php $pages_data_add->ShowPageHeader(); ?>
<?php
$pages_data_add->ShowMessage();
?>
<form name="fpages_dataadd" id="fpages_dataadd" class="ewForm form-horizontal" action="<?php echo ew_CurrentPage() ?>" method="post">
<input type="hidden" name="t" value="pages_data">
<input type="hidden" name="a_add" id="a_add" value="A">
<table cellspacing="0" class="ewGrid"><tr><td>
<table id="tbl_pages_dataadd" class="table table-bordered table-striped">
<?php if ($pages_data->page_url->Visible) { // page_url ?>
	<tr id="r_page_url">
		<td><span id="elh_pages_data_page_url"><?php echo $pages_data->page_url->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $pages_data->page_url->CellAttributes() ?>>
<span id="el_pages_data_page_url" class="control-group">
<input type="text" data-field="x_page_url" name="x_page_url" id="x_page_url" size="30" maxlength="100" placeholder="<?php echo $pages_data->page_url->PlaceHolder ?>" value="<?php echo $pages_data->page_url->EditValue ?>"<?php echo $pages_data->page_url->EditAttributes() ?>>
</span>
<?php echo $pages_data->page_url->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($pages_data->is_protected->Visible) { // is_protected ?>
	<tr id="r_is_protected">
		<td><span id="elh_pages_data_is_protected"><?php echo $pages_data->is_protected->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $pages_data->is_protected->CellAttributes() ?>>
<span id="el_pages_data_is_protected" class="control-group">
<div id="tp_x_is_protected" class="<?php echo EW_ITEM_TEMPLATE_CLASSNAME ?>"><input type="radio" name="x_is_protected" id="x_is_protected" value="{value}"<?php echo $pages_data->is_protected->EditAttributes() ?>></div>
<div id="dsl_x_is_protected" data-repeatcolumn="5" class="ewItemList">
<?php
$arwrk = $pages_data->is_protected->EditValue;
if (is_array($arwrk)) {
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($pages_data->is_protected->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " checked=\"checked\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;

		// Note: No spacing within the LABEL tag
?>
<?php echo ew_RepeatColumnTable($rowswrk, $rowcntwrk, 5, 1) ?>
<label class="radio"><input type="radio" data-field="x_is_protected" name="x_is_protected" id="x_is_protected_<?php echo $rowcntwrk ?>" value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?><?php echo $pages_data->is_protected->EditAttributes() ?>><?php echo $arwrk[$rowcntwrk][1] ?></label>
<?php echo ew_RepeatColumnTable($rowswrk, $rowcntwrk, 5, 2) ?>
<?php
	}
}
?>
</div>
</span>
<?php echo $pages_data->is_protected->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($pages_data->title->Visible) { // title ?>
	<tr id="r_title">
		<td><span id="elh_pages_data_title"><?php echo $pages_data->title->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $pages_data->title->CellAttributes() ?>>
<span id="el_pages_data_title" class="control-group">
<input type="text" data-field="x_title" name="x_title" id="x_title" size="30" maxlength="250" placeholder="<?php echo $pages_data->title->PlaceHolder ?>" value="<?php echo $pages_data->title->EditValue ?>"<?php echo $pages_data->title->EditAttributes() ?>>
</span>
<?php echo $pages_data->title->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($pages_data->title_ar->Visible) { // title_ar ?>
	<tr id="r_title_ar">
		<td><span id="elh_pages_data_title_ar"><?php echo $pages_data->title_ar->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $pages_data->title_ar->CellAttributes() ?>>
<span id="el_pages_data_title_ar" class="control-group">
<input type="text" data-field="x_title_ar" name="x_title_ar" id="x_title_ar" size="30" maxlength="250" placeholder="<?php echo $pages_data->title_ar->PlaceHolder ?>" value="<?php echo $pages_data->title_ar->EditValue ?>"<?php echo $pages_data->title_ar->EditAttributes() ?>>
</span>
<?php echo $pages_data->title_ar->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($pages_data->meta_keywords->Visible) { // meta_keywords ?>
	<tr id="r_meta_keywords">
		<td><span id="elh_pages_data_meta_keywords"><?php echo $pages_data->meta_keywords->FldCaption() ?></span></td>
		<td<?php echo $pages_data->meta_keywords->CellAttributes() ?>>
<span id="el_pages_data_meta_keywords" class="control-group">
<textarea data-field="x_meta_keywords" name="x_meta_keywords" id="x_meta_keywords" cols="35" rows="4" placeholder="<?php echo $pages_data->meta_keywords->PlaceHolder ?>"<?php echo $pages_data->meta_keywords->EditAttributes() ?>><?php echo $pages_data->meta_keywords->EditValue ?></textarea>
</span>
<?php echo $pages_data->meta_keywords->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($pages_data->meta_keywords_ar->Visible) { // meta_keywords_ar ?>
	<tr id="r_meta_keywords_ar">
		<td><span id="elh_pages_data_meta_keywords_ar"><?php echo $pages_data->meta_keywords_ar->FldCaption() ?></span></td>
		<td<?php echo $pages_data->meta_keywords_ar->CellAttributes() ?>>
<span id="el_pages_data_meta_keywords_ar" class="control-group">
<textarea data-field="x_meta_keywords_ar" name="x_meta_keywords_ar" id="x_meta_keywords_ar" cols="35" rows="4" placeholder="<?php echo $pages_data->meta_keywords_ar->PlaceHolder ?>"<?php echo $pages_data->meta_keywords_ar->EditAttributes() ?>><?php echo $pages_data->meta_keywords_ar->EditValue ?></textarea>
</span>
<?php echo $pages_data->meta_keywords_ar->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($pages_data->meta_description->Visible) { // meta_description ?>
	<tr id="r_meta_description">
		<td><span id="elh_pages_data_meta_description"><?php echo $pages_data->meta_description->FldCaption() ?></span></td>
		<td<?php echo $pages_data->meta_description->CellAttributes() ?>>
<span id="el_pages_data_meta_description" class="control-group">
<textarea data-field="x_meta_description" name="x_meta_description" id="x_meta_description" cols="35" rows="4" placeholder="<?php echo $pages_data->meta_description->PlaceHolder ?>"<?php echo $pages_data->meta_description->EditAttributes() ?>><?php echo $pages_data->meta_description->EditValue ?></textarea>
</span>
<?php echo $pages_data->meta_description->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($pages_data->meta_description_ar->Visible) { // meta_description_ar ?>
	<tr id="r_meta_description_ar">
		<td><span id="elh_pages_data_meta_description_ar"><?php echo $pages_data->meta_description_ar->FldCaption() ?></span></td>
		<td<?php echo $pages_data->meta_description_ar->CellAttributes() ?>>
<span id="el_pages_data_meta_description_ar" class="control-group">
<textarea data-field="x_meta_description_ar" name="x_meta_description_ar" id="x_meta_description_ar" cols="35" rows="4" placeholder="<?php echo $pages_data->meta_description_ar->PlaceHolder ?>"<?php echo $pages_data->meta_description_ar->EditAttributes() ?>><?php echo $pages_data->meta_description_ar->EditValue ?></textarea>
</span>
<?php echo $pages_data->meta_description_ar->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($pages_data->description->Visible) { // description ?>
	<tr id="r_description">
		<td><span id="elh_pages_data_description"><?php echo $pages_data->description->FldCaption() ?></span></td>
		<td<?php echo $pages_data->description->CellAttributes() ?>>
<span id="el_pages_data_description" class="control-group">
<textarea data-field="x_description" class="editor" name="x_description" id="x_description" cols="35" rows="4" placeholder="<?php echo $pages_data->description->PlaceHolder ?>"<?php echo $pages_data->description->EditAttributes() ?>><?php echo $pages_data->description->EditValue ?></textarea>
<script type="text/javascript">
ew_CreateEditor("fpages_dataadd", "x_description", 35, 4, <?php echo ($pages_data->description->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $pages_data->description->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($pages_data->description_ar->Visible) { // description_ar ?>
	<tr id="r_description_ar">
		<td><span id="elh_pages_data_description_ar"><?php echo $pages_data->description_ar->FldCaption() ?></span></td>
		<td<?php echo $pages_data->description_ar->CellAttributes() ?>>
<span id="el_pages_data_description_ar" class="control-group">
<textarea data-field="x_description_ar" class="editor" name="x_description_ar" id="x_description_ar" cols="35" rows="4" placeholder="<?php echo $pages_data->description_ar->PlaceHolder ?>"<?php echo $pages_data->description_ar->EditAttributes() ?>><?php echo $pages_data->description_ar->EditValue ?></textarea>
<script type="text/javascript">
ew_CreateEditor("fpages_dataadd", "x_description_ar", 35, 4, <?php echo ($pages_data->description_ar->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $pages_data->description_ar->CustomMsg ?></td>
	</tr>
<?php } ?>
</table>
</td></tr></table>
<button class="btn btn-primary ewButton" name="btnAction" id="btnAction" type="submit"><?php echo $Language->Phrase("AddBtn") ?></button>
</form>
<script type="text/javascript">
fpages_dataadd.Init();
<?php if (EW_MOBILE_REFLOW && ew_IsMobile()) { ?>
ew_Reflow();
<?php } ?>
</script>
<?php
$pages_data_add->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$pages_data_add->Page_Terminate();
?>
