<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg10.php" ?>
<?php include_once "ewmysql10.php" ?>
<?php include_once "phpfn10.php" ?>
<?php include_once "pages_datainfo.php" ?>
<?php include_once "_logininfo.php" ?>
<?php include_once "userfn10.php" ?>
<?php

//
// Page class
//

$pages_data_view = NULL; // Initialize page object first

class cpages_data_view extends cpages_data {

	// Page ID
	var $PageID = 'view';

	// Project ID
	var $ProjectID = "{F555B504-0784-474D-925D-CB2D041B48DF}";

	// Table name
	var $TableName = 'pages_data';

	// Page object name
	var $PageObjName = 'pages_data_view';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Page URLs
	var $AddUrl;
	var $EditUrl;
	var $CopyUrl;
	var $DeleteUrl;
	var $ViewUrl;
	var $ListUrl;

	// Export URLs
	var $ExportPrintUrl;
	var $ExportHtmlUrl;
	var $ExportExcelUrl;
	var $ExportWordUrl;
	var $ExportXmlUrl;
	var $ExportCsvUrl;
	var $ExportPdfUrl;

	// Update URLs
	var $InlineAddUrl;
	var $InlineCopyUrl;
	var $InlineEditUrl;
	var $GridAddUrl;
	var $GridEditUrl;
	var $MultiDeleteUrl;
	var $MultiUpdateUrl;

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-error ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<table class=\"ewStdTable\"><tr><td><div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div></td></tr></table>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language, $UserAgent;

		// User agent
		$UserAgent = ew_UserAgent();
		$GLOBALS["Page"] = &$this;

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (pages_data)
		if (!isset($GLOBALS["pages_data"])) {
			$GLOBALS["pages_data"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["pages_data"];
		}
		$KeyUrl = "";
		if (@$_GET["page_data_id"] <> "") {
			$this->RecKey["page_data_id"] = $_GET["page_data_id"];
			$KeyUrl .= "&page_data_id=" . urlencode($this->RecKey["page_data_id"]);
		}
		$this->ExportPrintUrl = $this->PageUrl() . "export=print" . $KeyUrl;
		$this->ExportHtmlUrl = $this->PageUrl() . "export=html" . $KeyUrl;
		$this->ExportExcelUrl = $this->PageUrl() . "export=excel" . $KeyUrl;
		$this->ExportWordUrl = $this->PageUrl() . "export=word" . $KeyUrl;
		$this->ExportXmlUrl = $this->PageUrl() . "export=xml" . $KeyUrl;
		$this->ExportCsvUrl = $this->PageUrl() . "export=csv" . $KeyUrl;
		$this->ExportPdfUrl = $this->PageUrl() . "export=pdf" . $KeyUrl;

		// Table object (_login)
		if (!isset($GLOBALS['_login'])) $GLOBALS['_login'] = new c_login();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'view', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'pages_data', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect();

		// Export options
		$this->ExportOptions = new cListOptions();
		$this->ExportOptions->Tag = "span";
		$this->ExportOptions->TagClassName = "ewExportOption";

		// Other options
		$this->OtherOptions['action'] = new cListOptions();
		$this->OtherOptions['action']->Tag = "span";
		$this->OtherOptions['action']->TagClassName = "ewActionOption";
		$this->OtherOptions['detail'] = new cListOptions();
		$this->OtherOptions['detail']->Tag = "span";
		$this->OtherOptions['detail']->TagClassName = "ewDetailOption";
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login.php");
		}
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up curent action
		$this->page_data_id->Visible = !$this->IsAdd() && !$this->IsCopy() && !$this->IsGridAdd();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $conn;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();
		$this->Page_Redirecting($url);

		 // Close connection
		$conn->Close();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}
	var $ExportOptions; // Export options
	var $OtherOptions = array(); // Other options
	var $DisplayRecs = 1;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $Pager;
	var $RecCnt;
	var $RecKey = array();
	var $Recordset;

	//
	// Page main
	//
	function Page_Main() {
		global $Language;

		// Load current record
		$bLoadCurrentRecord = FALSE;
		$sReturnUrl = "";
		$bMatchRecord = FALSE;

		// Set up Breadcrumb
		$this->SetupBreadcrumb();
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET["page_data_id"] <> "") {
				$this->page_data_id->setQueryStringValue($_GET["page_data_id"]);
				$this->RecKey["page_data_id"] = $this->page_data_id->QueryStringValue;
			} else {
				$bLoadCurrentRecord = TRUE;
			}

			// Get action
			$this->CurrentAction = "I"; // Display form
			switch ($this->CurrentAction) {
				case "I": // Get a record to display
					$this->StartRec = 1; // Initialize start position
					if ($this->Recordset = $this->LoadRecordset()) // Load records
						$this->TotalRecs = $this->Recordset->RecordCount(); // Get record count
					if ($this->TotalRecs <= 0) { // No record found
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->Phrase("NoRecord")); // Set no record message
						$this->Page_Terminate("pages_datalist.php"); // Return to list page
					} elseif ($bLoadCurrentRecord) { // Load current record position
						$this->SetUpStartRec(); // Set up start record position

						// Point to current record
						if (intval($this->StartRec) <= intval($this->TotalRecs)) {
							$bMatchRecord = TRUE;
							$this->Recordset->Move($this->StartRec-1);
						}
					} else { // Match key values
						while (!$this->Recordset->EOF) {
							if (strval($this->page_data_id->CurrentValue) == strval($this->Recordset->fields('page_data_id'))) {
								$this->setStartRecordNumber($this->StartRec); // Save record position
								$bMatchRecord = TRUE;
								break;
							} else {
								$this->StartRec++;
								$this->Recordset->MoveNext();
							}
						}
					}
					if (!$bMatchRecord) {
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->Phrase("NoRecord")); // Set no record message
						$sReturnUrl = "pages_datalist.php"; // No matching record, return to list
					} else {
						$this->LoadRowValues($this->Recordset); // Load row values
					}
			}
		} else {
			$sReturnUrl = "pages_datalist.php"; // Not page request, return to list
		}
		if ($sReturnUrl <> "")
			$this->Page_Terminate($sReturnUrl);

		// Render row
		$this->RowType = EW_ROWTYPE_VIEW;
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Set up other options
	function SetupOtherOptions() {
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = &$options["action"];

		// Add
		$item = &$option->Add("add");
		$item->Body = "<a class=\"ewAction ewAdd\" href=\"" . ew_HtmlEncode($this->AddUrl) . "\">" . $Language->Phrase("ViewPageAddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->IsLoggedIn());

		// Edit
		$item = &$option->Add("edit");
		$item->Body = "<a class=\"ewAction ewEdit\" href=\"" . ew_HtmlEncode($this->EditUrl) . "\">" . $Language->Phrase("ViewPageEditLink") . "</a>";
		$item->Visible = ($this->EditUrl <> "" && $Security->IsLoggedIn());

		// Delete
		$item = &$option->Add("delete");
		$item->Body = "<a class=\"ewAction ewDelete\" href=\"" . ew_HtmlEncode($this->DeleteUrl) . "\">" . $Language->Phrase("ViewPageDeleteLink") . "</a>";
		$item->Visible = ($this->DeleteUrl <> "" && $Security->IsLoggedIn());

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;
			$item = &$option->Add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["detail"]->DropDownButtonPhrase = $Language->Phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->Phrase("ButtonActions");
	}

	// Set up starting record parameters
	function SetUpStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {
		global $conn;

		// Call Recordset Selecting event
		$this->Recordset_Selecting($this->CurrentFilter);

		// Load List page SQL
		$sSql = $this->SelectSQL();
		if ($offset > -1 && $rowcnt > -1)
			$sSql .= " LIMIT $rowcnt OFFSET $offset";

		// Load recordset
		$rs = ew_LoadRecordset($sSql);

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $conn, $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		global $conn;
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->page_data_id->setDbValue($rs->fields('page_data_id'));
		$this->page_url->setDbValue($rs->fields('page_url'));
		$this->is_protected->setDbValue($rs->fields('is_protected'));
		$this->title->setDbValue($rs->fields('title'));
		$this->title_ar->setDbValue($rs->fields('title_ar'));
		$this->meta_keywords->setDbValue($rs->fields('meta_keywords'));
		$this->meta_keywords_ar->setDbValue($rs->fields('meta_keywords_ar'));
		$this->meta_description->setDbValue($rs->fields('meta_description'));
		$this->meta_description_ar->setDbValue($rs->fields('meta_description_ar'));
		$this->description->setDbValue($rs->fields('description'));
		$this->description_ar->setDbValue($rs->fields('description_ar'));
		$this->date_modified->setDbValue($rs->fields('date_modified'));
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->page_data_id->DbValue = $row['page_data_id'];
		$this->page_url->DbValue = $row['page_url'];
		$this->is_protected->DbValue = $row['is_protected'];
		$this->title->DbValue = $row['title'];
		$this->title_ar->DbValue = $row['title_ar'];
		$this->meta_keywords->DbValue = $row['meta_keywords'];
		$this->meta_keywords_ar->DbValue = $row['meta_keywords_ar'];
		$this->meta_description->DbValue = $row['meta_description'];
		$this->meta_description_ar->DbValue = $row['meta_description_ar'];
		$this->description->DbValue = $row['description'];
		$this->description_ar->DbValue = $row['description_ar'];
		$this->date_modified->DbValue = $row['date_modified'];
	}

	// Render row values based on field settings
	function RenderRow() {
		global $conn, $Security, $Language;
		global $gsLanguage;

		// Initialize URLs
		$this->AddUrl = $this->GetAddUrl();
		$this->EditUrl = $this->GetEditUrl();
		$this->CopyUrl = $this->GetCopyUrl();
		$this->DeleteUrl = $this->GetDeleteUrl();
		$this->ListUrl = $this->GetListUrl();
		$this->SetupOtherOptions();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// page_data_id
		// page_url
		// is_protected
		// title
		// title_ar
		// meta_keywords
		// meta_keywords_ar
		// meta_description
		// meta_description_ar
		// description
		// description_ar
		// date_modified

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

			// page_data_id
			$this->page_data_id->ViewValue = $this->page_data_id->CurrentValue;
			$this->page_data_id->ViewCustomAttributes = "";

			// page_url
			$this->page_url->ViewValue = $this->page_url->CurrentValue;
			$this->page_url->ViewCustomAttributes = "";

			// is_protected
			if (strval($this->is_protected->CurrentValue) <> "") {
				switch ($this->is_protected->CurrentValue) {
					case $this->is_protected->FldTagValue(1):
						$this->is_protected->ViewValue = $this->is_protected->FldTagCaption(1) <> "" ? $this->is_protected->FldTagCaption(1) : $this->is_protected->CurrentValue;
						break;
					case $this->is_protected->FldTagValue(2):
						$this->is_protected->ViewValue = $this->is_protected->FldTagCaption(2) <> "" ? $this->is_protected->FldTagCaption(2) : $this->is_protected->CurrentValue;
						break;
					default:
						$this->is_protected->ViewValue = $this->is_protected->CurrentValue;
				}
			} else {
				$this->is_protected->ViewValue = NULL;
			}
			$this->is_protected->ViewCustomAttributes = "";

			// title
			$this->title->ViewValue = $this->title->CurrentValue;
			$this->title->ViewCustomAttributes = "";

			// title_ar
			$this->title_ar->ViewValue = $this->title_ar->CurrentValue;
			$this->title_ar->ViewCustomAttributes = "";

			// meta_keywords
			$this->meta_keywords->ViewValue = $this->meta_keywords->CurrentValue;
			$this->meta_keywords->ViewCustomAttributes = "";

			// meta_keywords_ar
			$this->meta_keywords_ar->ViewValue = $this->meta_keywords_ar->CurrentValue;
			$this->meta_keywords_ar->ViewCustomAttributes = "";

			// meta_description
			$this->meta_description->ViewValue = $this->meta_description->CurrentValue;
			$this->meta_description->ViewCustomAttributes = "";

			// meta_description_ar
			$this->meta_description_ar->ViewValue = $this->meta_description_ar->CurrentValue;
			$this->meta_description_ar->ViewCustomAttributes = "";

			// description
			$this->description->ViewValue = $this->description->CurrentValue;
			$this->description->ViewCustomAttributes = "";

			// description_ar
			$this->description_ar->ViewValue = $this->description_ar->CurrentValue;
			$this->description_ar->ViewCustomAttributes = "";

			// date_modified
			$this->date_modified->ViewValue = $this->date_modified->CurrentValue;
			$this->date_modified->ViewValue = ew_FormatDateTime($this->date_modified->ViewValue, 7);
			$this->date_modified->ViewCustomAttributes = "";

			// page_data_id
			$this->page_data_id->LinkCustomAttributes = "";
			$this->page_data_id->HrefValue = "";
			$this->page_data_id->TooltipValue = "";

			// page_url
			$this->page_url->LinkCustomAttributes = "";
			$this->page_url->HrefValue = "";
			$this->page_url->TooltipValue = "";

			// is_protected
			$this->is_protected->LinkCustomAttributes = "";
			$this->is_protected->HrefValue = "";
			$this->is_protected->TooltipValue = "";

			// title
			$this->title->LinkCustomAttributes = "";
			$this->title->HrefValue = "";
			$this->title->TooltipValue = "";

			// title_ar
			$this->title_ar->LinkCustomAttributes = "";
			$this->title_ar->HrefValue = "";
			$this->title_ar->TooltipValue = "";

			// meta_keywords
			$this->meta_keywords->LinkCustomAttributes = "";
			$this->meta_keywords->HrefValue = "";
			$this->meta_keywords->TooltipValue = "";

			// meta_keywords_ar
			$this->meta_keywords_ar->LinkCustomAttributes = "";
			$this->meta_keywords_ar->HrefValue = "";
			$this->meta_keywords_ar->TooltipValue = "";

			// meta_description
			$this->meta_description->LinkCustomAttributes = "";
			$this->meta_description->HrefValue = "";
			$this->meta_description->TooltipValue = "";

			// meta_description_ar
			$this->meta_description_ar->LinkCustomAttributes = "";
			$this->meta_description_ar->HrefValue = "";
			$this->meta_description_ar->TooltipValue = "";

			// description
			$this->description->LinkCustomAttributes = "";
			$this->description->HrefValue = "";
			$this->description->TooltipValue = "";

			// description_ar
			$this->description_ar->LinkCustomAttributes = "";
			$this->description_ar->HrefValue = "";
			$this->description_ar->TooltipValue = "";

			// date_modified
			$this->date_modified->LinkCustomAttributes = "";
			$this->date_modified->HrefValue = "";
			$this->date_modified->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$PageCaption = $this->TableCaption();
		$Breadcrumb->Add("list", "<span id=\"ewPageCaption\">" . $PageCaption . "</span>", "pages_datalist.php", $this->TableVar);
		$PageCaption = $Language->Phrase("view");
		$Breadcrumb->Add("view", "<span id=\"ewPageCaption\">" . $PageCaption . "</span>", ew_CurrentUrl(), $this->TableVar);
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($pages_data_view)) $pages_data_view = new cpages_data_view();

// Page init
$pages_data_view->Page_Init();

// Page main
$pages_data_view->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$pages_data_view->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Page object
var pages_data_view = new ew_Page("pages_data_view");
pages_data_view.PageID = "view"; // Page ID
var EW_PAGE_ID = pages_data_view.PageID; // For backward compatibility

// Form object
var fpages_dataview = new ew_Form("fpages_dataview");

// Form_CustomValidate event
fpages_dataview.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fpages_dataview.ValidateRequired = true;
<?php } else { ?>
fpages_dataview.ValidateRequired = false; 
<?php } ?>

// Dynamic selection lists
// Form object for search

</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php $Breadcrumb->Render(); ?>
<div class="ewViewExportOptions">
<?php $pages_data_view->ExportOptions->Render("body") ?>
<?php if (!$pages_data_view->ExportOptions->UseDropDownButton) { ?>
</div>
<div class="ewViewOtherOptions">
<?php } ?>
<?php
	foreach ($pages_data_view->OtherOptions as &$option)
		$option->Render("body");
?>
</div>
<?php $pages_data_view->ShowPageHeader(); ?>
<?php
$pages_data_view->ShowMessage();
?>
<form name="ewPagerForm" class="ewForm form-horizontal" action="<?php echo ew_CurrentPage() ?>">
<table class="ewPager">
<tr><td>
<?php if (!isset($pages_data_view->Pager)) $pages_data_view->Pager = new cPrevNextPager($pages_data_view->StartRec, $pages_data_view->DisplayRecs, $pages_data_view->TotalRecs) ?>
<?php if ($pages_data_view->Pager->RecordCount > 0) { ?>
<table cellspacing="0" class="ewStdTable"><tbody><tr><td>
	<?php echo $Language->Phrase("Page") ?>&nbsp;
<div class="input-prepend input-append">
<!--first page button-->
	<?php if ($pages_data_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-small" type="button" href="<?php echo $pages_data_view->PageUrl() ?>start=<?php echo $pages_data_view->Pager->FirstButton->Start ?>"><i class="icon-step-backward"></i></a>
	<?php } else { ?>
	<a class="btn btn-small" type="button" disabled="disabled"><i class="icon-step-backward"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($pages_data_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-small" type="button" href="<?php echo $pages_data_view->PageUrl() ?>start=<?php echo $pages_data_view->Pager->PrevButton->Start ?>"><i class="icon-prev"></i></a>
	<?php } else { ?>
	<a class="btn btn-small" type="button" disabled="disabled"><i class="icon-prev"></i></a>
	<?php } ?>
<!--current page number-->
	<input class="input-mini" type="text" name="<?php echo EW_TABLE_PAGE_NO ?>" value="<?php echo $pages_data_view->Pager->CurrentPage ?>">
<!--next page button-->
	<?php if ($pages_data_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-small" type="button" href="<?php echo $pages_data_view->PageUrl() ?>start=<?php echo $pages_data_view->Pager->NextButton->Start ?>"><i class="icon-play"></i></a>
	<?php } else { ?>
	<a class="btn btn-small" type="button" disabled="disabled"><i class="icon-play"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($pages_data_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-small" type="button" href="<?php echo $pages_data_view->PageUrl() ?>start=<?php echo $pages_data_view->Pager->LastButton->Start ?>"><i class="icon-step-forward"></i></a>
	<?php } else { ?>
	<a class="btn btn-small" type="button" disabled="disabled"><i class="icon-step-forward"></i></a>
	<?php } ?>
</div>
	&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $pages_data_view->Pager->PageCount ?>
</td>
</tr></tbody></table>
<?php } else { ?>
	<p><?php echo $Language->Phrase("NoRecord") ?></p>
<?php } ?>
</td>
</tr></table>
</form>
<form name="fpages_dataview" id="fpages_dataview" class="ewForm form-horizontal" action="<?php echo ew_CurrentPage() ?>" method="post">
<input type="hidden" name="t" value="pages_data">
<table cellspacing="0" class="ewGrid"><tr><td>
<table id="tbl_pages_dataview" class="table table-bordered table-striped">
<?php if ($pages_data->page_data_id->Visible) { // page_data_id ?>
	<tr id="r_page_data_id">
		<td><span id="elh_pages_data_page_data_id"><?php echo $pages_data->page_data_id->FldCaption() ?></span></td>
		<td<?php echo $pages_data->page_data_id->CellAttributes() ?>>
<span id="el_pages_data_page_data_id" class="control-group">
<span<?php echo $pages_data->page_data_id->ViewAttributes() ?>>
<?php echo $pages_data->page_data_id->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pages_data->page_url->Visible) { // page_url ?>
	<tr id="r_page_url">
		<td><span id="elh_pages_data_page_url"><?php echo $pages_data->page_url->FldCaption() ?></span></td>
		<td<?php echo $pages_data->page_url->CellAttributes() ?>>
<span id="el_pages_data_page_url" class="control-group">
<span<?php echo $pages_data->page_url->ViewAttributes() ?>>
<?php echo $pages_data->page_url->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pages_data->is_protected->Visible) { // is_protected ?>
	<tr id="r_is_protected">
		<td><span id="elh_pages_data_is_protected"><?php echo $pages_data->is_protected->FldCaption() ?></span></td>
		<td<?php echo $pages_data->is_protected->CellAttributes() ?>>
<span id="el_pages_data_is_protected" class="control-group">
<span<?php echo $pages_data->is_protected->ViewAttributes() ?>>
<?php echo $pages_data->is_protected->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pages_data->title->Visible) { // title ?>
	<tr id="r_title">
		<td><span id="elh_pages_data_title"><?php echo $pages_data->title->FldCaption() ?></span></td>
		<td<?php echo $pages_data->title->CellAttributes() ?>>
<span id="el_pages_data_title" class="control-group">
<span<?php echo $pages_data->title->ViewAttributes() ?>>
<?php echo $pages_data->title->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pages_data->title_ar->Visible) { // title_ar ?>
	<tr id="r_title_ar">
		<td><span id="elh_pages_data_title_ar"><?php echo $pages_data->title_ar->FldCaption() ?></span></td>
		<td<?php echo $pages_data->title_ar->CellAttributes() ?>>
<span id="el_pages_data_title_ar" class="control-group">
<span<?php echo $pages_data->title_ar->ViewAttributes() ?>>
<?php echo $pages_data->title_ar->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pages_data->meta_keywords->Visible) { // meta_keywords ?>
	<tr id="r_meta_keywords">
		<td><span id="elh_pages_data_meta_keywords"><?php echo $pages_data->meta_keywords->FldCaption() ?></span></td>
		<td<?php echo $pages_data->meta_keywords->CellAttributes() ?>>
<span id="el_pages_data_meta_keywords" class="control-group">
<span<?php echo $pages_data->meta_keywords->ViewAttributes() ?>>
<?php echo $pages_data->meta_keywords->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pages_data->meta_keywords_ar->Visible) { // meta_keywords_ar ?>
	<tr id="r_meta_keywords_ar">
		<td><span id="elh_pages_data_meta_keywords_ar"><?php echo $pages_data->meta_keywords_ar->FldCaption() ?></span></td>
		<td<?php echo $pages_data->meta_keywords_ar->CellAttributes() ?>>
<span id="el_pages_data_meta_keywords_ar" class="control-group">
<span<?php echo $pages_data->meta_keywords_ar->ViewAttributes() ?>>
<?php echo $pages_data->meta_keywords_ar->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pages_data->meta_description->Visible) { // meta_description ?>
	<tr id="r_meta_description">
		<td><span id="elh_pages_data_meta_description"><?php echo $pages_data->meta_description->FldCaption() ?></span></td>
		<td<?php echo $pages_data->meta_description->CellAttributes() ?>>
<span id="el_pages_data_meta_description" class="control-group">
<span<?php echo $pages_data->meta_description->ViewAttributes() ?>>
<?php echo $pages_data->meta_description->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pages_data->meta_description_ar->Visible) { // meta_description_ar ?>
	<tr id="r_meta_description_ar">
		<td><span id="elh_pages_data_meta_description_ar"><?php echo $pages_data->meta_description_ar->FldCaption() ?></span></td>
		<td<?php echo $pages_data->meta_description_ar->CellAttributes() ?>>
<span id="el_pages_data_meta_description_ar" class="control-group">
<span<?php echo $pages_data->meta_description_ar->ViewAttributes() ?>>
<?php echo $pages_data->meta_description_ar->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pages_data->description->Visible) { // description ?>
	<tr id="r_description">
		<td><span id="elh_pages_data_description"><?php echo $pages_data->description->FldCaption() ?></span></td>
		<td<?php echo $pages_data->description->CellAttributes() ?>>
<span id="el_pages_data_description" class="control-group">
<span<?php echo $pages_data->description->ViewAttributes() ?>>
<?php echo $pages_data->description->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pages_data->description_ar->Visible) { // description_ar ?>
	<tr id="r_description_ar">
		<td><span id="elh_pages_data_description_ar"><?php echo $pages_data->description_ar->FldCaption() ?></span></td>
		<td<?php echo $pages_data->description_ar->CellAttributes() ?>>
<span id="el_pages_data_description_ar" class="control-group">
<span<?php echo $pages_data->description_ar->ViewAttributes() ?>>
<?php echo $pages_data->description_ar->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($pages_data->date_modified->Visible) { // date_modified ?>
	<tr id="r_date_modified">
		<td><span id="elh_pages_data_date_modified"><?php echo $pages_data->date_modified->FldCaption() ?></span></td>
		<td<?php echo $pages_data->date_modified->CellAttributes() ?>>
<span id="el_pages_data_date_modified" class="control-group">
<span<?php echo $pages_data->date_modified->ViewAttributes() ?>>
<?php echo $pages_data->date_modified->ViewValue ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</td></tr></table>
<table class="ewPager">
<tr><td>
<?php if (!isset($pages_data_view->Pager)) $pages_data_view->Pager = new cPrevNextPager($pages_data_view->StartRec, $pages_data_view->DisplayRecs, $pages_data_view->TotalRecs) ?>
<?php if ($pages_data_view->Pager->RecordCount > 0) { ?>
<table cellspacing="0" class="ewStdTable"><tbody><tr><td>
	<?php echo $Language->Phrase("Page") ?>&nbsp;
<div class="input-prepend input-append">
<!--first page button-->
	<?php if ($pages_data_view->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-small" type="button" href="<?php echo $pages_data_view->PageUrl() ?>start=<?php echo $pages_data_view->Pager->FirstButton->Start ?>"><i class="icon-step-backward"></i></a>
	<?php } else { ?>
	<a class="btn btn-small" type="button" disabled="disabled"><i class="icon-step-backward"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($pages_data_view->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-small" type="button" href="<?php echo $pages_data_view->PageUrl() ?>start=<?php echo $pages_data_view->Pager->PrevButton->Start ?>"><i class="icon-prev"></i></a>
	<?php } else { ?>
	<a class="btn btn-small" type="button" disabled="disabled"><i class="icon-prev"></i></a>
	<?php } ?>
<!--current page number-->
	<input class="input-mini" type="text" name="<?php echo EW_TABLE_PAGE_NO ?>" value="<?php echo $pages_data_view->Pager->CurrentPage ?>">
<!--next page button-->
	<?php if ($pages_data_view->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-small" type="button" href="<?php echo $pages_data_view->PageUrl() ?>start=<?php echo $pages_data_view->Pager->NextButton->Start ?>"><i class="icon-play"></i></a>
	<?php } else { ?>
	<a class="btn btn-small" type="button" disabled="disabled"><i class="icon-play"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($pages_data_view->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-small" type="button" href="<?php echo $pages_data_view->PageUrl() ?>start=<?php echo $pages_data_view->Pager->LastButton->Start ?>"><i class="icon-step-forward"></i></a>
	<?php } else { ?>
	<a class="btn btn-small" type="button" disabled="disabled"><i class="icon-step-forward"></i></a>
	<?php } ?>
</div>
	&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $pages_data_view->Pager->PageCount ?>
</td>
</tr></tbody></table>
<?php } else { ?>
	<p><?php echo $Language->Phrase("NoRecord") ?></p>
<?php } ?>
</td>
</tr></table>
</form>
<script type="text/javascript">
fpages_dataview.Init();
</script>
<?php
$pages_data_view->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$pages_data_view->Page_Terminate();
?>
