<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	http://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'home';
$route['home'] = 'home';

// News Management
$route['announcements'] = 'news/show_list/announcements';
$route['news'] = 'news/news_page';
$route['activities'] = 'news/show_list/activities';
$route['events'] = 'news/show_list/events';
$route['latest-university-news'] = 'news/show_list/news';
$route['worldwide-published-researches'] = 'news/show_list/worldwide-published-researches';

$route['announcements/(:num)'] = 'news/news_detail/$1';
$route['news/(:num)'] = 'news/news_detail/$1';
$route['activities/(:num)'] = 'news/news_detail/$1';
$route['events/(:num)'] = 'news/news_detail/$1';
$route['worldwide-published-researches/(:num)'] = 'news/news_detail/$1';


$route['contact'] = 'home/contact';
$route['contact/process'] = 'home/contact_process';

$route['download_file'] = 'home/download_file';
$route['form-process'] = 'home/form_builder_process';
$route['download-pdf'] = 'printDoc/print_pdf';
$route['search'] = 'home/search';
$route['people/(:any)'] = 'home/people/$1';
$route['staff'] = 'home/show_all_people';
$route['staff/(:any)'] = 'home/people/$1';

$route['certificates'] = 'home/certificates';
$route['trainee/(:num)'] = 'home/trainee/$1';

$route['your-opinion'] = 'home/your_opinion';

/* Authentication Routes */
$route['login'] = 'home/show_page/login';
$route['login/process'] = 'home/login_process';
$route['register'] = 'home/show_page/register';
$route['register-success'] = 'home/show_page/register_success';
$route['register/process'] = 'home/register_process';
$route['user-activation/(:any)/(:any)'] = 'home/user_activation/$1/$2';
$route['logout'] = 'home/logout';
$route['change-password'] = 'home/show_page/change_password';
$route['process_change_password'] = 'home/process_change_password';

$route['(:any)'] = 'home/txt_page_view/$1';
$route['(:any)/(:num)'] = 'home/txt_page_view/$1/$2';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;

