<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends Base_Controller {

    public function index()
    {
        $data['core_data'] = $this->load_site_core();

        $qry = $this->db->query("SELECT id, title_ar, thumb, external_link FROM news WHERE news_type_id = 5 and lang_filter IN (1,3) ORDER BY id DESC LIMIT 10");
        $data['banner_data'] = $qry->result_array();

        $qry = $this->db->query("SELECT id, title_ar, external_link FROM news WHERE news_type_id = 4 and lang_filter IN (1,3) ORDER BY id DESC LIMIT 5");
        $data['latest_announcements'] = $qry->result_array();

        $qry = $this->db->query("SELECT id, title_ar, external_link FROM news WHERE news_type_id = 5 and lang_filter IN (1,3) ORDER BY id DESC LIMIT 5");
        $data["latest_news"] = $qry->result_array();

        $qry = $this->db->query("SELECT id, title_ar, description_ar, DATE_FORMAT(news_date, '%d %M, %Y') as news_date, external_link FROM news WHERE is_imp = 1 and lang_filter IN (1,3) ORDER BY id DESC LIMIT 20");
        $data["important_news"] = $qry->result_array();     

        $qry = $this->db->query('SELECT * FROM home_blocks_ar ORDER BY id ASC');
        $data['home_blocks'] = $qry->result_array();

        $this->load->view('home', $data);   
    }

    public function txt_page_view($txt_page = '', $news_id = 0)
    {
        $txt_page = $this->db->escape_str($txt_page);
        $qry = $this->db->query("SELECT * FROM news_type WHERE url = ?", array($txt_page));
        $news_type_data = $qry->row_array();
        
        if (is_array($news_type_data) && count($news_type_data) > 0) {
            if ($news_id != 0) {
                $news_id = (int) $news_id;

                $data['core_data'] = $this->load_site_core();        

                $qry = $this->db->query("SELECT id, news_type_id, title_ar, thumb, pdf, DATE_FORMAT(news_date, '%d %M, %Y') as news_date, description_ar FROM news WHERE id = ? LIMIT 1", array($news_id));
                $data['news_row'] = $qry->row_array();
                $news_type_id = $data['news_row']['news_type_id'];

                $qry = $this->db->query("SELECT name, url FROM news_type WHERE id = ?", array($news_type_id));
                $data['news_type_data'] = $qry->row_array();
                if ($data['news_type_data']['url'] == "news") {
                    $data['news_type_data']['url'] = "latest-university-news";    
                }

                $data['core_data']['page_data']['title_ar'] = htmlspecialchars(substr($data['news_row']['title_ar'], 0, 50), ENT_QUOTES, 'UTF-8');
                $data['core_data']['page_data']['meta_description_ar'] = htmlspecialchars(str_replace("\n", " ", strip_tags(substr($data['news_row']['description_ar'], 0, 500))), ENT_QUOTES, 'UTF-8');

                $qry = $this->db->query("SELECT * FROM news_pictures WHERE news_id = ?", array($news_id));
                $data["news_pictures"] = $qry->result_array();

                $this->load->view('news_detail', $data); 
            } else {
                $url_key = $txt_page;
                $data['core_data'] = $this->load_site_core();
                $data['url_key'] = $url_key;
                
                $qry = $this->db->query("SELECT id FROM news_type WHERE url = ? LIMIT 1", array($url_key));
                $news_type_data = $qry->row_array();
                $news_type_id = $news_type_data['id'];

                $qry = $this->db->query("SELECT id, news_type_id, title_ar, thumb, pdf, DATE_FORMAT(news_date, '%d %M, %Y') as news_date, external_link FROM news WHERE news_type_id = ? and lang_filter IN (1,3) ORDER BY id DESC", array($news_type_id));
                $data['news_list'] = $qry->result_array();

                $this->load->view('news_list', $data);
            }
        } else {        
            $data['core_data'] = $this->load_site_core();
            $data['parent_link'] = '';
            $qry = $this->db->query("SELECT page_id FROM links_data WHERE link_id = (SELECT parent_id FROM links_data WHERE page_id = ? LIMIT 1)", array($data["core_data"]["page_data"]["page_data_id"]));
            $parent_info = $qry->row_array();
            if (count($parent_info) > 0 && $parent_info["page_id"] != 0) {
                $qry = $this->db->query("SELECT title, page_url FROM pages_data WHERE page_data_id = ?", array($parent_info["page_id"]));
                $title_data = $qry->row_array();
                $data['parent_link'] = '<li><a href="'.BASE_URL.htmlspecialchars($title_data["page_url"], ENT_QUOTES, 'UTF-8').'">'.htmlspecialchars($title_data["title"], ENT_QUOTES, 'UTF-8').'</a></li>';
            }

            $qry = $this->db->query("SELECT * FROM form_data WHERE page_id = ? LIMIT 1", array($data["core_data"]["page_data"]["page_data_id"]));
            $result_data = $qry->row_array();

            if (count($result_data) > 0) {
                $data['core_data']['form_data'] = $result_data;
            }

            $this->load->view('txt_page', $data);
        }
    }

    public function certificates()
    {
        $data['core_data'] = $this->load_site_core();
        $qry = $this->db->query("SELECT * FROM certificates ORDER BY id DESC");
        $data['certificates_list'] = $qry->result_array();
        $this->load->view('certificates', $data);    
    }

    public function trainee($trainee_id)
    {
        $trainee_id = (int) $trainee_id;
        $data['core_data'] = $this->load_site_core();
        $qry = $this->db->query("SELECT * FROM trainee WHERE id = ?", array($trainee_id));
        $data['trainee_info'] = $qry->row_array();
        $qry = $this->db->query("SELECT id, trainee_id, cert_name, DATE_FORMAT(cert_date, '%d %M, %Y') as cert_date FROM certificates WHERE trainee_id = ?", array($trainee_id));
        $data['certificates_list'] = $qry->result_array();
        $this->load->view('trainee', $data);         
    }

    public function show_page($page)
    {
        $data['core_data'] = $this->load_site_core();
        $this->load->view($page, $data);        
    }
    
    public function logout()
    {
        if (isset($_SESSION['loginUser '])) {
            unset($_SESSION['loginUser ']);
            unset($_SESSION['loginUser Name']);
            header('location:'.BASE_URL);
        }
    }

    public function login_process()
    {
        if (isset($_SESSION['max_attempts']) && $_SESSION['max_attempts'] > MAX_FAILED_LOGIN) {
            if (isset($_POST['g-recaptcha-response']) && $_POST['g-recaptcha-response']) {
                $secret = "6LceIQgUAAAAACULSgeU7xyQTL5eWF07ngNHJW6R";
                $remote_ip = $_SERVER['REMOTE_ADDR'];
                $captcha = $_POST['g-recaptcha-response'];

                $ch = curl_init();
                curl_setopt($ch, CURLOPT_HEADER, 0);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_URL, "https://www.google.com/recaptcha/api/siteverify?secret=$secret&response=$captcha&remoteip=$remote_ip");
                $result_str = curl_exec($ch);
                curl_close($ch);
            
                $jresult = json_decode($result_str, TRUE);
                if (!$jresult['success']) {
                    http_response_code(400);
                    echo json_encode(['error' => 'failed-validation']);
                    exit;
                }
            } else {
                http_response_code(400);
                echo json_encode(['error' => 'failed-validation']);
                exit;
            }  
        }      

        $u_email = $this->db->escape_str(trim($_POST['u_email']));
        $u_email = filter_var($u_email, FILTER_SANITIZE_EMAIL);

        if (!filter_var($u_email, FILTER_VALIDATE_EMAIL)) {
            http_response_code(400);
            echo json_encode(['error' => 'invalidate_email']);
            exit;
        }

        $u_password = $this->db->escape_str(trim($_POST['u_password']));

        if (trim($u_password) != "") {
            $qry = $this->db->query("SELECT * FROM user_registration WHERE email_id = ? AND active_status = 1 LIMIT 1", array($u_email));
            $login_data = $qry->row_array();

            if (count($login_data) > 0) {
                $hashed_password = $login_data['u_password'];
                if (password_verify($u_password, $hashed_password)) {
                    $_SESSION['loginUser '] = $login_data['id'];
                    $_SESSION['loginUser Name'] = $login_data['name'];
                    unset($_SESSION['max_attempts']);
                    echo json_encode(['status' => 'login-success']);
                    exit;
                } else {
                    $this->handle_failed_login();
                } 
            } else {
                $this->handle_failed_login();
            }         
        }                   
    }

    private function handle_failed_login()
    {
        if (!isset($_SESSION['max_attempts'])) {
            $_SESSION['max_attempts'] = 1;   
        } else {
            $_SESSION['max_attempts']++;   
        }

        if ($_SESSION['max_attempts'] == MAX_FAILED_LOGIN) {
            echo json_encode(['error' => 'activate-captcha']);
        } else {
            echo json_encode(['error' => 'invalid-login']);
        }
        exit;
    }

    public function process_change_password()
    {
        if (!isset($_SESSION['loginUser '])) {
            http_response_code(403);
            echo json_encode(['error' => 'Unauthorized']);
            exit;
        }

        $old_password = $this->db->escape_str(trim($_POST['old_password']));
        $new_password = $this->db->escape_str(trim($_POST['new_password']));
        $confirm_password = $this->db->escape_str(trim($_POST['confirm_password']));

        $login_user_id = $_SESSION['loginUser '];
        $qry = $this->db->query("SELECT * FROM user_registration WHERE id = ? LIMIT 1", array($login_user_id));
        $login_data = $qry->row_array();   

        if (count($login_data) > 0) {
            $hashed_password = $login_data['u_password'];
            if (!password_verify($old_password, $hashed_password)) {
                echo json_encode(['error' => 'old_password_not_matched']);
                exit;
            } else {
                if ($new_password != "") {
                    $final_password = password_hash($new_password, PASSWORD_DEFAULT);
                    $qry = $this->db->query("UPDATE user_registration SET u_password = ? WHERE id = ?", array($final_password, $login_user_id));
                    if ($qry) {
                        echo json_encode(['status' => 'changed_success']);
                        exit;
                    }
                }                
            }
        }             
    }

    public function register_process()
    {
        if (isset($_POST['g-recaptcha-response']) && $_POST['g-recaptcha-response']) {
            $secret = "6LceIQgUAAAAACULSgeU7xyQTL5eWF07ngNHJW6R";
            $remote_ip = $_SERVER['REMOTE_ADDR'];
            $captcha = $_POST['g-recaptcha-response'];
            
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_HEADER, 0);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_URL, "https://www.google.com/recaptcha/api/siteverify?secret=$secret&response=$captcha&remoteip=$remote_ip");
            $result_str = curl_exec($ch);
            curl_close($ch);

            $jresult = json_decode($result_str, TRUE);
            if (!$jresult['success']) {
                http_response_code(400);
                echo json_encode(['error' => 'failed-validation']);
                exit;
            }
        }
                
        $u_email = $this->db->escape_str(trim($_POST['u_email']));
        $u_email = filter_var($u_email, FILTER_SANITIZE_EMAIL);

        if (!filter_var($u_email, FILTER_VALIDATE_EMAIL)) {
            http_response_code(400);
            echo json_encode(['error' => 'invalidate_email']);
            exit;
        }

        $u_password = $this->db->escape_str(trim($_POST['u_password']));
        $u_confirm_password = $this->db->escape_str(trim($_POST['u_confirm_password']));

        if (trim($u_password) != "" && ($u_password == $u_confirm_password)) {
            $hash_password = password_hash($u_password, PASSWORD_DEFAULT);
        } else {
            echo json_encode(['error' => 'password_not_matched']);
            exit;
        }

        $u_name = $this->db->escape_str(trim($_POST['u_name']));
        $u_gender = $this->db->escape_str(trim($_POST['u_gender']));        

        if ($u_name != "" && $u_gender != "" && $u_email != "") {
            $qry = $this->db->query("SELECT id FROM user_registration WHERE email_id = ?", array($u_email));
            $result_data = $qry->row_array();

            if (count($result_data) > 0) {
                echo json_encode(['error' => 'record_exists']);
                exit;
            }

            $salt = uniqid();
            $qry = $this->db->query("INSERT INTO user_registration SET name=?, gender=?, email_id=?, salt=?, u_password=?, created_on=NOW(), active_status=0", array($u_name, $u_gender, $u_email, $salt, $hash_password));
            if ($qry) {
                $mail_title = 'Confirmation Link from ASAS Video On Demand';
                $insert_id = $this->db->insert_id();
                $crypt_key = $insert_id.$salt;
                $final_crypt_key = password_hash($crypt_key, PASSWORD_DEFAULT);
                $final_crypt_key = urlencode($final_crypt_key);
                $mail_msg = '<a target="_blank" href="'.BASE_URL.'user-activation/'.$insert_id.'/'.$final_crypt_key.'">Click here for activation</a>';
                $this->send_email($u_email, $u_name, $mail_title, $mail_msg);
            }
        }
    }

    public function user_activation($user_id, $encrypt_string)
    {
        $user_id = (int) $user_id;
        $qry = $this->db->query("SELECT id, salt FROM user_registration WHERE id = ?", array($user_id));
        $user_data = $qry->row_array();        

        $key = $user_id.$user_data['salt'];
        $encrypt_string = urldecode($encrypt_string);

        if (password_verify($key, $encrypt_string)) {
            $qry = $this->db->query("UPDATE user_registration SET active_status = 1 WHERE id = ?", array($user_id));
            header('location:'.BASE_URL.'login?verify=1');
        }        
    }

    public function contact()
    {
        $data['core_data'] = $this->load_site_core();                
        $this->load->view('contact', $data);                
    }

    public function your_opinion()
    {
        $data['core_data'] = $this->load_site_core();                
        $this->load->view('your_opinion', $data);         
    }

    public function form_builder_process()
    {
        $sec_code_ul = $this->input->post("sec_code");
        $captcha_code = trim($_SESSION['captcha']);  
        
        if ($sec_code_ul != $captcha_code || $captcha_code == "") {
            $_SESSION['captcha'] = "";
            echo json_encode(['error' => 'invalid_captcha']);
            return false;
        }
        
        $page_id = (int) $_POST["page_id"];
        $qry = $this->db->query("SELECT table_name FROM form_data WHERE page_id = ?", array($page_id));
        $table_name_data = $qry->row_array();
        $table_name = $table_name_data["table_name"];

        unset($_POST['page_id']);
        unset($_POST['sec_code']);

        foreach ($_POST as $p_key => $p_val) {            
            if (is_array($p_val)) {
                $p_val = implode(', ', $p_val);
            }
            
            $p_key = $this->db->escape_str($p_key);            
            $p_val = $this->db->escape_str($p_val);                
            $_POST[$p_key] = $p_val;            
        }
          
        $this->db->insert($table_name, $_POST); 
        $insert_id = $this->db->insert_id();            
        echo json_encode(['insert_id' => $insert_id]);
    }

    public function show_all_people()
    {
        $qry = $this->db->query("SELECT * FROM people LIMIT 1000");
        $data['staff_list'] = $qry->result_array();

        $data['core_data'] = $this->load_site_core();

        $this->load->view('people', $data);
    }

    public function people($people_id)
    {
        $people_id = (int) $people_id;

        $qry = $this->db->query("SELECT * FROM people WHERE id = ? LIMIT 1", array($people_id));
        $data['people'] = $qry->row_array();
        $data['people_id'] = $people_id;

        $data['core_data'] = $this->load_site_core();

        $data['core_data']['page_data']['title'] = htmlspecialchars($data['people']['name'], ENT_QUOTES, 'UTF-8');
        $this->load->view('people', $data);
    }

    public function search()
    {
        $s_query = $this->db->escape_str($this->input->get('sq'));
        $sq_type = $this->db->escape_str($this->input->get('sq_type'));
        $data['core_data'] = $this->load_site_core();   

        // تصفية المدخلات لمنع XSS
        $s_query = strip_tags($s_query); // إزالة أي علامات HTML
        $s_query = htmlspecialchars($s_query, ENT_QUOTES, 'UTF-8'); // تشفير المدخلات

        if ($sq_type == "people") {
            $data['search_result_arr'] = array();
            if (isset($s_query) && trim($s_query) != "") {            
                $qry = $this->db->query("SELECT * FROM people WHERE name LIKE ? OR name_ar LIKE ? OR keywords LIKE ?", array('%'.$s_query.'%', '%'.$s_query.'%', '%'.$s_query.'%'));
                $data['search_result_arr'] = $qry->result_array();
                if (count($data['search_result_arr']) == 0) {
                    $data['search_result_msg'] = '<h2> No results found </h2>';
                } 
            } else {
                $data['search_result_msg'] = '<h2> Search term can not be empty </h2>';
            }                       
        } else if ($sq_type == "certificates") {
            $data['search_result_arr'] = array();
            if (isset($s_query) && trim($s_query) != "") {            
                $qry = $this->db->query("SELECT * FROM certificates WHERE trainee_id LIKE ? OR cert_id LIKE ? OR cert_name LIKE ?", array('%'.$s_query.'%', '%'.$s_query.'%', '%'.$s_query.'%'));
                $data['search_result_arr'] = $qry->result_array();
                if (count($data['search_result_arr']) == 0) {
                    $data['search_result_msg'] = '<h2> No results found </h2>';
                } 
            } else {
                $data['search_result_msg'] = '<h2> Search term can not be empty </h2>';
            }                       
        } else {
            $data['search_result_arr'] = array();
            if (isset($s_query) && trim($s_query) != "") {
                $qry = $this->db->query("SELECT title_ar, page_url FROM pages_data WHERE (title_ar LIKE ? OR MATCH(description, description_ar) AGAINST (?)) AND page_url NOT IN ('download_file', 'search')", array('%'.$s_query.'%', $s_query));
                $data['search_result_arr'] = $qry->result_array();
                
                $qry = $this->db->query("SELECT title_ar, CONCAT('news/', id) as page_url FROM news WHERE (title_ar LIKE ? OR MATCH(description, description_ar) AGAINST (?))", array('%'.$s_query.'%', $s_query));   
                $data['search_result_arr'] = array_merge($data['search_result_arr'], $qry->result_array());                
                if (count($data['search_result_arr']) == 0) {
                    $data['search_result_msg'] = '<h2> No results found </h2>';
                }                    
            } else {
                $data['search_result_msg'] = '<h2> Search term can not be empty </h2>';
            }
        }

        $this->load->view('search', $data);        
    }  

    public function contact_process()
    {       
        $this->load->helper('email');

        $u_name = $this->input->post("c_name");
        $u_email = $this->input->post("c_email");
        $u_mobile = $this->input->post("c_mobile");
        $u_company = '';
        if (isset($_POST["c_company"])) {
            $u_company = '<tr>
                            <td style="vertical-align:top;border:1px solid #aaaaaa;padding:10px;border-collapse:collapse;font-weight:bold;color:#000000;background-color:#eeeeee;">Company </td>
                            <td style="vertical-align:top;border:1px solid #aaaaaa;padding:10px;border-collapse:collapse;">'.htmlspecialchars($this->input->post("c_company"), ENT_QUOTES, 'UTF-8').'</td>
                        </tr>';
        }
        $u_desc = $this->input->post("c_message");
        $sec_code_ul = $this->input->post("sec_code");
        $captcha_code = trim($_SESSION['captcha']);

        if (trim($u_name) == "") {
            echo json_encode(['error' => 'name_not_blank']);
            return false;
        }

        if (!valid_email($u_email)) {
            echo json_encode(['error' => 'Email is Invalid']);
            return false;
        }                            

        if ($sec_code_ul != $captcha_code || $captcha_code == "") {
            $_SESSION['captcha'] = "";
            echo json_encode(['error' => 'invalid_captcha']);
            return false;
        }

        $_SESSION['captcha'] = "";
        $mail_msg = '<table width="700" cellpadding="0" cellspacing="0" style="font-family:arial,verdana;font-size:13px;color:#555555;line-height:22px;border-collapse:collapse;">    
                            <tbody>
                                    <tr>
                                            <td style="padding:10px;border-collapse:collapse;font-weight:bold;color:#000000;background-color:#eeeeee;vertical-align:top;border:1px solid #aaaaaa;" width="140"> Contact Name </td>
                                            <td style="padding:10px;border-collapse:collapse;vertical-align:top;border:1px solid #aaaaaa;">'.htmlspecialchars($u_name, ENT_QUOTES, 'UTF-8').'</td>
                                    </tr>                   
                                    <tr>
                                            <td style="vertical-align:top;border:1px solid #aaaaaa;padding:10px;border-collapse:collapse;font-weight:bold;color:#000000;background-color:#eeeeee;" width="140">Email</td>
                                            <td style="vertical-align:top;border:1px solid #aaaaaa;padding:10px;border-collapse:collapse;">'.htmlspecialchars($u_email, ENT_QUOTES, 'UTF-8').'</td>
                                    </tr>
                                    <tr>
                                            <td style="vertical-align:top;border:1px solid #aaaaaa;padding:10px;border-collapse:collapse;font-weight:bold;color:#000000;background-color:#eeeeee;">Mobile No. </td>
                                            <td style="vertical-align:top;border:1px solid #aaaaaa;padding:10px;border-collapse:collapse;">'.htmlspecialchars($u_mobile, ENT_QUOTES, 'UTF-8').'</td>
                                    </tr>
                                    '.$u_company.'
                                    <tr>
                                            <td colspan="2" style="padding:0px;"> 
                                                    <div style="width:100%;"> 
                                                            <br/>
                                                            <table cellpadding="0" cellspacing="0" style="width:100%;font-family:arial,verdana;font-size:13px;color:#555555;line-height:22px;border-collapse:collapse;">
                                                                    <tbody>
                                                                            <tr>
                                                                                    <td style="padding:10px;border-collapse:collapse;font-weight:bold;color:#000000;background-color:#eeeeee;text-align:left;border-top:1px solid #aaaaaa;border-bottom:1px solid #aaaaaa;" colspan="2">User   Query</td>
                                                                            </tr>
                                                                            <tr>
                                                                                    <td style="padding:10px;border-collapse:collapse;" colspan="2">'.htmlspecialchars($u_desc, ENT_QUOTES, 'UTF-8').'</td>
                                                                            </tr>                               
                                                                    </tbody>
                                                            </table>
                                                    </div>  
                                            </td>
                                    </tr>

                            </tbody>
                    </table>';
        
        if (isset($_POST["opinion"]) && $_POST["opinion"] == 1) {
            $mail_title = 'Opinion Email | Oil and Gas University';
        } else {
            $mail_title = 'Oil and Gas University | Enquiry Email';    
        }         

        $this->load->library('email');
        $config['mailtype'] = 'html';
        $config['wordwrap'] = TRUE;
        $this->email->initialize($config);  
        
        $this->email->from(EMAIL_SENDER, htmlspecialchars($u_name, ENT_QUOTES, 'UTF-8'));              
        $this->email->to(EMAIL_RECIPIENT); 
        $this->email->subject($mail_title);
        $this->email->message($mail_msg);
        $this->email->send();                
    }

    public function download_file()
    {
        $file_name = $this->input->get('file_name');
        $file_name = urldecode($file_name);
        
        // تحقق من أن الملف هو PDF فقط
        $file_extension = pathinfo($file_name, PATHINFO_EXTENSION);
        if (strtolower($file_extension) !== 'pdf') {
            http_response_code(400);
            echo json_encode(['error' => 'Invalid file type. Only PDF files are allowed.']);
            return;
        }

        $file_fs = substr($file_name, 0, 1);
        if ($file_fs == "/") {
            $file_name = $_SERVER['DOCUMENT_ROOT'].$file_name;                
        } else {
            $file_name = realpath(getcwd().'/'.$file_name);
        }

        $file_name = str_replace(array("../",".."), "", $file_name);
        $save_name = str_replace(" ", "", basename($file_name));
        
        if (file_exists($file_name)) {
            header('Content-Description: File Transfer');
            header('Content-Type: application/pdf');
            header('Content-Disposition: attachment; filename='.basename($save_name));
            header('Expires: 0');
            header('Cache-Control: must-revalidate');
            header('Pragma: public');
            header('Content-Length: ' . filesize($file_name));
            readfile($file_name);
            exit;
        } else {
            http_response_code(404);
            echo json_encode(['error' => 'File not found.']);
        }                
    }       
}