<?php $this->load->view('inc_files/site_header', $core_data); ?>
<div class="breadcrumbs">
    <div class="container">
        <h1 class="pull-left"><?php echo htmlspecialchars($core_data['page_data']['title_ar'], ENT_QUOTES, 'UTF-8'); ?></h1>
        <ul class="pull-right breadcrumb">
            <li><a href="<?php echo BASE_URL; ?>">الرئيسية</a></li>
            <li class="active"><?php echo htmlspecialchars($core_data['page_data']['title_ar'], ENT_QUOTES, 'UTF-8'); ?></li>
        </ul>
    </div>
</div>
<div class="container pg_min_ht">
<?php
    // تصفية المدخلات من GET
    $sq_type = isset($_GET['sq_type']) ? htmlspecialchars($_GET['sq_type'], ENT_QUOTES, 'UTF-8') : '';
    $search_query = isset($_GET['sq']) ? htmlspecialchars($_GET['sq'], ENT_QUOTES, 'UTF-8') : '';

    if ($sq_type == "web"):
?>
    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
        <?php                
            if (count($search_result_arr) > 0) {
                echo '<ol class="search_list"> ';
                foreach ($search_result_arr as $key => $search_row) {
                    ?>
                    <li>
                        <h4 class="search_title"><a href="<?php echo BASE_URL . htmlspecialchars($search_row["page_url"], ENT_QUOTES, 'UTF-8'); ?>"><?php echo htmlspecialchars($search_row["title_ar"], ENT_QUOTES, 'UTF-8'); ?></a></h4>
                        <div class="search_url"><a href="<?php echo BASE_URL . htmlspecialchars($search_row["page_url"], ENT_QUOTES, 'UTF-8'); ?>"><?php echo BASE_URL . htmlspecialchars($search_row["page_url"], ENT_QUOTES, 'UTF-8'); ?></a></div>
                    </li>                            
                    <?php                             
                }
                echo '</ol>';       
            } else {
                echo '<h4>No results found for <span class="search" style="text-decoration:underline;">' . $search_query . '</span></h4>';
            }
        ?>            
    </div>
<?php
    endif;
?>
<?php
    if ($sq_type == "people"):
?>
        <?php                
            if (count($search_result_arr) > 0) {
                foreach ($search_result_arr as $key => $search_row) {
                    ?>
                    <div class="row search_result_people">
                        <div class="col-md-2 col-sm-3 col-xs-12">
                            <img src="<?php echo BASE_URL . 'uploads/people/' . htmlspecialchars($search_row["thumb"], ENT_QUOTES, 'UTF-8'); ?>" alt="" class="img-responsive">
                        </div>
                        <div class="col-md-10 col-sm-9 col-xs-12">
                            <h1><?php echo htmlspecialchars($search_row["name_ar"], ENT_QUOTES, 'UTF-8'); ?></h1>
                            <p><?php echo htmlspecialchars(substr(strip_tags($search_row["description_ar"]), 0, 280), ENT_QUOTES, 'UTF-8') . '......'; ?></p>
                            <a href="<?php echo BASE_URL . 'people/' . htmlspecialchars($search_row['id'], ENT_QUOTES, 'UTF-8'); ?>" class="btn btn-sm btn-primary">See Full Information</a>
                        </div>
                    </div>
                    <?php                             
                }
            } else {
                echo '<h4>No results found for <span class="search" style="text-decoration:underline;">' . $search_query . '</span></h4>';
            }
        ?>            
<?php
    endif;
?>

<?php
    if ($sq_type == "certificates"):
?>
        <?php                
            if (count($search_result_arr) > 0) {
                foreach ($search_result_arr as $certificate) {
                    ?>
                    <div class="certificate_block">
                        <h1>Certificate ID: <?php echo htmlspecialchars($certificate["cert_id"], ENT_QUOTES, 'UTF-8'); ?> </h1>
                        <h2>Certificate Name: <?php echo htmlspecialchars($certificate["cert_name"], ENT_QUOTES, 'UTF-8'); ?></h2>
                        <h3> By Trainee ID: <?php echo htmlspecialchars($certificate["trainee_id"], ENT_QUOTES, 'UTF-8'); ?></h3>
                        <a href="<?php echo BASE_URL . 'trainee/' . htmlspecialchars($certificate["trainee_id"], ENT_QUOTES, 'UTF-8'); ?>" class="btn btn-md btn-success">View Trainee Profile &amp; Certificates</a>
                    </div>
                    <?php                             
                }
            } else {
                echo '<h4>No results found for <span class="search" style="text-decoration:underline;">' . $search_query . '</span></h4>';
            }
        ?>            
<?php
    endif;
?>
</div>
<?php $this->load->view('inc_files/site_footer', $core_data); ?>