<?php
include 'dbh.inc.php';
$stat = $conn->prepare("SELECT `dprtexams`.*, `courses`.`stage` FROM `dprtexams` INNER JOIN `courses` ON (`dprtexams`.`course` = `courses`.`id`) WHERE `dprtexams`.`college` = ? AND `dprtexams`.`department` = ?");
$postdata = file_get_contents("php://input");
$_POST = json_decode($postdata, true);

$college = $_POST['college'];
$department = $_POST['department'];

$stat->bind_param("ii", $college, $department);
$stat->execute();
$result = $stat->get_result();

$courses = array();

while($course = $result->fetch_assoc()){
    array_push($courses, $course);
}

$stat2 = $conn->prepare("SELECT * FROM `dprtexams` WHERE `college`=? AND `department`=? AND `type`='حضوري'");
$stat2->bind_param("ii", $college, $department);
$stat2->execute();
$stat2->store_result();
$rexams = $stat2->num_rows;

$res = array(
    'courses' => $courses,
    'rexams' => $rexams
);
echo json_encode($res);

$stat->close();
$conn->close();

?>