$(document).ready(function()
{	
    function validate_field()
    {
        $('.frm_error_line', $(this).parent()).remove();
        var cur_field_val = $.trim($(this).val());
        if(cur_field_val == "")
        {
          has_errors = 1;
          $('<div class="frm_error_line">Please fill the above field</div>').appendTo($(this).parent());  
        }

        if($(this).hasClass('email_valid') && cur_field_val != "")
        {
            var x=cur_field_val;
            var atpos=x.indexOf("@");
            var dotpos=x.lastIndexOf(".");
            if (atpos<1 || dotpos<atpos+2 || dotpos+2>=x.length)
            {
              has_errors = 1;              
              $('<div class="frm_error_line">E-mail is not valid</div>').appendTo($(this).parent());  
            }             
        }        
    }

    function validate_frm()
    {     
      has_errors = 0; 
      $('.frm_error_line').remove();
      $('.not_blank').each(validate_field);

      return has_errors;
    }

    $('.not_blank').focusout(validate_field);

    $("#register_frm").submit(function()
    {
      var has_errors = validate_frm();
      if(has_errors == 1)
      {
        return false;
      }

      var u_password = $("#u_password").val();
      u_password = $.trim(u_password);
      var u_confirm_password = $("#u_confirm_password").val();
      u_confirm_password = $.trim(u_confirm_password);

      if(u_password != u_confirm_password)
      {
        alert("Password and Confirm Password are not matched \n Please fill these again");
        $("#u_password").val('');
        $("#u_confirm_password").val('');
        $("#u_password")[0].focus();
        return false;
      }

      var captcha_response = grecaptcha.getResponse();
      if(captcha_response.length == 0 || captcha_response == "" || captcha_response == undefined)
      {
        alert("Please check I'm not Robot");
        return false;
      }

      var register_frm_data = $("#register_frm").serialize();
      register_frm_data = register_frm_data+'&g-recaptcha-response='+grecaptcha.getResponse();

      $("#registerBtn").bsbutton('loading');
      $.ajax({
        url: base_url+'register/process',
        type:'POST',
        data: register_frm_data,
        success: function(result_data)
        {
          $("#registerBtn").bsbutton('reset');

          if(result_data == "failed-validation")
          {
            alert("Please check again I'm not Robot");
            grecaptcha.reset();
          }
          else if(result_data == "record_exists")
          {
            alert("User already exists with this E-mail ID");
          }
          else if(result_data == "invalidate_email")
          {
            alert("E-mail is not valid");           
          }
          else if(result_data == "password_not_matched")
          {
            alert("Password not matched \n Please fill again");
          }
          else{
            window.location.href = base_url+'register-success';
          }          
        }
      });
      return false;
    });

    $("#loginFrm").submit(function()
    {
      var has_errors = validate_frm();
      if(has_errors == 1)
      {
        return false;
      }

      var login_frm_data = $("#loginFrm").serialize();
      if($("#loginCaptchaCnt").css('display') != "none")
      {
        login_frm_data = login_frm_data+'&g-recaptcha-response='+grecaptcha.getResponse();
      }

      $("#loginBtn").bsbutton('loading');
      $.ajax({
        url: base_url+'login/process',
        type:'POST',
        data: login_frm_data,
        success: function(result_data)
        {
          $("#loginBtn").bsbutton('reset');

          if(result_data == "failed-validation")
          {
            $("#loginCaptchaCnt").css({'display':'block'});
            alert("Please check I'm not Robot");
            grecaptcha.reset();
          }
          else if(result_data == "invalid-login")
          {
            alert("Username / Password is incorrect");
            if($("#loginCaptchaCnt").css('display') != "none")
            {            
              grecaptcha.reset();            
            }
          }
          else if(result_data == "activate-captcha")
          {
            $("#loginCaptchaCnt").css({'display':'block'});
          } 
          else if(result_data == "no_user")
          {
            alert("User not exists or Account activation pending.");
            if($("#loginCaptchaCnt").css('display') != "none")
            {            
              grecaptcha.reset();            
            }
          }           
          else if(result_data == "login-success")
          {
            window.location.href = base_url;
          }          
          else{
            //window.location.href = base_url+'dashboard';
          }          
        }
      });      
      return false;
    }); 

  $("#changePasswordFrm").submit(function()
  {
        var has_errors = validate_frm();
        if(has_errors == 1)
        {
          return false;
        }
          
    var new_password = $.trim($("#new_password").val());
    var confirm_password = $.trim($("#confirm_password").val());
    
    if(new_password != confirm_password)
    {
      alert("New Password and Confirm New Password not matched. \n Please fill again");
      $("#new_password").val('');
      $("#confirm_password").val('');
      return false;
    }
    var changePasswordFrmData = $("#changePasswordFrm").serialize();
    $("#changePasswordBtn").bsbutton('loading');
    $.ajax({
      url:base_url+'process_change_password',
      type: 'POST',
      data: changePasswordFrmData,
      success: function(result_data)
      {
        $("#changePasswordBtn").bsbutton('reset');

        if(result_data == "old_password_not_matched")
        {
          alert("Old Password not matched");
          $("#old_password").val('');
          return false;
        }
        else if(result_data == "changed_success")
        {
          alert("Your Password has been changed successfully.");
          window.location.href = base_url+'logout';
        }

      }
    });
    return false;
  });    	
});