<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg10.php" ?>
<?php include_once "ewmysql10.php" ?>
<?php include_once "phpfn10.php" ?>
<?php include_once "news_picturesinfo.php" ?>
<?php include_once "_logininfo.php" ?>
<?php include_once "newsinfo.php" ?>
<?php include_once "userfn10.php" ?>
<?php

//
// Page class
//

$news_pictures_edit = NULL; // Initialize page object first

class cnews_pictures_edit extends cnews_pictures {

	// Page ID
	var $PageID = 'edit';

	// Project ID
	var $ProjectID = "{12440D03-277E-47C7-ADF1-950F71C707AB}";

	// Table name
	var $TableName = 'news_pictures';

	// Page object name
	var $PageObjName = 'news_pictures_edit';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-error ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<table class=\"ewStdTable\"><tr><td><div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div></td></tr></table>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language, $UserAgent;

		// User agent
		$UserAgent = ew_UserAgent();
		$GLOBALS["Page"] = &$this;

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (news_pictures)
		if (!isset($GLOBALS["news_pictures"])) {
			$GLOBALS["news_pictures"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["news_pictures"];
		}

		// Table object (_login)
		if (!isset($GLOBALS['_login'])) $GLOBALS['_login'] = new c_login();

		// Table object (news)
		if (!isset($GLOBALS['news'])) $GLOBALS['news'] = new cnews();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'edit', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'news_pictures', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect();
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login.php");
		}

		// Create form object
		$objForm = new cFormObj();
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up curent action
		$this->id->Visible = !$this->IsAdd() && !$this->IsCopy() && !$this->IsGridAdd();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $conn;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();
		$this->Page_Redirecting($url);

		 // Close connection
		$conn->Close();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}
	var $DbMasterFilter;
	var $DbDetailFilter;
	var $DisplayRecs = 1;
	var $StartRec;
	var $StopRec;
	var $TotalRecs = 0;
	var $RecRange = 10;
	var $Pager;
	var $RecCnt;
	var $RecKey = array();
	var $Recordset;

	// 
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError;

		// Load current record
		$bLoadCurrentRecord = FALSE;
		$sReturnUrl = "";
		$bMatchRecord = FALSE;

		// Load key from QueryString
		if (@$_GET["id"] <> "") {
			$this->id->setQueryStringValue($_GET["id"]);
			$this->RecKey["id"] = $this->id->QueryStringValue;
		} else {
			$bLoadCurrentRecord = TRUE;
		}

		// Set up master detail parameters
		$this->SetUpMasterParms();

		// Set up Breadcrumb
		$this->SetupBreadcrumb();

		// Load recordset
		$this->StartRec = 1; // Initialize start position
		if ($this->Recordset = $this->LoadRecordset()) // Load records
			$this->TotalRecs = $this->Recordset->RecordCount(); // Get record count
		if ($this->TotalRecs <= 0) { // No record found
			if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
				$this->setFailureMessage($Language->Phrase("NoRecord")); // Set no record message
			$this->Page_Terminate("news_pictureslist.php"); // Return to list page
		} elseif ($bLoadCurrentRecord) { // Load current record position
			$this->SetUpStartRec(); // Set up start record position

			// Point to current record
			if (intval($this->StartRec) <= intval($this->TotalRecs)) {
				$bMatchRecord = TRUE;
				$this->Recordset->Move($this->StartRec-1);
			}
		} else { // Match key values
			while (!$this->Recordset->EOF) {
				if (strval($this->id->CurrentValue) == strval($this->Recordset->fields('id'))) {
					$this->setStartRecordNumber($this->StartRec); // Save record position
					$bMatchRecord = TRUE;
					break;
				} else {
					$this->StartRec++;
					$this->Recordset->MoveNext();
				}
			}
		}

		// Process form if post back
		if (@$_POST["a_edit"] <> "") {
			$this->CurrentAction = $_POST["a_edit"]; // Get action code
			$this->LoadFormValues(); // Get form values
		} else {
			$this->CurrentAction = "I"; // Default action is display
		}

		// Validate form if post back
		if (@$_POST["a_edit"] <> "") {
			if (!$this->ValidateForm()) {
				$this->CurrentAction = ""; // Form error, reset action
				$this->setFailureMessage($gsFormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->RestoreFormValues();
			}
		}
		switch ($this->CurrentAction) {
			case "I": // Get a record to display
				if (!$bMatchRecord) {
					if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
						$this->setFailureMessage($Language->Phrase("NoRecord")); // Set no record message
					$this->Page_Terminate("news_pictureslist.php"); // Return to list page
				} else {
					$this->LoadRowValues($this->Recordset); // Load row values
				}
				break;
			Case "U": // Update
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->EditRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->Phrase("UpdateSuccess")); // Update success
					$sReturnUrl = $this->getReturnUrl();
					if (ew_GetPageName($sReturnUrl) == "news_picturesview.php")
						$sReturnUrl = $this->GetViewUrl(); // View paging, return to View page directly
					$this->Page_Terminate($sReturnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->RestoreFormValues(); // Restore form values if update failed
				}
		}

		// Render the record
		$this->RowType = EW_ROWTYPE_EDIT; // Render as Edit
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Set up starting record parameters
	function SetUpStartRec() {
		if ($this->DisplayRecs == 0)
			return;
		if ($this->IsPageRequest()) { // Validate request
			if (@$_GET[EW_TABLE_START_REC] <> "") { // Check for "start" parameter
				$this->StartRec = $_GET[EW_TABLE_START_REC];
				$this->setStartRecordNumber($this->StartRec);
			} elseif (@$_GET[EW_TABLE_PAGE_NO] <> "") {
				$PageNo = $_GET[EW_TABLE_PAGE_NO];
				if (is_numeric($PageNo)) {
					$this->StartRec = ($PageNo-1)*$this->DisplayRecs+1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1) {
						$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif (intval($this->StartRec) > intval($this->TotalRecs)) { // Avoid starting record > total records
			$this->StartRec = intval(($this->TotalRecs-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec-1) % $this->DisplayRecs <> 0) {
			$this->StartRec = intval(($this->StartRec-1)/$this->DisplayRecs)*$this->DisplayRecs+1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	function GetUploadFiles() {
		global $objForm;

		// Get upload data
		$this->small_pic->Upload->Index = $objForm->Index;
		if ($this->small_pic->Upload->UploadFile()) {

			// No action required
		} else {
			echo $this->small_pic->Upload->Message;
			$this->Page_Terminate();
			exit();
		}
		$this->small_pic->CurrentValue = $this->small_pic->Upload->FileName;
		$this->large_pic->Upload->Index = $objForm->Index;
		if ($this->large_pic->Upload->UploadFile()) {

			// No action required
		} else {
			echo $this->large_pic->Upload->Message;
			$this->Page_Terminate();
			exit();
		}
		$this->large_pic->CurrentValue = $this->large_pic->Upload->FileName;
	}

	// Load form values
	function LoadFormValues() {

		// Load from form
		global $objForm;
		$this->GetUploadFiles(); // Get upload files
		if (!$this->id->FldIsDetailKey)
			$this->id->setFormValue($objForm->GetValue("x_id"));
		if (!$this->fr_id->FldIsDetailKey) {
			$this->fr_id->setFormValue($objForm->GetValue("x_fr_id"));
		}
	}

	// Restore form values
	function RestoreFormValues() {
		global $objForm;
		$this->LoadRow();
		$this->id->CurrentValue = $this->id->FormValue;
		$this->fr_id->CurrentValue = $this->fr_id->FormValue;
	}

	// Load recordset
	function LoadRecordset($offset = -1, $rowcnt = -1) {
		global $conn;

		// Call Recordset Selecting event
		$this->Recordset_Selecting($this->CurrentFilter);

		// Load List page SQL
		$sSql = $this->SelectSQL();
		if ($offset > -1 && $rowcnt > -1)
			$sSql .= " LIMIT $rowcnt OFFSET $offset";

		// Load recordset
		$rs = ew_LoadRecordset($sSql);

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	function LoadRow() {
		global $conn, $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		global $conn;
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->id->setDbValue($rs->fields('id'));
		$this->fr_id->setDbValue($rs->fields('fr_id'));
		$this->small_pic->Upload->DbValue = $rs->fields('small_pic');
		$this->large_pic->Upload->DbValue = $rs->fields('large_pic');
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->fr_id->DbValue = $row['fr_id'];
		$this->small_pic->Upload->DbValue = $row['small_pic'];
		$this->large_pic->Upload->DbValue = $row['large_pic'];
	}

	// Render row values based on field settings
	function RenderRow() {
		global $conn, $Security, $Language;
		global $gsLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// fr_id
		// small_pic
		// large_pic

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// fr_id
			if (strval($this->fr_id->CurrentValue) <> "") {
				$sFilterWrk = "`id`" . ew_SearchString("=", $this->fr_id->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `id`, `title` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `news`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->fr_id, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->fr_id->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->fr_id->ViewValue = $this->fr_id->CurrentValue;
				}
			} else {
				$this->fr_id->ViewValue = NULL;
			}
			$this->fr_id->ViewCustomAttributes = "";

			// small_pic
			$this->small_pic->UploadPath = "../uploads/projects/small";
			if (!ew_Empty($this->small_pic->Upload->DbValue)) {
				$this->small_pic->ImageAlt = $this->small_pic->FldAlt();
				$this->small_pic->ViewValue = ew_UploadPathEx(FALSE, $this->small_pic->UploadPath) . $this->small_pic->Upload->DbValue;
			} else {
				$this->small_pic->ViewValue = "";
			}
			$this->small_pic->ViewCustomAttributes = "";

			// large_pic
			$this->large_pic->UploadPath = "../uploads/projects/large";
			if (!ew_Empty($this->large_pic->Upload->DbValue)) {
				$this->large_pic->ImageAlt = $this->large_pic->FldAlt();
				$this->large_pic->ViewValue = ew_UploadPathEx(FALSE, $this->large_pic->UploadPath) . $this->large_pic->Upload->DbValue;
			} else {
				$this->large_pic->ViewValue = "";
			}
			$this->large_pic->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// fr_id
			$this->fr_id->LinkCustomAttributes = "";
			$this->fr_id->HrefValue = "";
			$this->fr_id->TooltipValue = "";

			// small_pic
			$this->small_pic->LinkCustomAttributes = "";
			$this->small_pic->HrefValue = "";
			$this->small_pic->HrefValue2 = $this->small_pic->UploadPath . $this->small_pic->Upload->DbValue;
			$this->small_pic->TooltipValue = "";

			// large_pic
			$this->large_pic->LinkCustomAttributes = "";
			$this->large_pic->HrefValue = "";
			$this->large_pic->HrefValue2 = $this->large_pic->UploadPath . $this->large_pic->Upload->DbValue;
			$this->large_pic->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// fr_id
			$this->fr_id->EditCustomAttributes = "";
			if ($this->fr_id->getSessionValue() <> "") {
				$this->fr_id->CurrentValue = $this->fr_id->getSessionValue();
			if (strval($this->fr_id->CurrentValue) <> "") {
				$sFilterWrk = "`id`" . ew_SearchString("=", $this->fr_id->CurrentValue, EW_DATATYPE_NUMBER);
			$sSqlWrk = "SELECT `id`, `title` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld` FROM `news`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->fr_id, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
				$rswrk = $conn->Execute($sSqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->fr_id->ViewValue = $rswrk->fields('DispFld');
					$rswrk->Close();
				} else {
					$this->fr_id->ViewValue = $this->fr_id->CurrentValue;
				}
			} else {
				$this->fr_id->ViewValue = NULL;
			}
			$this->fr_id->ViewCustomAttributes = "";
			} else {
			$sFilterWrk = "";
			$sSqlWrk = "SELECT `id`, `title` AS `DispFld`, '' AS `Disp2Fld`, '' AS `Disp3Fld`, '' AS `Disp4Fld`, '' AS `SelectFilterFld`, '' AS `SelectFilterFld2`, '' AS `SelectFilterFld3`, '' AS `SelectFilterFld4` FROM `news`";
			$sWhereWrk = "";
			if ($sFilterWrk <> "") {
				ew_AddFilter($sWhereWrk, $sFilterWrk);
			}

			// Call Lookup selecting
			$this->Lookup_Selecting($this->fr_id, $sWhereWrk);
			if ($sWhereWrk <> "") $sSqlWrk .= " WHERE " . $sWhereWrk;
			$rswrk = $conn->Execute($sSqlWrk);
			$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
			if ($rswrk) $rswrk->Close();
			array_unshift($arwrk, array("", $Language->Phrase("PleaseSelect"), "", "", "", "", "", "", ""));
			$this->fr_id->EditValue = $arwrk;
			}

			// small_pic
			$this->small_pic->EditCustomAttributes = "";
			$this->small_pic->UploadPath = "../uploads/projects/small";
			if (!ew_Empty($this->small_pic->Upload->DbValue)) {
				$this->small_pic->ImageAlt = $this->small_pic->FldAlt();
				$this->small_pic->EditValue = ew_UploadPathEx(FALSE, $this->small_pic->UploadPath) . $this->small_pic->Upload->DbValue;
			} else {
				$this->small_pic->EditValue = "";
			}
			if ($this->CurrentAction == "I" && !$this->EventCancelled) ew_RenderUploadField($this->small_pic);

			// large_pic
			$this->large_pic->EditCustomAttributes = "";
			$this->large_pic->UploadPath = "../uploads/projects/large";
			if (!ew_Empty($this->large_pic->Upload->DbValue)) {
				$this->large_pic->ImageAlt = $this->large_pic->FldAlt();
				$this->large_pic->EditValue = ew_UploadPathEx(FALSE, $this->large_pic->UploadPath) . $this->large_pic->Upload->DbValue;
			} else {
				$this->large_pic->EditValue = "";
			}
			if ($this->CurrentAction == "I" && !$this->EventCancelled) ew_RenderUploadField($this->large_pic);

			// Edit refer script
			// id

			$this->id->HrefValue = "";

			// fr_id
			$this->fr_id->HrefValue = "";

			// small_pic
			$this->small_pic->HrefValue = "";
			$this->small_pic->HrefValue2 = $this->small_pic->UploadPath . $this->small_pic->Upload->DbValue;

			// large_pic
			$this->large_pic->HrefValue = "";
			$this->large_pic->HrefValue2 = $this->large_pic->UploadPath . $this->large_pic->Upload->DbValue;
		}
		if ($this->RowType == EW_ROWTYPE_ADD ||
			$this->RowType == EW_ROWTYPE_EDIT ||
			$this->RowType == EW_ROWTYPE_SEARCH) { // Add / Edit / Search row
			$this->SetupFieldTitles();
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	function ValidateForm() {
		global $Language, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return ($gsFormError == "");
		if (!$this->fr_id->FldIsDetailKey && !is_null($this->fr_id->FormValue) && $this->fr_id->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->fr_id->FldCaption());
		}
		if (is_null($this->small_pic->Upload->Value)) {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->small_pic->FldCaption());
		}
		if (is_null($this->large_pic->Upload->Value)) {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->large_pic->FldCaption());
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsFormError, $sFormCustomError);
		}
		return $ValidateForm;
	}

	// Update record based on key values
	function EditRow() {
		global $conn, $Security, $Language;
		$sFilter = $this->KeyFilter();
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$conn->raiseErrorFn = 'ew_ErrorFn';
		$rs = $conn->Execute($sSql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$EditRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->LoadDbValues($rsold);
			$this->small_pic->OldUploadPath = "../uploads/projects/small";
			$this->small_pic->UploadPath = $this->small_pic->OldUploadPath;
			$this->large_pic->OldUploadPath = "../uploads/projects/large";
			$this->large_pic->UploadPath = $this->large_pic->OldUploadPath;
			$rsnew = array();

			// fr_id
			$this->fr_id->SetDbValueDef($rsnew, $this->fr_id->CurrentValue, 0, $this->fr_id->ReadOnly);

			// small_pic
			if (!($this->small_pic->ReadOnly) && !$this->small_pic->Upload->KeepFile) {
				$this->small_pic->Upload->DbValue = $rs->fields('small_pic'); // Get original value
				if ($this->small_pic->Upload->FileName == "") {
					$rsnew['small_pic'] = NULL;
				} else {
					$rsnew['small_pic'] = $this->small_pic->Upload->FileName;
				}
			}

			// large_pic
			if (!($this->large_pic->ReadOnly) && !$this->large_pic->Upload->KeepFile) {
				$this->large_pic->Upload->DbValue = $rs->fields('large_pic'); // Get original value
				if ($this->large_pic->Upload->FileName == "") {
					$rsnew['large_pic'] = NULL;
				} else {
					$rsnew['large_pic'] = $this->large_pic->Upload->FileName;
				}
			}
			if (!$this->small_pic->Upload->KeepFile) {
				$this->small_pic->UploadPath = "../uploads/projects/small";
				if (!ew_Empty($this->small_pic->Upload->Value)) {
					$rsnew['small_pic'] = ew_UploadFileNameEx(ew_UploadPathEx(TRUE, $this->small_pic->UploadPath), $rsnew['small_pic']); // Get new file name
				}
			}
			if (!$this->large_pic->Upload->KeepFile) {
				$this->large_pic->UploadPath = "../uploads/projects/large";
				if (!ew_Empty($this->large_pic->Upload->Value)) {
					$rsnew['large_pic'] = ew_UploadFileNameEx(ew_UploadPathEx(TRUE, $this->large_pic->UploadPath), $rsnew['large_pic']); // Get new file name
				}
			}

			// Call Row Updating event
			$bUpdateRow = $this->Row_Updating($rsold, $rsnew);
			if ($bUpdateRow) {
				$conn->raiseErrorFn = 'ew_ErrorFn';
				if (count($rsnew) > 0)
					$EditRow = $this->Update($rsnew, "", $rsold);
				else
					$EditRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($EditRow) {
					if (!$this->small_pic->Upload->KeepFile) {
						if (!ew_Empty($this->small_pic->Upload->Value)) {
							$this->small_pic->Upload->SaveToFile($this->small_pic->UploadPath, $rsnew['small_pic'], TRUE);
						}
					}
					if (!$this->large_pic->Upload->KeepFile) {
						if (!ew_Empty($this->large_pic->Upload->Value)) {
							$this->large_pic->Upload->SaveToFile($this->large_pic->UploadPath, $rsnew['large_pic'], TRUE);
						}
					}
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->Phrase("UpdateCancelled"));
				}
				$EditRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($EditRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->Close();

		// small_pic
		ew_CleanUploadTempPath($this->small_pic, $this->small_pic->Upload->Index);

		// large_pic
		ew_CleanUploadTempPath($this->large_pic, $this->large_pic->Upload->Index);
		return $EditRow;
	}

	// Set up master/detail based on QueryString
	function SetUpMasterParms() {
		$bValidMaster = FALSE;

		// Get the keys for master table
		if (isset($_GET[EW_TABLE_SHOW_MASTER])) {
			$sMasterTblVar = $_GET[EW_TABLE_SHOW_MASTER];
			if ($sMasterTblVar == "") {
				$bValidMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($sMasterTblVar == "news") {
				$bValidMaster = TRUE;
				if (@$_GET["id"] <> "") {
					$GLOBALS["news"]->id->setQueryStringValue($_GET["id"]);
					$this->fr_id->setQueryStringValue($GLOBALS["news"]->id->QueryStringValue);
					$this->fr_id->setSessionValue($this->fr_id->QueryStringValue);
					if (!is_numeric($GLOBALS["news"]->id->QueryStringValue)) $bValidMaster = FALSE;
				} else {
					$bValidMaster = FALSE;
				}
			}
		}
		if ($bValidMaster) {

			// Save current master table
			$this->setCurrentMasterTable($sMasterTblVar);

			// Reset start record counter (new master key)
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);

			// Clear previous master key from Session
			if ($sMasterTblVar <> "news") {
				if ($this->fr_id->QueryStringValue == "") $this->fr_id->setSessionValue("");
			}
		}
		$this->DbMasterFilter = $this->GetMasterFilter(); //  Get master filter
		$this->DbDetailFilter = $this->GetDetailFilter(); // Get detail filter
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$PageCaption = $this->TableCaption();
		$Breadcrumb->Add("list", "<span id=\"ewPageCaption\">" . $PageCaption . "</span>", "news_pictureslist.php", $this->TableVar);
		$PageCaption = $Language->Phrase("edit");
		$Breadcrumb->Add("edit", "<span id=\"ewPageCaption\">" . $PageCaption . "</span>", ew_CurrentUrl(), $this->TableVar);
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($news_pictures_edit)) $news_pictures_edit = new cnews_pictures_edit();

// Page init
$news_pictures_edit->Page_Init();

// Page main
$news_pictures_edit->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$news_pictures_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Page object
var news_pictures_edit = new ew_Page("news_pictures_edit");
news_pictures_edit.PageID = "edit"; // Page ID
var EW_PAGE_ID = news_pictures_edit.PageID; // For backward compatibility

// Form object
var fnews_picturesedit = new ew_Form("fnews_picturesedit");

// Validate form
fnews_picturesedit.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);
	this.PostAutoSuggest();
	if ($fobj.find("#a_confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.FormKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = $fobj.find("#a_list").val() == "gridinsert";
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
			elm = this.GetElements("x" + infix + "_fr_id");
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($news_pictures->fr_id->FldCaption()) ?>");
			felm = this.GetElements("x" + infix + "_small_pic");
			elm = this.GetElements("fn_x" + infix + "_small_pic");
			if (felm && elm && !ew_HasValue(elm))
				return this.OnError(felm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($news_pictures->small_pic->FldCaption()) ?>");
			felm = this.GetElements("x" + infix + "_large_pic");
			elm = this.GetElements("fn_x" + infix + "_large_pic");
			if (felm && elm && !ew_HasValue(elm))
				return this.OnError(felm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($news_pictures->large_pic->FldCaption()) ?>");

			// Set up row object
			ew_ElementsToRow(fobj);

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ewForms[val])
			if (!ewForms[val].Validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fnews_picturesedit.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fnews_picturesedit.ValidateRequired = true;
<?php } else { ?>
fnews_picturesedit.ValidateRequired = false; 
<?php } ?>

// Dynamic selection lists
fnews_picturesedit.Lists["x_fr_id"] = {"LinkField":"x_id","Ajax":null,"AutoFill":false,"DisplayFields":["x_title","","",""],"ParentFields":[],"FilterFields":[],"Options":[]};

// Form object for search
</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php $Breadcrumb->Render(); ?>
<?php $news_pictures_edit->ShowPageHeader(); ?>
<?php
$news_pictures_edit->ShowMessage();
?>
<form name="ewPagerForm" class="ewForm form-horizontal" action="<?php echo ew_CurrentPage() ?>">
<table class="ewPager">
<tr><td>
<?php if (!isset($news_pictures_edit->Pager)) $news_pictures_edit->Pager = new cPrevNextPager($news_pictures_edit->StartRec, $news_pictures_edit->DisplayRecs, $news_pictures_edit->TotalRecs) ?>
<?php if ($news_pictures_edit->Pager->RecordCount > 0) { ?>
<table cellspacing="0" class="ewStdTable"><tbody><tr><td>
	<?php echo $Language->Phrase("Page") ?>&nbsp;
<div class="input-prepend input-append">
<!--first page button-->
	<?php if ($news_pictures_edit->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-small" type="button" href="<?php echo $news_pictures_edit->PageUrl() ?>start=<?php echo $news_pictures_edit->Pager->FirstButton->Start ?>"><i class="icon-step-backward"></i></a>
	<?php } else { ?>
	<a class="btn btn-small" type="button" disabled="disabled"><i class="icon-step-backward"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($news_pictures_edit->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-small" type="button" href="<?php echo $news_pictures_edit->PageUrl() ?>start=<?php echo $news_pictures_edit->Pager->PrevButton->Start ?>"><i class="icon-prev"></i></a>
	<?php } else { ?>
	<a class="btn btn-small" type="button" disabled="disabled"><i class="icon-prev"></i></a>
	<?php } ?>
<!--current page number-->
	<input class="input-mini" type="text" name="<?php echo EW_TABLE_PAGE_NO ?>" value="<?php echo $news_pictures_edit->Pager->CurrentPage ?>">
<!--next page button-->
	<?php if ($news_pictures_edit->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-small" type="button" href="<?php echo $news_pictures_edit->PageUrl() ?>start=<?php echo $news_pictures_edit->Pager->NextButton->Start ?>"><i class="icon-play"></i></a>
	<?php } else { ?>
	<a class="btn btn-small" type="button" disabled="disabled"><i class="icon-play"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($news_pictures_edit->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-small" type="button" href="<?php echo $news_pictures_edit->PageUrl() ?>start=<?php echo $news_pictures_edit->Pager->LastButton->Start ?>"><i class="icon-step-forward"></i></a>
	<?php } else { ?>
	<a class="btn btn-small" type="button" disabled="disabled"><i class="icon-step-forward"></i></a>
	<?php } ?>
</div>
	&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $news_pictures_edit->Pager->PageCount ?>
</td>
</tr></tbody></table>
<?php } else { ?>
	<p><?php echo $Language->Phrase("NoRecord") ?></p>
<?php } ?>
</td>
</tr></table>
</form>
<form name="fnews_picturesedit" id="fnews_picturesedit" class="ewForm form-horizontal" action="<?php echo ew_CurrentPage() ?>" method="post">
<input type="hidden" name="t" value="news_pictures">
<input type="hidden" name="a_edit" id="a_edit" value="U">
<table cellspacing="0" class="ewGrid"><tr><td>
<table id="tbl_news_picturesedit" class="table table-bordered table-striped">
<?php if ($news_pictures->id->Visible) { // id ?>
	<tr id="r_id">
		<td><span id="elh_news_pictures_id"><?php echo $news_pictures->id->FldCaption() ?></span></td>
		<td<?php echo $news_pictures->id->CellAttributes() ?>>
<span id="el_news_pictures_id" class="control-group">
<span<?php echo $news_pictures->id->ViewAttributes() ?>>
<?php echo $news_pictures->id->EditValue ?></span>
</span>
<input type="hidden" data-field="x_id" name="x_id" id="x_id" value="<?php echo ew_HtmlEncode($news_pictures->id->CurrentValue) ?>">
<?php echo $news_pictures->id->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($news_pictures->fr_id->Visible) { // fr_id ?>
	<tr id="r_fr_id">
		<td><span id="elh_news_pictures_fr_id"><?php echo $news_pictures->fr_id->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $news_pictures->fr_id->CellAttributes() ?>>
<?php if ($news_pictures->fr_id->getSessionValue() <> "") { ?>
<span<?php echo $news_pictures->fr_id->ViewAttributes() ?>>
<?php echo $news_pictures->fr_id->ViewValue ?></span>
<input type="hidden" id="x_fr_id" name="x_fr_id" value="<?php echo ew_HtmlEncode($news_pictures->fr_id->CurrentValue) ?>">
<?php } else { ?>
<select data-field="x_fr_id" id="x_fr_id" name="x_fr_id"<?php echo $news_pictures->fr_id->EditAttributes() ?>>
<?php
if (is_array($news_pictures->fr_id->EditValue)) {
	$arwrk = $news_pictures->fr_id->EditValue;
	$rowswrk = count($arwrk);
	$emptywrk = TRUE;
	for ($rowcntwrk = 0; $rowcntwrk < $rowswrk; $rowcntwrk++) {
		$selwrk = (strval($news_pictures->fr_id->CurrentValue) == strval($arwrk[$rowcntwrk][0])) ? " selected=\"selected\"" : "";
		if ($selwrk <> "") $emptywrk = FALSE;
?>
<option value="<?php echo ew_HtmlEncode($arwrk[$rowcntwrk][0]) ?>"<?php echo $selwrk ?>>
<?php echo $arwrk[$rowcntwrk][1] ?>
</option>
<?php
	}
}
?>
</select>
<script type="text/javascript">
fnews_picturesedit.Lists["x_fr_id"].Options = <?php echo (is_array($news_pictures->fr_id->EditValue)) ? ew_ArrayToJson($news_pictures->fr_id->EditValue, 1) : "[]" ?>;
</script>
<?php } ?>
<?php echo $news_pictures->fr_id->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($news_pictures->small_pic->Visible) { // small_pic ?>
	<tr id="r_small_pic">
		<td><span id="elh_news_pictures_small_pic"><?php echo $news_pictures->small_pic->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $news_pictures->small_pic->CellAttributes() ?>>
<span id="el_news_pictures_small_pic" class="control-group">
<span id="fd_x_small_pic">
<span class="btn btn-small fileinput-button">
	<span><?php echo $Language->Phrase("ChooseFile") ?></span>
	<input type="file" data-field="x_small_pic" name="x_small_pic" id="x_small_pic">
</span>
<input type="hidden" name="fn_x_small_pic" id= "fn_x_small_pic" value="<?php echo $news_pictures->small_pic->Upload->FileName ?>">
<?php if (@$_POST["fa_x_small_pic"] == "0") { ?>
<input type="hidden" name="fa_x_small_pic" id= "fa_x_small_pic" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_small_pic" id= "fa_x_small_pic" value="1">
<?php } ?>
<input type="hidden" name="fs_x_small_pic" id= "fs_x_small_pic" value="250">
</span>
<table id="ft_x_small_pic" class="table table-condensed pull-left ewUploadTable"><tbody class="files"></tbody></table>
</span>
<?php echo $news_pictures->small_pic->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($news_pictures->large_pic->Visible) { // large_pic ?>
	<tr id="r_large_pic">
		<td><span id="elh_news_pictures_large_pic"><?php echo $news_pictures->large_pic->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $news_pictures->large_pic->CellAttributes() ?>>
<span id="el_news_pictures_large_pic" class="control-group">
<span id="fd_x_large_pic">
<span class="btn btn-small fileinput-button">
	<span><?php echo $Language->Phrase("ChooseFile") ?></span>
	<input type="file" data-field="x_large_pic" name="x_large_pic" id="x_large_pic">
</span>
<input type="hidden" name="fn_x_large_pic" id= "fn_x_large_pic" value="<?php echo $news_pictures->large_pic->Upload->FileName ?>">
<?php if (@$_POST["fa_x_large_pic"] == "0") { ?>
<input type="hidden" name="fa_x_large_pic" id= "fa_x_large_pic" value="0">
<?php } else { ?>
<input type="hidden" name="fa_x_large_pic" id= "fa_x_large_pic" value="1">
<?php } ?>
<input type="hidden" name="fs_x_large_pic" id= "fs_x_large_pic" value="250">
</span>
<table id="ft_x_large_pic" class="table table-condensed pull-left ewUploadTable"><tbody class="files"></tbody></table>
</span>
<?php echo $news_pictures->large_pic->CustomMsg ?></td>
	</tr>
<?php } ?>
</table>
</td></tr></table>
<table class="ewPager">
<tr><td>
<?php if (!isset($news_pictures_edit->Pager)) $news_pictures_edit->Pager = new cPrevNextPager($news_pictures_edit->StartRec, $news_pictures_edit->DisplayRecs, $news_pictures_edit->TotalRecs) ?>
<?php if ($news_pictures_edit->Pager->RecordCount > 0) { ?>
<table cellspacing="0" class="ewStdTable"><tbody><tr><td>
	<?php echo $Language->Phrase("Page") ?>&nbsp;
<div class="input-prepend input-append">
<!--first page button-->
	<?php if ($news_pictures_edit->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-small" type="button" href="<?php echo $news_pictures_edit->PageUrl() ?>start=<?php echo $news_pictures_edit->Pager->FirstButton->Start ?>"><i class="icon-step-backward"></i></a>
	<?php } else { ?>
	<a class="btn btn-small" type="button" disabled="disabled"><i class="icon-step-backward"></i></a>
	<?php } ?>
<!--previous page button-->
	<?php if ($news_pictures_edit->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-small" type="button" href="<?php echo $news_pictures_edit->PageUrl() ?>start=<?php echo $news_pictures_edit->Pager->PrevButton->Start ?>"><i class="icon-prev"></i></a>
	<?php } else { ?>
	<a class="btn btn-small" type="button" disabled="disabled"><i class="icon-prev"></i></a>
	<?php } ?>
<!--current page number-->
	<input class="input-mini" type="text" name="<?php echo EW_TABLE_PAGE_NO ?>" value="<?php echo $news_pictures_edit->Pager->CurrentPage ?>">
<!--next page button-->
	<?php if ($news_pictures_edit->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-small" type="button" href="<?php echo $news_pictures_edit->PageUrl() ?>start=<?php echo $news_pictures_edit->Pager->NextButton->Start ?>"><i class="icon-play"></i></a>
	<?php } else { ?>
	<a class="btn btn-small" type="button" disabled="disabled"><i class="icon-play"></i></a>
	<?php } ?>
<!--last page button-->
	<?php if ($news_pictures_edit->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-small" type="button" href="<?php echo $news_pictures_edit->PageUrl() ?>start=<?php echo $news_pictures_edit->Pager->LastButton->Start ?>"><i class="icon-step-forward"></i></a>
	<?php } else { ?>
	<a class="btn btn-small" type="button" disabled="disabled"><i class="icon-step-forward"></i></a>
	<?php } ?>
</div>
	&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $news_pictures_edit->Pager->PageCount ?>
</td>
</tr></tbody></table>
<?php } else { ?>
	<p><?php echo $Language->Phrase("NoRecord") ?></p>
<?php } ?>
</td>
</tr></table>
<button class="btn btn-primary ewButton" name="btnAction" id="btnAction" type="submit"><?php echo $Language->Phrase("EditBtn") ?></button>
</form>
<script type="text/javascript">
fnews_picturesedit.Init();
<?php if (EW_MOBILE_REFLOW && ew_IsMobile()) { ?>
ew_Reflow();
<?php } ?>
</script>
<?php
$news_pictures_edit->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$news_pictures_edit->Page_Terminate();
?>
