<?php
if (session_id() == "") session_start(); // Initialize Session data
ob_start(); // Turn on output buffering
?>
<?php include_once "ewcfg10.php" ?>
<?php include_once "ewmysql10.php" ?>
<?php include_once "phpfn10.php" ?>
<?php include_once "newsinfo.php" ?>
<?php include_once "_logininfo.php" ?>
<?php include_once "news_picturesgridcls.php" ?>
<?php include_once "userfn10.php" ?>
<?php

//
// Page class
//

$news_add = NULL; // Initialize page object first

class cnews_add extends cnews {

	// Page ID
	var $PageID = 'add';

	// Project ID
	var $ProjectID = "{12440D03-277E-47C7-ADF1-950F71C707AB}";

	// Table name
	var $TableName = 'news';

	// Page object name
	var $PageObjName = 'news_add';

	// Page name
	function PageName() {
		return ew_CurrentPage();
	}

	// Page URL
	function PageUrl() {
		$PageUrl = ew_CurrentPage() . "?";
		if ($this->UseTokenInUrl) $PageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		return $PageUrl;
	}

	// Message
	function getMessage() {
		return @$_SESSION[EW_SESSION_MESSAGE];
	}

	function setMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_MESSAGE], $v);
	}

	function getFailureMessage() {
		return @$_SESSION[EW_SESSION_FAILURE_MESSAGE];
	}

	function setFailureMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_FAILURE_MESSAGE], $v);
	}

	function getSuccessMessage() {
		return @$_SESSION[EW_SESSION_SUCCESS_MESSAGE];
	}

	function setSuccessMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_SUCCESS_MESSAGE], $v);
	}

	function getWarningMessage() {
		return @$_SESSION[EW_SESSION_WARNING_MESSAGE];
	}

	function setWarningMessage($v) {
		ew_AddMessage($_SESSION[EW_SESSION_WARNING_MESSAGE], $v);
	}

	// Show message
	function ShowMessage() {
		$hidden = FALSE;
		$html = "";

		// Message
		$sMessage = $this->getMessage();
		$this->Message_Showing($sMessage, "");
		if ($sMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sMessage . "</div>";
			$_SESSION[EW_SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$sWarningMessage = $this->getWarningMessage();
		$this->Message_Showing($sWarningMessage, "warning");
		if ($sWarningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sWarningMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sWarningMessage;
			$html .= "<div class=\"alert alert-warning ewWarning\">" . $sWarningMessage . "</div>";
			$_SESSION[EW_SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$sSuccessMessage = $this->getSuccessMessage();
		$this->Message_Showing($sSuccessMessage, "success");
		if ($sSuccessMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sSuccessMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sSuccessMessage;
			$html .= "<div class=\"alert alert-success ewSuccess\">" . $sSuccessMessage . "</div>";
			$_SESSION[EW_SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$sErrorMessage = $this->getFailureMessage();
		$this->Message_Showing($sErrorMessage, "failure");
		if ($sErrorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$sErrorMessage = "<button type=\"button\" class=\"close\" data-dismiss=\"alert\">&times;</button>" . $sErrorMessage;
			$html .= "<div class=\"alert alert-error ewError\">" . $sErrorMessage . "</div>";
			$_SESSION[EW_SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo "<table class=\"ewStdTable\"><tr><td><div class=\"ewMessageDialog\"" . (($hidden) ? " style=\"display: none;\"" : "") . ">" . $html . "</div></td></tr></table>";
	}
	var $PageHeader;
	var $PageFooter;

	// Show Page Header
	function ShowPageHeader() {
		$sHeader = $this->PageHeader;
		$this->Page_DataRendering($sHeader);
		if ($sHeader <> "") { // Header exists, display
			echo "<p>" . $sHeader . "</p>";
		}
	}

	// Show Page Footer
	function ShowPageFooter() {
		$sFooter = $this->PageFooter;
		$this->Page_DataRendered($sFooter);
		if ($sFooter <> "") { // Footer exists, display
			echo "<p>" . $sFooter . "</p>";
		}
	}

	// Validate page request
	function IsPageRequest() {
		global $objForm;
		if ($this->UseTokenInUrl) {
			if ($objForm)
				return ($this->TableVar == $objForm->GetValue("t"));
			if (@$_GET["t"] <> "")
				return ($this->TableVar == $_GET["t"]);
		} else {
			return TRUE;
		}
	}

	//
	// Page class constructor
	//
	function __construct() {
		global $conn, $Language, $UserAgent;

		// User agent
		$UserAgent = ew_UserAgent();
		$GLOBALS["Page"] = &$this;

		// Language object
		if (!isset($Language)) $Language = new cLanguage();

		// Parent constuctor
		parent::__construct();

		// Table object (news)
		if (!isset($GLOBALS["news"])) {
			$GLOBALS["news"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["news"];
		}

		// Table object (_login)
		if (!isset($GLOBALS['_login'])) $GLOBALS['_login'] = new c_login();

		// Page ID
		if (!defined("EW_PAGE_ID"))
			define("EW_PAGE_ID", 'add', TRUE);

		// Table name (for backward compatibility)
		if (!defined("EW_TABLE_NAME"))
			define("EW_TABLE_NAME", 'news', TRUE);

		// Start timer
		if (!isset($GLOBALS["gTimer"])) $GLOBALS["gTimer"] = new cTimer();

		// Open connection
		if (!isset($conn)) $conn = ew_Connect();
	}

	// 
	//  Page_Init
	//
	function Page_Init() {
		global $gsExport, $gsExportFile, $UserProfile, $Language, $Security, $objForm;

		// Security
		$Security = new cAdvancedSecurity();
		if (!$Security->IsLoggedIn()) $Security->AutoLogin();
		if (!$Security->IsLoggedIn()) {
			$Security->SaveLastUrl();
			$this->Page_Terminate("login.php");
		}

		// Create form object
		$objForm = new cFormObj();
		$this->CurrentAction = (@$_GET["a"] <> "") ? $_GET["a"] : @$_POST["a_list"]; // Set up curent action

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();
	}

	//
	// Page_Terminate
	//
	function Page_Terminate($url = "") {
		global $conn;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();
		$this->Page_Redirecting($url);

		 // Close connection
		$conn->Close();

		// Go to URL if specified
		if ($url <> "") {
			if (!EW_DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			header("Location: " . $url);
		}
		exit();
	}
	var $DbMasterFilter = "";
	var $DbDetailFilter = "";
	var $Priv = 0;
	var $OldRecordset;
	var $CopyRecord;

	// 
	// Page main
	//
	function Page_Main() {
		global $objForm, $Language, $gsFormError;

		// Process form if post back
		if (@$_POST["a_add"] <> "") {
			$this->CurrentAction = $_POST["a_add"]; // Get form action
			$this->CopyRecord = $this->LoadOldRecord(); // Load old recordset
			$this->LoadFormValues(); // Load form values
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (@$_GET["id"] != "") {
				$this->id->setQueryStringValue($_GET["id"]);
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "C"; // Copy record
			} else {
				$this->CurrentAction = "I"; // Display blank record
				$this->LoadDefaultValues(); // Load default values
			}
		}

		// Set up Breadcrumb
		$this->SetupBreadcrumb();

		// Set up detail parameters
		$this->SetUpDetailParms();

		// Validate form if post back
		if (@$_POST["a_add"] <> "") {
			if (!$this->ValidateForm()) {
				$this->CurrentAction = "I"; // Form error, reset action
				$this->EventCancelled = TRUE; // Event cancelled
				$this->RestoreFormValues(); // Restore form values
				$this->setFailureMessage($gsFormError);
			}
		}

		// Perform action based on action code
		switch ($this->CurrentAction) {
			case "I": // Blank record, no action required
				break;
			case "C": // Copy an existing record
				if (!$this->LoadRow()) { // Load record based on key
					if ($this->getFailureMessage() == "") $this->setFailureMessage($Language->Phrase("NoRecord")); // No record found
					$this->Page_Terminate("newslist.php"); // No matching record, return to list
				}

				// Set up detail parameters
				$this->SetUpDetailParms();
				break;
			case "A": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->AddRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->Phrase("AddSuccess")); // Set up success message
					if ($this->getCurrentDetailTable() <> "") // Master/detail add
						$sReturnUrl = $this->GetDetailUrl();
					else
						$sReturnUrl = $this->getReturnUrl();
					if (ew_GetPageName($sReturnUrl) == "newsview.php")
						$sReturnUrl = $this->GetViewUrl(); // View paging, return to view page with keyurl directly
					$this->Page_Terminate($sReturnUrl); // Clean up and return
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->RestoreFormValues(); // Add failed, restore form values

					// Set up detail parameters
					$this->SetUpDetailParms();
				}
		}

		// Render row based on row type
		$this->RowType = EW_ROWTYPE_ADD;  // Render add type

		// Render row
		$this->ResetAttrs();
		$this->RenderRow();
	}

	// Get upload files
	function GetUploadFiles() {
		global $objForm;

		// Get upload data
		$this->banner_picture->Upload->Index = $objForm->Index;
		if ($this->banner_picture->Upload->UploadFile()) {

			// No action required
		} else {
			echo $this->banner_picture->Upload->Message;
			$this->Page_Terminate();
			exit();
		}
		$this->banner_picture->CurrentValue = $this->banner_picture->Upload->FileName;
		$this->thumb->Upload->Index = $objForm->Index;
		if ($this->thumb->Upload->UploadFile()) {

			// No action required
		} else {
			echo $this->thumb->Upload->Message;
			$this->Page_Terminate();
			exit();
		}
		$this->thumb->CurrentValue = $this->thumb->Upload->FileName;
		$this->pdf->Upload->Index = $objForm->Index;
		if ($this->pdf->Upload->UploadFile()) {

			// No action required
		} else {
			echo $this->pdf->Upload->Message;
			$this->Page_Terminate();
			exit();
		}
		$this->pdf->CurrentValue = $this->pdf->Upload->FileName;
	}

	// Load default values
	function LoadDefaultValues() {
		$this->title->CurrentValue = NULL;
		$this->title->OldValue = $this->title->CurrentValue;
		$this->banner_picture->Upload->DbValue = NULL;
		$this->banner_picture->OldValue = $this->banner_picture->Upload->DbValue;
		$this->banner_picture->CurrentValue = NULL; // Clear file related field
		$this->thumb->Upload->DbValue = NULL;
		$this->thumb->OldValue = $this->thumb->Upload->DbValue;
		$this->thumb->CurrentValue = NULL; // Clear file related field
		$this->pdf->Upload->DbValue = NULL;
		$this->pdf->OldValue = $this->pdf->Upload->DbValue;
		$this->pdf->CurrentValue = NULL; // Clear file related field
		$this->event_date->CurrentValue = NULL;
		$this->event_date->OldValue = $this->event_date->CurrentValue;
		$this->description->CurrentValue = NULL;
		$this->description->OldValue = $this->description->CurrentValue;
	}

	// Load form values
	function LoadFormValues() {

		// Load from form
		global $objForm;
		$this->GetUploadFiles(); // Get upload files
		if (!$this->title->FldIsDetailKey) {
			$this->title->setFormValue($objForm->GetValue("x_title"));
		}
		if (!$this->event_date->FldIsDetailKey) {
			$this->event_date->setFormValue($objForm->GetValue("x_event_date"));
			$this->event_date->CurrentValue = ew_UnFormatDateTime($this->event_date->CurrentValue, 7);
		}
		if (!$this->description->FldIsDetailKey) {
			$this->description->setFormValue($objForm->GetValue("x_description"));
		}
	}

	// Restore form values
	function RestoreFormValues() {
		global $objForm;
		$this->LoadOldRecord();
		$this->title->CurrentValue = $this->title->FormValue;
		$this->event_date->CurrentValue = $this->event_date->FormValue;
		$this->event_date->CurrentValue = ew_UnFormatDateTime($this->event_date->CurrentValue, 7);
		$this->description->CurrentValue = $this->description->FormValue;
	}

	// Load row based on key values
	function LoadRow() {
		global $conn, $Security, $Language;
		$sFilter = $this->KeyFilter();

		// Call Row Selecting event
		$this->Row_Selecting($sFilter);

		// Load SQL based on filter
		$this->CurrentFilter = $sFilter;
		$sSql = $this->SQL();
		$res = FALSE;
		$rs = ew_LoadRecordset($sSql);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->LoadRowValues($rs); // Load row values
			$rs->Close();
		}
		return $res;
	}

	// Load row values from recordset
	function LoadRowValues(&$rs) {
		global $conn;
		if (!$rs || $rs->EOF) return;

		// Call Row Selected event
		$row = &$rs->fields;
		$this->Row_Selected($row);
		$this->id->setDbValue($rs->fields('id'));
		$this->title->setDbValue($rs->fields('title'));
		$this->banner_picture->Upload->DbValue = $rs->fields('banner_picture');
		$this->thumb->Upload->DbValue = $rs->fields('thumb');
		$this->pdf->Upload->DbValue = $rs->fields('pdf');
		$this->event_date->setDbValue($rs->fields('event_date'));
		$this->description->setDbValue($rs->fields('description'));
	}

	// Load DbValue from recordset
	function LoadDbValues(&$rs) {
		if (!$rs || !is_array($rs) && $rs->EOF) return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->title->DbValue = $row['title'];
		$this->banner_picture->Upload->DbValue = $row['banner_picture'];
		$this->thumb->Upload->DbValue = $row['thumb'];
		$this->pdf->Upload->DbValue = $row['pdf'];
		$this->event_date->DbValue = $row['event_date'];
		$this->description->DbValue = $row['description'];
	}

	// Load old record
	function LoadOldRecord() {

		// Load key values from Session
		$bValidKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$bValidKey = FALSE;

		// Load old recordset
		if ($bValidKey) {
			$this->CurrentFilter = $this->KeyFilter();
			$sSql = $this->SQL();
			$this->OldRecordset = ew_LoadRecordset($sSql);
			$this->LoadRowValues($this->OldRecordset); // Load row values
		} else {
			$this->OldRecordset = NULL;
		}
		return $bValidKey;
	}

	// Render row values based on field settings
	function RenderRow() {
		global $conn, $Security, $Language;
		global $gsLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// title
		// banner_picture
		// thumb
		// pdf
		// event_date
		// description

		if ($this->RowType == EW_ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// title
			$this->title->ViewValue = $this->title->CurrentValue;
			$this->title->ViewCustomAttributes = "";

			// banner_picture
			$this->banner_picture->UploadPath = "../uploads/banners";
			if (!ew_Empty($this->banner_picture->Upload->DbValue)) {
				$this->banner_picture->ImageAlt = $this->banner_picture->FldAlt();
				$this->banner_picture->ViewValue = ew_UploadPathEx(FALSE, $this->banner_picture->UploadPath) . $this->banner_picture->Upload->DbValue;
			} else {
				$this->banner_picture->ViewValue = "";
			}
			$this->banner_picture->ViewCustomAttributes = "";

			// thumb
			$this->thumb->UploadPath = "../uploads/projects/thumb";
			if (!ew_Empty($this->thumb->Upload->DbValue)) {
				$this->thumb->ImageAlt = $this->thumb->FldAlt();
				$this->thumb->ViewValue = ew_UploadPathEx(FALSE, $this->thumb->UploadPath) . $this->thumb->Upload->DbValue;
			} else {
				$this->thumb->ViewValue = "";
			}
			$this->thumb->ViewCustomAttributes = "";

			// pdf
			$this->pdf->UploadPath = "../uploads/projects/pdf";
			if (!ew_Empty($this->pdf->Upload->DbValue)) {
				$this->pdf->ViewValue = $this->pdf->Upload->DbValue;
			} else {
				$this->pdf->ViewValue = "";
			}
			$this->pdf->ViewCustomAttributes = "";

			// event_date
			$this->event_date->ViewValue = $this->event_date->CurrentValue;
			$this->event_date->ViewValue = ew_FormatDateTime($this->event_date->ViewValue, 7);
			$this->event_date->ViewCustomAttributes = "";

			// description
			$this->description->ViewValue = $this->description->CurrentValue;
			$this->description->ViewCustomAttributes = "";

			// title
			$this->title->LinkCustomAttributes = "";
			$this->title->HrefValue = "";
			$this->title->TooltipValue = "";

			// banner_picture
			$this->banner_picture->LinkCustomAttributes = "";
			$this->banner_picture->HrefValue = "";
			$this->banner_picture->HrefValue2 = $this->banner_picture->UploadPath . $this->banner_picture->Upload->DbValue;
			$this->banner_picture->TooltipValue = "";

			// thumb
			$this->thumb->LinkCustomAttributes = "";
			$this->thumb->HrefValue = "";
			$this->thumb->HrefValue2 = $this->thumb->UploadPath . $this->thumb->Upload->DbValue;
			$this->thumb->TooltipValue = "";

			// pdf
			$this->pdf->LinkCustomAttributes = "";
			$this->pdf->HrefValue = "";
			$this->pdf->HrefValue2 = $this->pdf->UploadPath . $this->pdf->Upload->DbValue;
			$this->pdf->TooltipValue = "";

			// event_date
			$this->event_date->LinkCustomAttributes = "";
			$this->event_date->HrefValue = "";
			$this->event_date->TooltipValue = "";

			// description
			$this->description->LinkCustomAttributes = "";
			$this->description->HrefValue = "";
			$this->description->TooltipValue = "";
		} elseif ($this->RowType == EW_ROWTYPE_ADD) { // Add row

			// title
			$this->title->EditCustomAttributes = "";
			$this->title->EditValue = ew_HtmlEncode($this->title->CurrentValue);
			$this->title->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->title->FldCaption()));

			// banner_picture
			$this->banner_picture->EditCustomAttributes = "";
			$this->banner_picture->UploadPath = "../uploads/banners";
			if (!ew_Empty($this->banner_picture->Upload->DbValue)) {
				$this->banner_picture->ImageAlt = $this->banner_picture->FldAlt();
				$this->banner_picture->EditValue = ew_UploadPathEx(FALSE, $this->banner_picture->UploadPath) . $this->banner_picture->Upload->DbValue;
			} else {
				$this->banner_picture->EditValue = "";
			}
			if (($this->CurrentAction == "I" || $this->CurrentAction == "C") && !$this->EventCancelled) ew_RenderUploadField($this->banner_picture);

			// thumb
			$this->thumb->EditCustomAttributes = "";
			$this->thumb->UploadPath = "../uploads/projects/thumb";
			if (!ew_Empty($this->thumb->Upload->DbValue)) {
				$this->thumb->ImageAlt = $this->thumb->FldAlt();
				$this->thumb->EditValue = ew_UploadPathEx(FALSE, $this->thumb->UploadPath) . $this->thumb->Upload->DbValue;
			} else {
				$this->thumb->EditValue = "";
			}
			if (($this->CurrentAction == "I" || $this->CurrentAction == "C") && !$this->EventCancelled) ew_RenderUploadField($this->thumb);

			// pdf
			$this->pdf->EditCustomAttributes = "";
			$this->pdf->UploadPath = "../uploads/projects/pdf";
			if (!ew_Empty($this->pdf->Upload->DbValue)) {
				$this->pdf->EditValue = $this->pdf->Upload->DbValue;
			} else {
				$this->pdf->EditValue = "";
			}
			if (($this->CurrentAction == "I" || $this->CurrentAction == "C") && !$this->EventCancelled) ew_RenderUploadField($this->pdf);

			// event_date
			$this->event_date->EditCustomAttributes = "";
			$this->event_date->EditValue = ew_HtmlEncode(ew_FormatDateTime($this->event_date->CurrentValue, 7));
			$this->event_date->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->event_date->FldCaption()));

			// description
			$this->description->EditCustomAttributes = "";
			$this->description->EditValue = $this->description->CurrentValue;
			$this->description->PlaceHolder = ew_HtmlEncode(ew_RemoveHtml($this->description->FldCaption()));

			// Edit refer script
			// title

			$this->title->HrefValue = "";

			// banner_picture
			$this->banner_picture->HrefValue = "";
			$this->banner_picture->HrefValue2 = $this->banner_picture->UploadPath . $this->banner_picture->Upload->DbValue;

			// thumb
			$this->thumb->HrefValue = "";
			$this->thumb->HrefValue2 = $this->thumb->UploadPath . $this->thumb->Upload->DbValue;

			// pdf
			$this->pdf->HrefValue = "";
			$this->pdf->HrefValue2 = $this->pdf->UploadPath . $this->pdf->Upload->DbValue;

			// event_date
			$this->event_date->HrefValue = "";

			// description
			$this->description->HrefValue = "";
		}
		if ($this->RowType == EW_ROWTYPE_ADD ||
			$this->RowType == EW_ROWTYPE_EDIT ||
			$this->RowType == EW_ROWTYPE_SEARCH) { // Add / Edit / Search row
			$this->SetupFieldTitles();
		}

		// Call Row Rendered event
		if ($this->RowType <> EW_ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	function ValidateForm() {
		global $Language, $gsFormError;

		// Initialize form error message
		$gsFormError = "";

		// Check if validation required
		if (!EW_SERVER_VALIDATE)
			return ($gsFormError == "");
		if (!$this->title->FldIsDetailKey && !is_null($this->title->FormValue) && $this->title->FormValue == "") {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->title->FldCaption());
		}
		if (is_null($this->banner_picture->Upload->Value)) {
			ew_AddMessage($gsFormError, $Language->Phrase("EnterRequiredField") . " - " . $this->banner_picture->FldCaption());
		}
		if (!ew_CheckEuroDate($this->event_date->FormValue)) {
			ew_AddMessage($gsFormError, $this->event_date->FldErrMsg());
		}

		// Validate detail grid
		$DetailTblVar = explode(",", $this->getCurrentDetailTable());
		if (in_array("news_pictures", $DetailTblVar) && $GLOBALS["news_pictures"]->DetailAdd) {
			if (!isset($GLOBALS["news_pictures_grid"])) $GLOBALS["news_pictures_grid"] = new cnews_pictures_grid(); // get detail page object
			$GLOBALS["news_pictures_grid"]->ValidateGridForm();
		}

		// Return validate result
		$ValidateForm = ($gsFormError == "");

		// Call Form_CustomValidate event
		$sFormCustomError = "";
		$ValidateForm = $ValidateForm && $this->Form_CustomValidate($sFormCustomError);
		if ($sFormCustomError <> "") {
			ew_AddMessage($gsFormError, $sFormCustomError);
		}
		return $ValidateForm;
	}

	// Add record
	function AddRow($rsold = NULL) {
		global $conn, $Language, $Security;

		// Begin transaction
		if ($this->getCurrentDetailTable() <> "")
			$conn->BeginTrans();

		// Load db values from rsold
		if ($rsold) {
			$this->LoadDbValues($rsold);
			$this->banner_picture->OldUploadPath = "../uploads/banners";
			$this->banner_picture->UploadPath = $this->banner_picture->OldUploadPath;
			$this->thumb->OldUploadPath = "../uploads/projects/thumb";
			$this->thumb->UploadPath = $this->thumb->OldUploadPath;
			$this->pdf->OldUploadPath = "../uploads/projects/pdf";
			$this->pdf->UploadPath = $this->pdf->OldUploadPath;
		}
		$rsnew = array();

		// title
		$this->title->SetDbValueDef($rsnew, $this->title->CurrentValue, "", FALSE);

		// banner_picture
		if (!$this->banner_picture->Upload->KeepFile) {
			if ($this->banner_picture->Upload->FileName == "") {
				$rsnew['banner_picture'] = NULL;
			} else {
				$rsnew['banner_picture'] = $this->banner_picture->Upload->FileName;
			}
		}

		// thumb
		if (!$this->thumb->Upload->KeepFile) {
			if ($this->thumb->Upload->FileName == "") {
				$rsnew['thumb'] = NULL;
			} else {
				$rsnew['thumb'] = $this->thumb->Upload->FileName;
			}
		}

		// pdf
		if (!$this->pdf->Upload->KeepFile) {
			if ($this->pdf->Upload->FileName == "") {
				$rsnew['pdf'] = NULL;
			} else {
				$rsnew['pdf'] = $this->pdf->Upload->FileName;
			}
		}

		// event_date
		$this->event_date->SetDbValueDef($rsnew, ew_UnFormatDateTime($this->event_date->CurrentValue, 7), NULL, FALSE);

		// description
		$this->description->SetDbValueDef($rsnew, $this->description->CurrentValue, NULL, FALSE);
		if (!$this->banner_picture->Upload->KeepFile) {
			$this->banner_picture->UploadPath = "../uploads/banners";
			if (!ew_Empty($this->banner_picture->Upload->Value)) {
				$rsnew['banner_picture'] = ew_UploadFileNameEx(ew_UploadPathEx(TRUE, $this->banner_picture->UploadPath), $rsnew['banner_picture']); // Get new file name
			}
		}
		if (!$this->thumb->Upload->KeepFile) {
			$this->thumb->UploadPath = "../uploads/projects/thumb";
			if (!ew_Empty($this->thumb->Upload->Value)) {
				$rsnew['thumb'] = ew_UploadFileNameEx(ew_UploadPathEx(TRUE, $this->thumb->UploadPath), $rsnew['thumb']); // Get new file name
			}
		}
		if (!$this->pdf->Upload->KeepFile) {
			$this->pdf->UploadPath = "../uploads/projects/pdf";
			if (!ew_Empty($this->pdf->Upload->Value)) {
				$rsnew['pdf'] = ew_UploadFileNameEx(ew_UploadPathEx(TRUE, $this->pdf->UploadPath), $rsnew['pdf']); // Get new file name
			}
		}

		// Call Row Inserting event
		$rs = ($rsold == NULL) ? NULL : $rsold->fields;
		$bInsertRow = $this->Row_Inserting($rs, $rsnew);
		if ($bInsertRow) {
			$conn->raiseErrorFn = 'ew_ErrorFn';
			$AddRow = $this->Insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($AddRow) {
				if (!$this->banner_picture->Upload->KeepFile) {
					if (!ew_Empty($this->banner_picture->Upload->Value)) {
						$this->banner_picture->Upload->SaveToFile($this->banner_picture->UploadPath, $rsnew['banner_picture'], TRUE);
					}
				}
				if (!$this->thumb->Upload->KeepFile) {
					if (!ew_Empty($this->thumb->Upload->Value)) {
						$this->thumb->Upload->SaveToFile($this->thumb->UploadPath, $rsnew['thumb'], TRUE);
					}
				}
				if (!$this->pdf->Upload->KeepFile) {
					if (!ew_Empty($this->pdf->Upload->Value)) {
						$this->pdf->Upload->SaveToFile($this->pdf->UploadPath, $rsnew['pdf'], TRUE);
					}
				}
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->Phrase("InsertCancelled"));
			}
			$AddRow = FALSE;
		}

		// Get insert id if necessary
		if ($AddRow) {
			$this->id->setDbValue($conn->Insert_ID());
			$rsnew['id'] = $this->id->DbValue;
		}

		// Add detail records
		if ($AddRow) {
			$DetailTblVar = explode(",", $this->getCurrentDetailTable());
			if (in_array("news_pictures", $DetailTblVar) && $GLOBALS["news_pictures"]->DetailAdd) {
				$GLOBALS["news_pictures"]->fr_id->setSessionValue($this->id->CurrentValue); // Set master key
				if (!isset($GLOBALS["news_pictures_grid"])) $GLOBALS["news_pictures_grid"] = new cnews_pictures_grid(); // Get detail page object
				$AddRow = $GLOBALS["news_pictures_grid"]->GridInsert();
				if (!$AddRow)
					$GLOBALS["news_pictures"]->fr_id->setSessionValue(""); // Clear master key if insert failed
			}
		}

		// Commit/Rollback transaction
		if ($this->getCurrentDetailTable() <> "") {
			if ($AddRow) {
				$conn->CommitTrans(); // Commit transaction
			} else {
				$conn->RollbackTrans(); // Rollback transaction
			}
		}
		if ($AddRow) {

			// Call Row Inserted event
			$rs = ($rsold == NULL) ? NULL : $rsold->fields;
			$this->Row_Inserted($rs, $rsnew);
		}

		// banner_picture
		ew_CleanUploadTempPath($this->banner_picture, $this->banner_picture->Upload->Index);

		// thumb
		ew_CleanUploadTempPath($this->thumb, $this->thumb->Upload->Index);

		// pdf
		ew_CleanUploadTempPath($this->pdf, $this->pdf->Upload->Index);
		return $AddRow;
	}

	// Set up detail parms based on QueryString
	function SetUpDetailParms() {

		// Get the keys for master table
		if (isset($_GET[EW_TABLE_SHOW_DETAIL])) {
			$sDetailTblVar = $_GET[EW_TABLE_SHOW_DETAIL];
			$this->setCurrentDetailTable($sDetailTblVar);
		} else {
			$sDetailTblVar = $this->getCurrentDetailTable();
		}
		if ($sDetailTblVar <> "") {
			$DetailTblVar = explode(",", $sDetailTblVar);
			if (in_array("news_pictures", $DetailTblVar)) {
				if (!isset($GLOBALS["news_pictures_grid"]))
					$GLOBALS["news_pictures_grid"] = new cnews_pictures_grid;
				if ($GLOBALS["news_pictures_grid"]->DetailAdd) {
					if ($this->CopyRecord)
						$GLOBALS["news_pictures_grid"]->CurrentMode = "copy";
					else
						$GLOBALS["news_pictures_grid"]->CurrentMode = "add";
					$GLOBALS["news_pictures_grid"]->CurrentAction = "gridadd";

					// Save current master table to detail table
					$GLOBALS["news_pictures_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["news_pictures_grid"]->setStartRecordNumber(1);
					$GLOBALS["news_pictures_grid"]->fr_id->FldIsDetailKey = TRUE;
					$GLOBALS["news_pictures_grid"]->fr_id->CurrentValue = $this->id->CurrentValue;
					$GLOBALS["news_pictures_grid"]->fr_id->setSessionValue($GLOBALS["news_pictures_grid"]->fr_id->CurrentValue);
				}
			}
		}
	}

	// Set up Breadcrumb
	function SetupBreadcrumb() {
		global $Breadcrumb, $Language;
		$Breadcrumb = new cBreadcrumb();
		$PageCaption = $this->TableCaption();
		$Breadcrumb->Add("list", "<span id=\"ewPageCaption\">" . $PageCaption . "</span>", "newslist.php", $this->TableVar);
		$PageCaption = ($this->CurrentAction == "C") ? $Language->Phrase("Copy") : $Language->Phrase("Add");
		$Breadcrumb->Add("add", "<span id=\"ewPageCaption\">" . $PageCaption . "</span>", ew_CurrentUrl(), $this->TableVar);
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$CustomError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>
<?php ew_Header(FALSE) ?>
<?php

// Create page object
if (!isset($news_add)) $news_add = new cnews_add();

// Page init
$news_add->Page_Init();

// Page main
$news_add->Page_Main();

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$news_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script type="text/javascript">

// Page object
var news_add = new ew_Page("news_add");
news_add.PageID = "add"; // Page ID
var EW_PAGE_ID = news_add.PageID; // For backward compatibility

// Form object
var fnewsadd = new ew_Form("fnewsadd");

// Validate form
fnewsadd.Validate = function() {
	if (!this.ValidateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.GetForm(), $fobj = $(fobj);
	this.PostAutoSuggest();
	if ($fobj.find("#a_confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.FormKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = $fobj.find("#a_list").val() == "gridinsert";
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
			elm = this.GetElements("x" + infix + "_title");
			if (elm && !ew_HasValue(elm))
				return this.OnError(elm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($news->title->FldCaption()) ?>");
			felm = this.GetElements("x" + infix + "_banner_picture");
			elm = this.GetElements("fn_x" + infix + "_banner_picture");
			if (felm && elm && !ew_HasValue(elm))
				return this.OnError(felm, ewLanguage.Phrase("EnterRequiredField") + " - <?php echo ew_JsEncode2($news->banner_picture->FldCaption()) ?>");
			elm = this.GetElements("x" + infix + "_event_date");
			if (elm && !ew_CheckEuroDate(elm.value))
				return this.OnError(elm, "<?php echo ew_JsEncode2($news->event_date->FldErrMsg()) ?>");

			// Set up row object
			ew_ElementsToRow(fobj);

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ewForms[val])
			if (!ewForms[val].Validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fnewsadd.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!

 	// Your custom validation code here, return false if invalid. 
 	return true;
 }

// Use JavaScript validation or not
<?php if (EW_CLIENT_VALIDATE) { ?>
fnewsadd.ValidateRequired = true;
<?php } else { ?>
fnewsadd.ValidateRequired = false; 
<?php } ?>

// Dynamic selection lists
// Form object for search

</script>
<script type="text/javascript">

// Write your client script here, no need to add script tags.
</script>
<?php $Breadcrumb->Render(); ?>
<?php $news_add->ShowPageHeader(); ?>
<?php
$news_add->ShowMessage();
?>
<form name="fnewsadd" id="fnewsadd" class="ewForm form-horizontal" action="<?php echo ew_CurrentPage() ?>" method="post">
<input type="hidden" name="t" value="news">
<input type="hidden" name="a_add" id="a_add" value="A">
<table cellspacing="0" class="ewGrid"><tr><td>
<table id="tbl_newsadd" class="table table-bordered table-striped">
<?php if ($news->title->Visible) { // title ?>
	<tr id="r_title">
		<td><span id="elh_news_title"><?php echo $news->title->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $news->title->CellAttributes() ?>>
<span id="el_news_title" class="control-group">
<input type="text" data-field="x_title" name="x_title" id="x_title" size="30" maxlength="250" placeholder="<?php echo $news->title->PlaceHolder ?>" value="<?php echo $news->title->EditValue ?>"<?php echo $news->title->EditAttributes() ?>>
</span>
<?php echo $news->title->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($news->banner_picture->Visible) { // banner_picture ?>
	<tr id="r_banner_picture">
		<td><span id="elh_news_banner_picture"><?php echo $news->banner_picture->FldCaption() ?><?php echo $Language->Phrase("FieldRequiredIndicator") ?></span></td>
		<td<?php echo $news->banner_picture->CellAttributes() ?>>
<span id="el_news_banner_picture" class="control-group">
<span id="fd_x_banner_picture">
<span class="btn btn-small fileinput-button">
	<span><?php echo $Language->Phrase("ChooseFile") ?></span>
	<input type="file" data-field="x_banner_picture" name="x_banner_picture" id="x_banner_picture">
</span>
<input type="hidden" name="fn_x_banner_picture" id= "fn_x_banner_picture" value="<?php echo $news->banner_picture->Upload->FileName ?>">
<input type="hidden" name="fa_x_banner_picture" id= "fa_x_banner_picture" value="0">
<input type="hidden" name="fs_x_banner_picture" id= "fs_x_banner_picture" value="250">
</span>
<table id="ft_x_banner_picture" class="table table-condensed pull-left ewUploadTable"><tbody class="files"></tbody></table>
</span>
<?php echo $news->banner_picture->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($news->thumb->Visible) { // thumb ?>
	<tr id="r_thumb">
		<td><span id="elh_news_thumb"><?php echo $news->thumb->FldCaption() ?></span></td>
		<td<?php echo $news->thumb->CellAttributes() ?>>
<span id="el_news_thumb" class="control-group">
<span id="fd_x_thumb">
<span class="btn btn-small fileinput-button">
	<span><?php echo $Language->Phrase("ChooseFile") ?></span>
	<input type="file" data-field="x_thumb" name="x_thumb" id="x_thumb">
</span>
<input type="hidden" name="fn_x_thumb" id= "fn_x_thumb" value="<?php echo $news->thumb->Upload->FileName ?>">
<input type="hidden" name="fa_x_thumb" id= "fa_x_thumb" value="0">
<input type="hidden" name="fs_x_thumb" id= "fs_x_thumb" value="250">
</span>
<table id="ft_x_thumb" class="table table-condensed pull-left ewUploadTable"><tbody class="files"></tbody></table>
</span>
<?php echo $news->thumb->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($news->pdf->Visible) { // pdf ?>
	<tr id="r_pdf">
		<td><span id="elh_news_pdf"><?php echo $news->pdf->FldCaption() ?></span></td>
		<td<?php echo $news->pdf->CellAttributes() ?>>
<span id="el_news_pdf" class="control-group">
<span id="fd_x_pdf">
<span class="btn btn-small fileinput-button">
	<span><?php echo $Language->Phrase("ChooseFile") ?></span>
	<input type="file" data-field="x_pdf" name="x_pdf" id="x_pdf">
</span>
<input type="hidden" name="fn_x_pdf" id= "fn_x_pdf" value="<?php echo $news->pdf->Upload->FileName ?>">
<input type="hidden" name="fa_x_pdf" id= "fa_x_pdf" value="0">
<input type="hidden" name="fs_x_pdf" id= "fs_x_pdf" value="250">
</span>
<table id="ft_x_pdf" class="table table-condensed pull-left ewUploadTable"><tbody class="files"></tbody></table>
</span>
<?php echo $news->pdf->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($news->event_date->Visible) { // event_date ?>
	<tr id="r_event_date">
		<td><span id="elh_news_event_date"><?php echo $news->event_date->FldCaption() ?></span></td>
		<td<?php echo $news->event_date->CellAttributes() ?>>
<span id="el_news_event_date" class="control-group">
<input type="text" data-field="x_event_date" name="x_event_date" id="x_event_date" placeholder="<?php echo $news->event_date->PlaceHolder ?>" value="<?php echo $news->event_date->EditValue ?>"<?php echo $news->event_date->EditAttributes() ?>>
<?php if (!$news->event_date->ReadOnly && !$news->event_date->Disabled && @$news->event_date->EditAttrs["readonly"] == "" && @$news->event_date->EditAttrs["disabled"] == "") { ?>
<button id="cal_x_event_date" name="cal_x_event_date" class="btn" type="button"><img src="phpimages/calendar.png" id="cal_x_event_date" alt="<?php echo $Language->Phrase("PickDate") ?>" title="<?php echo $Language->Phrase("PickDate") ?>" style="border: 0;"></button><script type="text/javascript">
ew_CreateCalendar("fnewsadd", "x_event_date", "%d/%m/%Y");
</script>
<?php } ?>
</span>
<?php echo $news->event_date->CustomMsg ?></td>
	</tr>
<?php } ?>
<?php if ($news->description->Visible) { // description ?>
	<tr id="r_description">
		<td><span id="elh_news_description"><?php echo $news->description->FldCaption() ?></span></td>
		<td<?php echo $news->description->CellAttributes() ?>>
<span id="el_news_description" class="control-group">
<textarea data-field="x_description" class="editor" name="x_description" id="x_description" cols="35" rows="4" placeholder="<?php echo $news->description->PlaceHolder ?>"<?php echo $news->description->EditAttributes() ?>><?php echo $news->description->EditValue ?></textarea>
<script type="text/javascript">
ew_CreateEditor("fnewsadd", "x_description", 35, 4, <?php echo ($news->description->ReadOnly || FALSE) ? "true" : "false" ?>);
</script>
</span>
<?php echo $news->description->CustomMsg ?></td>
	</tr>
<?php } ?>
</table>
</td></tr></table>
<?php
	if (in_array("news_pictures", explode(",", $news->getCurrentDetailTable())) && $news_pictures->DetailAdd) {
?>
<?php include_once "news_picturesgrid.php" ?>
<?php } ?>
<button class="btn btn-primary ewButton" name="btnAction" id="btnAction" type="submit"><?php echo $Language->Phrase("AddBtn") ?></button>
</form>
<script type="text/javascript">
fnewsadd.Init();
<?php if (EW_MOBILE_REFLOW && ew_IsMobile()) { ?>
ew_Reflow();
<?php } ?>
</script>
<?php
$news_add->ShowPageFooter();
if (EW_DEBUG_ENABLED)
	echo ew_DebugMsg();
?>
<script type="text/javascript">

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$news_add->Page_Terminate();
?>
