<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Career extends Base_Controller {

    public function view_page()
    {
         $data['core_data'] = $this->load_site_core();
         $this->load->view('career', $data);	
    }

    public function process()
    {
        $this->load->helper(array('form', 'url'));   
        $u_name = $this->input->post("c_name");
        $u_email = $this->input->post("c_email");
        $u_mobile = $this->input->post("c_mobile");
        $u_gender = $this->input->post("c_gender");
        $u_dob = $this->input->post("c_dob");
        $u_dob_arr = explode("/", $u_dob);
        if(count($u_dob_arr) == 3)
        {
            $u_dob = $u_dob_arr[1].'-'.$u_dob_arr[0].'-'.$u_dob_arr[2];
        }
        $u_desc = $this->input->post("c_message");
        
        $sec_code_ul = $this->input->post("sec_code");
        $captcha_code = trim($_SESSION['captcha']);

        $data = array();
        $data['captcha_not_matched'] = 0;
        if(($sec_code_ul != $captcha_code) || $_SESSION['captcha']=="" || !isset($_SESSION['captcha']))
        {
            $data['captcha_not_matched'] = 1;
            $this->load->view('career_iframe', $data);
        }
        else{
            unset($_SESSION['captcha']);
            $config['file_name'] = 'ft_'.time().rand(1,4657456);
            $config['overwrite'] = false;
            $config['upload_path'] = './uploads/careers/';
            $config['allowed_types'] = 'pdf|jpg';
            $this->load->library('upload', $config);

            if($this->upload->do_upload('c_upload_cv'))   
            {
                $file_name_data = $this->upload->data();
                $file_name = $file_name_data['file_name'];
            }
            else{
                $data['captcha_not_matched'] = 2;
                $this->load->view('career_iframe', $data);
            }

            if($data['captcha_not_matched'] == 0)
            {
                $mail_msg = '<table width="700" cellpadding="0" cellspacing="0" style="font-family:arial,verdana;font-size:13px;color:#555555;line-height:22px;border-collapse:collapse;">    
                            <tbody>
                                    <tr>
                                            <td style="padding:10px;border-collapse:collapse;font-weight:bold;color:#000000;background-color:#eeeeee;vertical-align:top;border:1px solid #aaaaaa;" width="140"> Contact Name </td>
                                            <td style="padding:10px;border-collapse:collapse;vertical-align:top;border:1px solid #aaaaaa;">'.$u_name.'</td>
                                    </tr> 
                                    <tr>
                                            <td style="vertical-align:top;border:1px solid #aaaaaa;padding:10px;border-collapse:collapse;font-weight:bold;color:#000000;background-color:#eeeeee;" width="140">Email</td>
                                            <td style="vertical-align:top;border:1px solid #aaaaaa;padding:10px;border-collapse:collapse;">'.$u_email.'</td>
                                    </tr>
                                    <tr>
                                            <td style="vertical-align:top;border:1px solid #aaaaaa;padding:10px;border-collapse:collapse;font-weight:bold;color:#000000;background-color:#eeeeee;">Mobile No. </td>
                                            <td style="vertical-align:top;border:1px solid #aaaaaa;padding:10px;border-collapse:collapse;">'.$u_mobile.'</td>
                                    </tr>
                                    <tr>
                                            <td style="vertical-align:top;border:1px solid #aaaaaa;padding:10px;border-collapse:collapse;font-weight:bold;color:#000000;background-color:#eeeeee;">Date of Birth</td>
                                            <td style="vertical-align:top;border:1px solid #aaaaaa;padding:10px;border-collapse:collapse;">'.$u_dob.'</td>
                                    </tr>
                                    <tr>
                                            <td style="vertical-align:top;border:1px solid #aaaaaa;padding:10px;border-collapse:collapse;font-weight:bold;color:#000000;background-color:#eeeeee;">Gender </td>
                                            <td style="vertical-align:top;border:1px solid #aaaaaa;padding:10px;border-collapse:collapse;">'.$u_gender.'</td>
                                    </tr>                                                                                                                                                                                                                                        
                                    <tr>
                                            <td colspan="2" style="padding:0px;"> 
                                                    <div style="width:100%;"> 
                                                            <br/>
                                                            <table cellpadding="0" cellspacing="0" style="width:100%;font-family:arial,verdana;font-size:13px;color:#555555;line-height:22px;border-collapse:collapse;">
                                                                    <tbody>
                                                                            <tr>
                                                                                    <td style="padding:10px;border-collapse:collapse;font-weight:bold;color:#000000;background-color:#eeeeee;text-align:left;border-top:1px solid #aaaaaa;border-bottom:1px solid #aaaaaa;" colspan="2">Message</td>
                                                                            </tr>
                                                                            <tr>
                                                                                    <td style="padding:10px;border-collapse:collapse;" colspan="2">'.$u_desc.'</td>
                                                                            </tr>                               
                                                                    </tbody>
                                                            </table>
                                                    </div>  
                                            </td>
                                    </tr>

                            </tbody>
                    </table>';
                        
                    $mail_title = 'Almawazeen | Job Email (CV in attachment)';       

                    $this->load->library('email');
                    $config['mailtype'] = 'html';
                    $config['wordwrap'] = TRUE;
                    $this->email->initialize($config);  

                    $this->email->from(EMAIL_SENDER, $u_name);              
                    $this->email->to(EMAIL_RECIPIENT); 
                    $this->email->subject($mail_title);
                    $this->email->message($mail_msg);
                    $this->email->attach('uploads/careers/'.$file_name);
                    $this->email->send();                    
                    $data['email_sent'] = 1;
                    $this->load->view('career_iframe', $data); 
            }      
        }
    }   
}


