<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends Base_Controller {

    public function index()
    {
        $data['core_data'] = $this->load_site_core();            

        $qry = $this->db->query("SELECT id, title, banner_picture FROM news ORDER BY id DESC LIMIT 5");
        $data["banner_data"] = $qry->result_array();

        $qry = $this->db->query("SELECT * FROM home_blocks");
        $data["blocks_data"] = $qry->result_array();
        
        $this->load->view('home', $data);	
    }

    public function txt_page_view($txt_page = '')
    {
        $data['core_data'] = $this->load_site_core();
        $this->load->view('txt_page', $data);
    }

    public function contact()
    {
        $data['core_data'] = $this->load_site_core();                
        $this->load->view('contact', $data);                
    }

    public function search()
    {
        $s_query = $this->db->escape_str($this->input->get('sq'));
        $data['core_data'] = $this->load_site_core();   

        $data['search_result_arr'] = array();
        if(isset($s_query) && trim($s_query) != "")
        {
            $qry = $this->db->query("SELECT title, page_url FROM pages_data WHERE (title like '%".$s_query."%' or description like '%".$s_query."%') and page_url NOT IN ('download_file', 'search')");
            $data['search_result_arr'] = $qry->result_array();
            if(count($data['search_result_arr']) == 0)
            {
                $data['search_result_msg'] = '<h2> No results found </h2>';
            }                    
        }
        else
        {
            $data['search_result_msg'] = '<h2> Search term can not be empty </h2>';
        }
        
        $this->load->view('search', $data);        
    }  

    public function contact_process()
    {       
        $this->load->helper('email');

        $u_name = $this->input->post("c_name");
        $u_email = $this->input->post("c_email");
        $u_mobile = $this->input->post("c_mobile");

        $u_company = '';
        if(isset($_POST["c_company"]))
        {
            $u_company = '<tr>
                            <td style="vertical-align:top;border:1px solid #aaaaaa;padding:10px;border-collapse:collapse;font-weight:bold;color:#000000;background-color:#eeeeee;">Company </td>
                            <td style="vertical-align:top;border:1px solid #aaaaaa;padding:10px;border-collapse:collapse;">'.$this->input->post("c_company").'</td>
                        </tr>';
        }
        $u_desc = $this->input->post("c_message");
        $sec_code_ul = $this->input->post("sec_code");
        $captcha_code = trim($_SESSION['captcha']);

        if(trim($u_name) == "")
        {
            echo "name_not_blank";
            return false;
        }

        $req_email = $u_email;

        if(!valid_email($req_email))
        {
            echo 'Email is Invalid';
            return false;
        }                            

        if($sec_code_ul != $captcha_code || $captcha_code == "")
        {
            $_SESSION['captcha'] = "";
            echo "invalid_captcha";
            return false;
        }


        $_SESSION['captcha'] = "";
        $mail_msg = '<table width="700" cellpadding="0" cellspacing="0" style="font-family:arial,verdana;font-size:13px;color:#555555;line-height:22px;border-collapse:collapse;">    
                            <tbody>
                                    <tr>
                                            <td style="padding:10px;border-collapse:collapse;font-weight:bold;color:#000000;background-color:#eeeeee;vertical-align:top;border:1px solid #aaaaaa;" width="140"> Contact Name </td>
                                            <td style="padding:10px;border-collapse:collapse;vertical-align:top;border:1px solid #aaaaaa;">'.$u_name.'</td>
                                    </tr> 
                                    '.$u_company.'                                                      
                                    <tr>
                                            <td style="vertical-align:top;border:1px solid #aaaaaa;padding:10px;border-collapse:collapse;font-weight:bold;color:#000000;background-color:#eeeeee;" width="140">Email</td>
                                            <td style="vertical-align:top;border:1px solid #aaaaaa;padding:10px;border-collapse:collapse;">'.$u_email.'</td>
                                    </tr>
                                    <tr>
                                            <td style="vertical-align:top;border:1px solid #aaaaaa;padding:10px;border-collapse:collapse;font-weight:bold;color:#000000;background-color:#eeeeee;">Mobile No. </td>
                                            <td style="vertical-align:top;border:1px solid #aaaaaa;padding:10px;border-collapse:collapse;">'.$u_mobile.'</td>
                                    </tr>                                    
                                    <tr>
                                            <td colspan="2" style="padding:0px;"> 
                                                    <div style="width:100%;"> 
                                                            <br/>
                                                            <table cellpadding="0" cellspacing="0" style="width:100%;font-family:arial,verdana;font-size:13px;color:#555555;line-height:22px;border-collapse:collapse;">
                                                                    <tbody>
                                                                            <tr>
                                                                                    <td style="padding:10px;border-collapse:collapse;font-weight:bold;color:#000000;background-color:#eeeeee;text-align:left;border-top:1px solid #aaaaaa;border-bottom:1px solid #aaaaaa;" colspan="2">User Query</td>
                                                                            </tr>
                                                                            <tr>
                                                                                    <td style="padding:10px;border-collapse:collapse;" colspan="2">'.$u_desc.'</td>
                                                                            </tr>                               
                                                                    </tbody>
                                                            </table>
                                                    </div>  
                                            </td>
                                    </tr>

                            </tbody>
                    </table>';
        
        $mail_title = 'Enquiry Email';       

        $this->load->library('email');
        $config['mailtype'] = 'html';
        $config['wordwrap'] = TRUE;
        $this->email->initialize($config);  
        
        $this->email->from(EMAIL_SENDER, $u_name);              
        $this->email->to(EMAIL_RECIPIENT); 
        $this->email->subject($mail_title);
        $this->email->message($mail_msg);
        $this->email->send();                
    }

    public function download_file()
    {
        $file_name = $this->input->get('file_name');
        $file_name = urldecode($file_name);
        $file_fs = substr($file_name, 0, 1);
        if($file_fs == "/")
        {
            $file_name = $_SERVER['DOCUMENT_ROOT'].$file_name;                
        }
        else
        {
            $file_name = realpath(getcwd().'/'.$file_name);
        }
        
        $pathinfo_parts = pathinfo($file_name);
        if($pathinfo_parts['extension'] == "php")
        {
            die("<h1> Invalid file </h1>");
        }

        $file_name = str_replace(array("../",".."), "", $file_name);
        $save_name = str_replace(" ", "", basename($file_name));
        
        if (file_exists($file_name)) {
            header('Content-Description: File Transfer');
            header('Content-Type: application/octet-stream');
            header('Content-Disposition: attachment; filename='.basename($save_name));
            header('Expires: 0');
            header('Cache-Control: must-revalidate');
            header('Pragma: public');
            header('Content-Length: ' . filesize($file_name));
            readfile($file_name);
            exit;
        }               
    }

    public function sitemap()
    {
        $data['core_data'] = $this->load_site_core();                
        $this->load->view('sitemap', $data);          
    }       
}


