<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Projects extends Base_Controller {

    public function index($tb_name)
    {
        $tb_name = $this->db->escape_str($tb_name);
        $p_url_list = array('news' => 'news', 'academic' => 'academic');
        $data['p_url'] = $p_url_list[$tb_name];
        $data['core_data'] = $this->load_site_core();

        $qry = $this->db->query("SELECT id, title, thumb, pdf, DATE_FORMAT(event_date, '%d %M, %Y') as news_date FROM $tb_name ORDER BY id DESC");
        $data['news_list'] = $qry->result_array();

        $this->load->view('project_list', $data);	
    } 

    public function project_detail($tb_name, $project_id)
    {
        $tb_name = $this->db->escape_str($tb_name);
        $p_picture_tb_list = array('academic' => 'academic_pictures', 'news' => 'news_pictures');
        $tb_name_picture = $p_picture_tb_list[$tb_name];

        $news_id = (int) $project_id;
        $data['core_data'] = $this->load_site_core();        
        
        $qry = $this->db->query("SELECT id, title, thumb, pdf, DATE_FORMAT(event_date, '%d %M, %Y') as news_date, description FROM $tb_name WHERE id = $news_id LIMIT 1");
        $data['news_row'] = $qry->row_array();

        $data['core_data']['page_data']['title'] = substr($data['news_row']['title'], 0, 50);
        $data['core_data']['page_data']['meta_description'] = str_replace("\n", " ", strip_tags(substr($data['news_row']['description'], 0, 500)));

        $qry = $this->db->query("SELECT * FROM $tb_name_picture WHERE fr_id = $news_id");
        $data["news_pictures"] = $qry->result_array();

        $this->load->view('project_detail', $data);    
    }   
}


